/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.rfc5545.calendarmetrics;

import java.util.TimeZone;
import org.dmfs.rfc5545.Instance;
import org.dmfs.rfc5545.Weekday;

public abstract class CalendarMetrics {
    public final Weekday weekStart;
    public final int weekStartInt;
    public final int minDaysInFirstWeek;
    private final String mName;

    public CalendarMetrics(String name, Weekday weekStart, int minDaysInFirstWeek) {
        this.weekStart = weekStart;
        this.weekStartInt = weekStart.ordinal();
        this.minDaysInFirstWeek = minDaysInFirstWeek;
        this.mName = name;
    }

    public static int monthAndDay(int packedMonth, int day) {
        return (packedMonth << 8) + day;
    }

    public static int packedMonth(int monthAndDay) {
        return monthAndDay >> 8;
    }

    public static int dayOfMonth(int monthAndDay) {
        return monthAndDay & 0xFF;
    }

    public int packedMonth(String month) {
        if (month == null) {
            throw new IllegalArgumentException("month strings must not be null");
        }
        int len = month.length();
        if (len == 0 || len > 3) {
            throw new IllegalArgumentException("illegal month string " + month);
        }
        char lastChar = month.charAt(len - 1);
        int leapBit = lastChar == 'L' || lastChar == 'l' ? 1 : 0;
        try {
            return Integer.parseInt(month.substring(0, len - leapBit)) - 1 << 1 + leapBit;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("illegal month string " + month, e);
        }
    }

    public String packedMonthToString(int packedMonth) {
        if ((packedMonth & 1) == 1) {
            return String.valueOf(packedMonth >>> 1) + "L";
        }
        return String.valueOf(packedMonth >>> 1);
    }

    public int packedMonth(int monthNum, boolean leapMonth) {
        return leapMonth ? monthNum << 2 : monthNum << 1;
    }

    public boolean isLeapMonth(int packedMonth) {
        return (packedMonth & 1) == 1;
    }

    public int monthNum(int packedMonth) {
        return packedMonth >>> 1;
    }

    public abstract int getMaxMonthDayNum();

    public abstract int getMaxYearDayNum();

    public abstract int getMaxWeekNoNum();

    public abstract int getDaysPerPackedMonth(int var1, int var2);

    public abstract int getPackedMonthOfYearDay(int var1, int var2);

    public abstract int getDayOfMonthOfYearDay(int var1, int var2);

    public abstract int getMonthAndDayOfYearDay(int var1, int var2);

    public abstract int getYearDaysForPackedMonth(int var1, int var2);

    public abstract int getMonthsPerYear(int var1);

    public abstract int getDaysPerYear(int var1);

    public abstract int getWeeksPerYear(int var1);

    public int getWeekOfYear(int year, int packedMonth, int dayOfMonth) {
        return this.getWeekOfYear(year, this.getDayOfYear(year, packedMonth, dayOfMonth));
    }

    public abstract int getWeekOfYear(int var1, int var2);

    public int getDayOfWeek(int year, int yearDay) {
        return (this.getWeekDayOfFirstYearDay(year) + yearDay - 1) % 7;
    }

    public int getDayOfWeek(int year, int packedMonth, int dayOfMonth) {
        return this.getDayOfWeek(year, this.getDayOfYear(year, packedMonth, dayOfMonth));
    }

    public abstract int getDayOfYear(int var1, int var2, int var3);

    public abstract int getYearDayOfIsoYear(int var1, int var2, int var3);

    public abstract int getWeekDayOfFirstYearDay(int var1);

    public abstract int getYearDayOfFirstWeekStart(int var1);

    public abstract int getYearDayOfWeekStart(int var1, int var2);

    public long toMillis(long instance, TimeZone timeZone) {
        return this.toMillis(timeZone == null || "UTC".equals(timeZone.getID()) ? null : timeZone, Instance.year(instance), Instance.month(instance), Instance.dayOfMonth(instance), Instance.hour(instance), Instance.minute(instance), Instance.second(instance), 0);
    }

    public abstract long toMillis(TimeZone var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8);

    public abstract long toInstance(long var1, TimeZone var3);

    public boolean validate(long instance) {
        int year = Instance.year(instance);
        int month = Instance.month(instance);
        if (month < 0 || month >= this.getMonthsPerYear(year)) {
            return false;
        }
        int day = Instance.dayOfMonth(instance);
        if (day < 1 || day > this.getDaysPerPackedMonth(year, month)) {
            return false;
        }
        int hour = Instance.hour(instance);
        if (hour < 0 || hour > 23) {
            return false;
        }
        int minute = Instance.minute(instance);
        if (minute < 0 || minute > 59) {
            return false;
        }
        int second = Instance.second(instance);
        return second >= 0 && second <= 59;
    }

    public abstract long nextMonth(long var1);

    public abstract long nextMonth(long var1, int var3);

    public abstract long prevMonth(long var1);

    public abstract long prevMonth(long var1, int var3);

    public abstract long nextDay(long var1);

    public abstract long nextDay(long var1, int var3);

    public abstract long prevDay(long var1);

    public abstract long prevDay(long var1, int var3);

    public long startOfWeek(long instance) {
        int currentDayOfWeek = this.getDayOfWeek(Instance.year(instance), Instance.month(instance), Instance.dayOfMonth(instance));
        int offset = (this.weekStartInt - currentDayOfWeek - 7) % 7;
        if (offset == 0) {
            return instance;
        }
        if (offset == -1) {
            return this.prevDay(instance);
        }
        return this.prevDay(instance, -offset);
    }

    public long setDayOfWeek(long instance, int dayOfWeek) {
        int currentDayOfWeek = this.getDayOfWeek(Instance.year(instance), Instance.month(instance), Instance.dayOfMonth(instance));
        int offset = (this.weekStartInt - currentDayOfWeek - 7) % 7 + (dayOfWeek - this.weekStartInt + 7) % 7;
        switch (offset) {
            case -6: 
            case -5: 
            case -4: 
            case -3: 
            case -2: {
                return this.prevDay(instance, -offset);
            }
            case -1: {
                return this.prevDay(instance);
            }
            case 0: {
                return instance;
            }
            case 1: {
                return this.nextDay(instance);
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return this.nextDay(instance, offset);
            }
        }
        return instance;
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CalendarMetrics)) {
            return false;
        }
        return this.getClass() == obj.getClass() && this.minDaysInFirstWeek == ((CalendarMetrics)obj).minDaysInFirstWeek && this.weekStart == ((CalendarMetrics)obj).weekStart;
    }

    public String toString() {
        return this.mName;
    }

    public boolean scaleEquals(CalendarMetrics obj) {
        return this.getClass() == obj.getClass();
    }

    public static abstract class CalendarMetricsFactory {
        public abstract CalendarMetrics getCalendarMetrics(Weekday var1);
    }
}

