/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.rfc5545.calendarmetrics;

import java.util.TimeZone;
import org.dmfs.rfc5545.Instance;
import org.dmfs.rfc5545.Weekday;
import org.dmfs.rfc5545.calendarmetrics.CalendarMetrics;
import org.dmfs.rfc5545.calendarmetrics.NoLeapMonthCalendarMetrics;

public class GregorianCalendarMetrics
extends NoLeapMonthCalendarMetrics {
    public static final String CALENDAR_SCALE_ALIAS = "GREGORIAN";
    public static final CalendarMetrics.CalendarMetricsFactory FACTORY = new CalendarMetrics.CalendarMetricsFactory(){

        @Override
        public CalendarMetrics getCalendarMetrics(Weekday weekStart) {
            return new GregorianCalendarMetrics(GregorianCalendarMetrics.CALENDAR_SCALE_ALIAS, weekStart, 4);
        }

        public String toString() {
            return GregorianCalendarMetrics.CALENDAR_SCALE_ALIAS;
        }
    };
    public static final String CALENDAR_SCALE_NAME = "GREGORY";
    public static final Weekday[] WEEKDAYS = Weekday.values();
    private static final int[] DAYS_PER_MONTH = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final int[] YEARDAYS_PER_MONTH = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334};

    public GregorianCalendarMetrics(Weekday weekStart, int minDaysInFirstWeek) {
        super(CALENDAR_SCALE_ALIAS, weekStart, minDaysInFirstWeek);
    }

    GregorianCalendarMetrics(String name, Weekday weekStart, int minDaysInFirstWeek) {
        super(name, weekStart, minDaysInFirstWeek);
    }

    @Override
    public int getMaxMonthDayNum() {
        return 31;
    }

    @Override
    public int getMaxYearDayNum() {
        return 366;
    }

    @Override
    public int getMaxWeekNoNum() {
        return 53;
    }

    @Override
    public int getDaysPerPackedMonth(int year, int packedMonth) {
        if (packedMonth == 1 && this.isLeapYear(year)) {
            return DAYS_PER_MONTH[packedMonth] + 1;
        }
        return DAYS_PER_MONTH[packedMonth];
    }

    @Override
    public int getYearDaysForPackedMonth(int year, int packedMonth) {
        if (packedMonth > 1 && this.isLeapYear(year)) {
            return YEARDAYS_PER_MONTH[packedMonth] + 1;
        }
        return YEARDAYS_PER_MONTH[packedMonth];
    }

    @Override
    public int getMonthsPerYear() {
        return 12;
    }

    @Override
    public int getDaysPerYear(int year) {
        return this.isLeapYear(year) ? 366 : 365;
    }

    @Override
    public int getWeeksPerYear(int year) {
        int yd1st = this.getYearDayOfFirstWeekStart(year);
        int yearDays = this.getDaysPerYear(year) - yd1st + 1;
        int fullweeks = yearDays / 7;
        int remainingDays = yearDays % 7;
        return 7 - remainingDays >= this.minDaysInFirstWeek ? fullweeks : fullweeks + 1;
    }

    @Override
    public int getWeekOfYear(int year, int yearDay) {
        int yd1st = this.getYearDayOfFirstWeekStart(year);
        if (yearDay < yd1st) {
            int weeksInYear = this.getWeeksPerYear(year - 1);
            return weeksInYear;
        }
        int week = (yearDay - yd1st) / 7 + 1;
        int weeksInYear = this.getWeeksPerYear(year);
        return week > weeksInYear ? week - weeksInYear : week;
    }

    @Override
    public int getDayOfYear(int year, int packedMonth, int dayOfMonth) {
        return this.getYearDaysForPackedMonth(year, packedMonth) + dayOfMonth;
    }

    boolean isLeapYear(int year) {
        return (year & 3) == 0 && year % 100 != 0 || year % 400 == 0;
    }

    @Override
    public int getWeekDayOfFirstYearDay(int year) {
        int y = year - 1;
        return (1 + 5 * (y & 3) + 4 * (y % 100) + 6 * (y % 400)) % 7;
    }

    @Override
    public int getYearDayOfFirstWeekStart(int year) {
        int jan1stWeekDay = this.getWeekDayOfFirstYearDay(year);
        int diff = this.weekStartInt - jan1stWeekDay;
        int yd = 1 + diff;
        return yd > this.minDaysInFirstWeek ? yd - 7 : (yd < this.minDaysInFirstWeek - 6 ? yd + 7 : yd);
    }

    @Override
    public int getPackedMonthOfYearDay(int year, int yearDay) {
        int yearDays;
        while (yearDay < 1) {
            yearDay += this.getDaysPerYear(--year);
        }
        while (yearDay > (yearDays = this.getDaysPerYear(year))) {
            ++year;
            yearDay -= yearDays;
        }
        int month = (yearDay >> 5) + 1;
        if (month < 12 && this.getYearDaysForPackedMonth(year, month) < yearDay) {
            ++month;
        }
        return month - 1;
    }

    @Override
    public int getDayOfMonthOfYearDay(int year, int yearDay) {
        return yearDay - this.getYearDaysForPackedMonth(year, this.getPackedMonthOfYearDay(year, yearDay));
    }

    @Override
    public int getMonthAndDayOfYearDay(int year, int yearDay) {
        int yearDays;
        while (yearDay < 1) {
            yearDay += this.getDaysPerYear(--year);
        }
        while (yearDay > (yearDays = this.getDaysPerYear(year))) {
            ++year;
            yearDay -= yearDays;
        }
        int month = (yearDay >> 5) + 1;
        if (month < 12 && this.getYearDaysForPackedMonth(year, month) < yearDay) {
            ++month;
        }
        return GregorianCalendarMetrics.monthAndDay(--month, yearDay - this.getYearDaysForPackedMonth(year, month));
    }

    @Override
    public int getYearDayOfIsoYear(int year, int weekOfYear, int dayOfWeek) {
        return weekOfYear * 7 - 7 + (dayOfWeek - this.weekStartInt + 7) % 7 + this.getYearDayOfFirstWeekStart(year);
    }

    @Override
    public int getYearDayOfWeekStart(int year, int week) {
        return this.getYearDayOfFirstWeekStart(year) + (week - 1) * 7;
    }

    @Override
    public long toMillis(TimeZone timeZone, int year, int packedMonth, int dayOfMonth, int hours, int minutes, int seconds, int millis) {
        int timeInMillis = ((hours * 60 + minutes) * 60 + seconds) * 1000 + millis;
        int dayOfWeek = this.getDayOfWeek(year, packedMonth, dayOfMonth);
        int dstOffset = timeZone == null ? 0 : timeZone.getOffset(1, year, packedMonth, dayOfMonth, dayOfWeek + 1, timeInMillis) - timeZone.getRawOffset();
        int yearDay = this.getDayOfYear(year, packedMonth, dayOfMonth);
        long localTime = this.getTimeStamp(year, yearDay, hours, minutes, seconds, millis);
        if ((timeInMillis -= dstOffset) < 0) {
            timeInMillis += 86400000;
            if (--dayOfMonth == 0) {
                if (--packedMonth < 0) {
                    packedMonth = this.getMonthsPerYear(--year) - 1;
                }
                dayOfMonth = this.getDaysPerPackedMonth(year, packedMonth);
                dayOfWeek = (dayOfWeek + 6) % 7;
            }
        } else if (timeInMillis >= 86400000) {
            timeInMillis -= 86400000;
            if (++dayOfMonth > this.getDaysPerPackedMonth(year, packedMonth)) {
                if (++packedMonth >= this.getMonthsPerYear(year)) {
                    ++year;
                    packedMonth = 0;
                }
                dayOfMonth = 1;
                dayOfWeek = (dayOfWeek + 1) % 7;
            }
        }
        int offset2 = timeZone == null ? 0 : timeZone.getOffset(1, year, packedMonth, dayOfMonth, dayOfWeek + 1, timeInMillis);
        return localTime - (long)offset2;
    }

    long getTimeStamp(int year, int yearDay, int hours, int minutes, int seconds, int millis) {
        long result = (long)(year - 1970) * 365L;
        result = (result + (long)yearDay - 1L + (long)this.numLeapDaysSince1970(year)) * 24L;
        result = (result + (long)hours) * 60L;
        result = (result + (long)minutes) * 60L;
        result = (result + (long)seconds) * 1000L + (long)millis;
        return result;
    }

    int numLeapDaysSince1970(int year) {
        int prevYear = year - 1;
        int leapYears = prevYear >> 2;
        int nonLeapYears = prevYear / 100;
        int yetLeapYears = nonLeapYears >> 2;
        return leapYears - 492 - (nonLeapYears - 19) + (yetLeapYears - 4);
    }

    @Override
    public long toInstance(long timestamp, TimeZone timeZone) {
        long localTime = timestamp;
        if (timeZone != null) {
            localTime += (long)timeZone.getOffset(timestamp);
        }
        int time = (int)(localTime % 86400000L);
        localTime -= (long)time;
        if (time < 0) {
            time += 86400000;
            localTime -= 86400000L;
        }
        int daysSince1 = (int)(localTime / 86400000L + 718685L + 477L);
        int c400 = daysSince1 / 146097;
        int c400Remainder = daysSince1 % 146097;
        int c100 = Math.min(c400Remainder / 36524, 3);
        int c100Remainder = c400Remainder - c100 * 36524;
        int c4 = Math.min(c100Remainder / 1461, 24);
        int c4Remainder = c100Remainder - c4 * 1461;
        int c1 = Math.min(c4Remainder / 365, 3);
        int c1Remainder = c4Remainder - 365 * c1 + 1;
        int year = ((c400 << 2) + c100) * 100 + (c4 << 2) + c1 + 1;
        int monthAndDay = this.getMonthAndDayOfYearDay(year, c1Remainder);
        int minutes = time / 60000;
        return Instance.make(year, GregorianCalendarMetrics.packedMonth(monthAndDay), GregorianCalendarMetrics.dayOfMonth(monthAndDay), minutes / 60, minutes % 60, time / 1000 % 60);
    }
}

