/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.rfc5545.calendarmetrics;

import java.util.TimeZone;
import org.dmfs.rfc5545.Instance;
import org.dmfs.rfc5545.Weekday;
import org.dmfs.rfc5545.calendarmetrics.CalendarMetrics;
import org.dmfs.rfc5545.calendarmetrics.GregorianCalendarMetrics;

public class JulianCalendarMetrics
extends GregorianCalendarMetrics {
    public static final String CALENDAR_SCALE_ALIAS = "JULIAN";
    public static final CalendarMetrics.CalendarMetricsFactory FACTORY = new CalendarMetrics.CalendarMetricsFactory(){

        @Override
        public CalendarMetrics getCalendarMetrics(Weekday weekStart) {
            return new JulianCalendarMetrics(JulianCalendarMetrics.CALENDAR_SCALE_ALIAS, weekStart, 4);
        }

        public String toString() {
            return JulianCalendarMetrics.CALENDAR_SCALE_ALIAS;
        }
    };
    public static final String CALENDAR_SCALE_NAME = "JULIUS";
    private GregorianCalendarMetrics mGregorianCalendarMetrics;

    public JulianCalendarMetrics(Weekday weekStart, int minDaysInFirstWeek) {
        super(CALENDAR_SCALE_ALIAS, weekStart, minDaysInFirstWeek);
    }

    JulianCalendarMetrics(String name, Weekday weekStart, int minDaysInFirstWeek) {
        super(name, weekStart, minDaysInFirstWeek);
    }

    @Override
    public int getDayOfWeek(int year, int yearDay) {
        int y = year - 1;
        return (yearDay + 5 + y + (y >> 2)) % 7;
    }

    @Override
    boolean isLeapYear(int year) {
        return (year & 3) == 0;
    }

    @Override
    public int getWeekDayOfFirstYearDay(int year) {
        int y = year - 1;
        return (6 + y + (y >> 2)) % 7;
    }

    @Override
    public long toMillis(TimeZone timeZone, int year, int packedMonth, int dayOfMonth, int hours, int minutes, int seconds, int millis) {
        int daysPerMonth;
        int yh;
        if (packedMonth > 1) {
            yh = year / 100;
            dayOfMonth += yh - (yh >> 2) - 2;
        } else {
            yh = (year - 1) / 100;
            if (packedMonth == 1 && (dayOfMonth += yh - (yh >> 2) - 2) > 28 && year % 100 == 0 && year % 400 != 0) {
                ++dayOfMonth;
            }
        }
        GregorianCalendarMetrics gregorianMetrics = this.mGregorianCalendarMetrics;
        if (gregorianMetrics == null) {
            gregorianMetrics = this.mGregorianCalendarMetrics = new GregorianCalendarMetrics("GREGORIAN", this.weekStart, this.minDaysInFirstWeek);
        }
        if (dayOfMonth > (daysPerMonth = this.getDaysPerPackedMonth(year, packedMonth))) {
            dayOfMonth -= daysPerMonth;
            if (++packedMonth > 11) {
                packedMonth = 0;
                ++year;
            }
        } else if (dayOfMonth < 1) {
            if (--packedMonth < 0) {
                --year;
                packedMonth = 11;
            }
            dayOfMonth += gregorianMetrics.getDaysPerPackedMonth(year, packedMonth);
        }
        return gregorianMetrics.toMillis(timeZone, year, packedMonth, dayOfMonth, hours, minutes, seconds, millis);
    }

    @Override
    long getTimeStamp(int year, int yearDay, int hours, int minutes, int seconds, int millis) {
        long result = (long)(year - 1970) * 365L;
        result = (result + (long)yearDay - 1L + (long)this.numLeapDaysSince1970(year) + 13L) * 24L;
        result = (result + (long)hours) * 60L;
        result = (result + (long)minutes) * 60L;
        result = (result + (long)seconds) * 1000L + (long)millis;
        return result;
    }

    @Override
    int numLeapDaysSince1970(int year) {
        int prevYear = year - 1;
        int leapYears = prevYear >> 2;
        return leapYears - 492;
    }

    @Override
    public long toInstance(long timestamp, TimeZone timeZone) {
        long localTime = timestamp;
        if (timeZone != null) {
            localTime += (long)timeZone.getOffset(timestamp);
        }
        int time = (int)(localTime % 86400000L);
        localTime -= (long)time;
        if (time < 0) {
            time += 86400000;
            localTime -= 86400000L;
        }
        int daysSince1 = (int)(localTime / 86400000L + 718685L + 492L - 13L);
        int c4 = daysSince1 / 1461;
        int c4Remainder = daysSince1 - c4 * 1461;
        int c1 = Math.min(c4Remainder / 365, 3);
        int c1Remainder = c4Remainder - 365 * c1 + 1;
        int year = (c4 << 2) + c1 + 1;
        int monthAndDay = this.getMonthAndDayOfYearDay(year, c1Remainder);
        int minutes = time / 60000;
        return Instance.make(year, JulianCalendarMetrics.packedMonth(monthAndDay), JulianCalendarMetrics.dayOfMonth(monthAndDay), minutes / 60, minutes % 60, time / 1000 % 60);
    }
}

