/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.semver;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dmfs.jems2.Optional;
import org.dmfs.jems2.optional.NullSafe;
import org.dmfs.semver.StructuredVersion;
import org.dmfs.semver.Version;
import org.dmfs.semver.VersionParser;

public final class StrictParser
implements VersionParser {
    private static final Pattern SEMVER_PATTERN = Pattern.compile("^(0|[1-9]\\d*)\\.(0|[1-9]\\d*)\\.(0|[1-9]\\d*)(?:-((?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*)(?:\\.(?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*))*))?(?:\\+([0-9a-zA-Z-]+(?:\\.[0-9a-zA-Z-]+)*))?$");

    @Override
    public Version parse(CharSequence versionString) {
        Matcher matcher = SEMVER_PATTERN.matcher(versionString);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(String.format("%s is not a valid Semantic Version String.", versionString));
        }
        return new StructuredVersion(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3)), (Optional<String>)new NullSafe((Object)matcher.group(4)), (Optional<String>)new NullSafe((Object)matcher.group(5)));
    }
}

