/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.semver.prereleases;

import java.util.regex.Pattern;
import org.dmfs.jems2.Optional;
import org.dmfs.jems2.Single;
import org.dmfs.jems2.single.Frozen;

public final class PreReleaseSuccessor
implements Optional<String> {
    private static final Pattern NUMERIC = Pattern.compile("\\d+");
    private final Optional<String> mDelegate;
    private final String mBase;
    private final Single<Integer> mBaseVersion;
    private final Single<String> mBaseBase;

    public PreReleaseSuccessor(Optional<String> delegate, String base) {
        this(delegate, base, (Single<String>)new Frozen(() -> {
            String[] baseParts = base.split("\\.");
            return baseParts[baseParts.length - 1];
        }));
    }

    private PreReleaseSuccessor(Optional<String> delegate, String base, Single<String> lastBaseSegment) {
        this(delegate, base, (Single<String>)new Frozen(() -> NUMERIC.matcher((CharSequence)lastBaseSegment.value()).matches() ? base.substring(0, base.length() - ((String)lastBaseSegment.value()).length()) : base + "."), (Single<Integer>)new Frozen(() -> NUMERIC.matcher((CharSequence)lastBaseSegment.value()).matches() ? Integer.parseInt((String)lastBaseSegment.value()) : 1));
    }

    private PreReleaseSuccessor(Optional<String> delegate, String base, Single<String> baseBase, Single<Integer> baseVersion) {
        this.mDelegate = delegate;
        this.mBase = base;
        this.mBaseBase = baseBase;
        this.mBaseVersion = baseVersion;
    }

    public boolean isPresent() {
        return true;
    }

    public String value() {
        if (this.mDelegate.isPresent()) {
            String baseBase = (String)this.mBaseBase.value();
            String value = (String)this.mDelegate.value();
            if (value.length() + 1 == baseBase.length() && baseBase.startsWith(value)) {
                return baseBase + this.mBaseVersion.value();
            }
            if (value.startsWith(baseBase)) {
                String nextSegment = value.substring(baseBase.length()).split("\\.")[0];
                if (NUMERIC.matcher(nextSegment).matches()) {
                    return baseBase + Math.max((Integer)this.mBaseVersion.value(), Integer.parseInt(nextSegment) + 1);
                }
                return this.mBase;
            }
            return this.mBase;
        }
        return this.mBase;
    }
}

