/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.srcless.processors.staticfactory;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.util.Comparator;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.dmfs.jems2.Optional;
import org.dmfs.jems2.Predicate;
import org.dmfs.jems2.comparator.By;
import org.dmfs.jems2.iterable.Clustered;
import org.dmfs.jems2.iterable.Expanded;
import org.dmfs.jems2.iterable.Joined;
import org.dmfs.jems2.iterable.Mapped;
import org.dmfs.jems2.iterable.Seq;
import org.dmfs.jems2.iterable.Sorted;
import org.dmfs.jems2.optional.First;
import org.dmfs.jems2.optional.FirstPresent;
import org.dmfs.jems2.optional.Just;
import org.dmfs.jems2.optional.NullSafe;
import org.dmfs.jems2.optional.Sieved;
import org.dmfs.jems2.predicate.Not;
import org.dmfs.jems2.procedure.ForEach;
import org.dmfs.srcless.annotations.staticfactory.StaticFactories;
import org.dmfs.srcless.annotations.staticfactory.StaticFactory;
import org.dmfs.srcless.processors.staticfactory.AnnotatedCtor;
import org.dmfs.srcless.processors.staticfactory.ClassCtor;
import org.dmfs.srcless.processors.staticfactory.CtorDescription;
import org.dmfs.srcless.processors.staticfactory.IsDefaultCtorInLombokClass;
import org.dmfs.srcless.processors.staticfactory.LombokConstructors;
import org.dmfs.srcless.utils.Constructors;

@SupportedAnnotationTypes(value={"org.dmfs.srcless.annotations.staticfactory.StaticFactory", "org.dmfs.srcless.annotations.staticfactory.StaticFactories"})
public final class StaticFactoryProcessor
extends AbstractProcessor {
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        new ForEach((Iterable)new Mapped(ctors -> this.staticFactoryContainer(((AnnotatedCtor)ctors.iterator().next()).targetPackage(), ((AnnotatedCtor)ctors.iterator().next()).targetClass(), (Iterable<? extends AnnotatedCtor>)ctors), (Iterable)new Clustered((Comparator)new By(ctor -> ctor.targetPackage() + "." + ctor.targetClass()), (Iterable)new Sorted((Comparator)new By(ctor -> ctor.targetPackage() + "." + ctor.targetClass()), (Iterable)new Joined(new Iterable[]{new Expanded(clazz -> new LombokConstructors((TypeElement)clazz), roundEnv.getElementsAnnotatedWith(StaticFactories.class)), new org.dmfs.jems2.iterable.Sieved(ctor -> !ctor.description().hasModifier(Modifier.PRIVATE), (Iterable)new Mapped(ctor -> new ClassCtor((TypeElement)ctor.getEnclosingElement(), (ExecutableElement)ctor), (Iterable)new org.dmfs.jems2.iterable.Sieved(c -> c.getKind() == ElementKind.CONSTRUCTOR, roundEnv.getElementsAnnotatedWith(StaticFactory.class)))), new org.dmfs.jems2.iterable.Sieved(ctor -> ctor.description().annotation(StaticFactory.class) == null && ctor.description().hasModifier(Modifier.PUBLIC), (Iterable)new Expanded(clazz -> new Mapped(ctor -> new ClassCtor((TypeElement)clazz, (ExecutableElement)ctor), (Iterable)new org.dmfs.jems2.iterable.Sieved((Predicate)new Not((Predicate)new IsDefaultCtorInLombokClass()), (Iterable)((Object)new Constructors((TypeElement)clazz)))), roundEnv.getElementsAnnotatedWith(StaticFactories.class)))}))))).process(file -> {
            try {
                if (this.processingEnv.getElementUtils().getTypeElement(file.packageName + "." + file.typeSpec.name) == null) {
                    file.writeTo(this.processingEnv.getFiler());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        return true;
    }

    private JavaFile staticFactoryContainer(String packageName, String className, Iterable<? extends AnnotatedCtor> ctor) {
        return JavaFile.builder((String)packageName, (TypeSpec)TypeSpec.classBuilder((String)className).addJavadoc("Automatically generated class with static factory methods.", new Object[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).addComment("no-instances constructor", new Object[0]).build()).addMethods((Iterable)new Mapped(this::staticFactoryMethod, ctor)).build()).build();
    }

    private MethodSpec staticFactoryMethod(AnnotatedCtor ctor) {
        CtorDescription ctorDescription = ctor.description();
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)this.factoryMethodName(ctorDescription)).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addExceptions((Iterable)new Mapped(TypeName::get, ctorDescription.thrownExceptions())).addAnnotations((Iterable)new Mapped(AnnotationSpec::get, (Iterable)new org.dmfs.jems2.iterable.Sieved(an -> new First(ElementType.METHOD::equals, (Iterable)new Expanded(target -> new Seq((Object[])target.value()), (Optional)new NullSafe((Object)an.getAnnotationType().asElement().getAnnotation(Target.class)))).isPresent(), ctorDescription.annotationMirrors()))).addTypeVariables((Iterable)new Mapped(TypeVariableName::get, (Iterable)new Joined(new Iterable[]{ctor.clazz().getTypeParameters(), ctorDescription.typeParameters()}))).returns(TypeName.get((TypeMirror)ctor.clazz().asType())).varargs(ctorDescription.hasVarArgs()).addParameters((Iterable)new Mapped(param -> ParameterSpec.builder((TypeName)TypeName.get((TypeMirror)param.asType()), (String)param.getSimpleName().toString(), (Modifier[])new Modifier[0]).addAnnotations((Iterable)new Mapped(AnnotationSpec::get, param.getAnnotationMirrors())).build(), ctorDescription.parameters())).addStatement("return new $1L$2L($3L)", new Object[]{ctorDescription.fqClass(), ctor.clazz().getTypeParameters().isEmpty() ? "" : "<>", String.join((CharSequence)", ", (Iterable<? extends CharSequence>)new Mapped(VariableElement::getSimpleName, ctorDescription.parameters()))});
        builder.addJavadoc(ctorDescription.javaDoc(this.processingEnv), new Object[0]);
        return builder.build();
    }

    private String factoryMethodName(CtorDescription ctor) {
        return (String)new FirstPresent(new Optional[]{new Sieved((Predicate)new Not(String::isEmpty), (Optional)new org.dmfs.jems2.optional.Mapped(StaticFactory::methodName, (Optional)new NullSafe((Object)ctor.annotation(StaticFactory.class)))), new Just(() -> {
            String constructorName = ctor.name();
            return Character.toLowerCase(constructorName.charAt(0)) + constructorName.substring(1);
        })}).value();
    }
}

