/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.srcless.processors.staticfactory;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import java.io.IOException;
import java.util.Comparator;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.dmfs.jems2.comparator.By;
import org.dmfs.jems2.iterable.Clustered;
import org.dmfs.jems2.iterable.Joined;
import org.dmfs.jems2.iterable.Mapped;
import org.dmfs.jems2.iterable.Sorted;
import org.dmfs.jems2.procedure.ForEach;
import org.dmfs.srcless.processors.staticfactory.ExplicitStaticFactories;
import org.dmfs.srcless.processors.staticfactory.ImplicitStaticFactories;
import org.dmfs.srcless.processors.staticfactory.LombokCtorStaticFactories;
import org.dmfs.srcless.processors.staticfactory.MethodDescription;
import org.dmfs.srcless.processors.staticfactory.StaticFactoryMethod;

@SupportedAnnotationTypes(value={"org.dmfs.srcless.annotations.staticfactory.StaticFactory", "org.dmfs.srcless.annotations.staticfactory.StaticFactories"})
public final class StaticFactoryProcessor
extends AbstractProcessor {
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        new ForEach((Iterable)new Mapped(ctors -> this.staticFactoryContainer(((StaticFactoryMethod)ctors.iterator().next()).targetPackage(), ((StaticFactoryMethod)ctors.iterator().next()).targetClass(), (Iterable<? extends StaticFactoryMethod>)ctors), (Iterable)new Clustered((Comparator)new By(ctor -> ctor.targetPackage() + "." + ctor.targetClass()), (Iterable)new Sorted((Comparator)new By(ctor -> ctor.targetPackage() + "." + ctor.targetClass()), (Iterable)new Joined(new Iterable[]{new LombokCtorStaticFactories(roundEnv), new ExplicitStaticFactories(roundEnv), new ImplicitStaticFactories(roundEnv)}))))).process(file -> {
            try {
                if (this.processingEnv.getElementUtils().getTypeElement(file.packageName + "." + file.typeSpec.name) == null) {
                    file.writeTo(this.processingEnv.getFiler());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        return true;
    }

    private JavaFile staticFactoryContainer(String packageName, String className, Iterable<? extends StaticFactoryMethod> ctor) {
        return JavaFile.builder((String)packageName, (TypeSpec)TypeSpec.classBuilder((String)className).addJavadoc("Automatically generated class with static factory methods.", new Object[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).addComment("no-instances constructor", new Object[0]).build()).addMethods((Iterable)new Mapped(this::staticFactoryMethod, ctor)).build()).build();
    }

    private MethodSpec staticFactoryMethod(StaticFactoryMethod staticMethod) {
        MethodDescription methodDescription = staticMethod.description();
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)methodDescription.name()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addExceptions((Iterable)new Mapped(TypeName::get, methodDescription.thrownExceptions())).addAnnotations(methodDescription.annotationSpecs()).addTypeVariables((Iterable)new Mapped(TypeVariableName::get, (Iterable)new Joined(new Iterable[]{staticMethod.clazz().getTypeParameters(), methodDescription.typeParameters()}))).returns(TypeName.get((TypeMirror)staticMethod.clazz().asType())).varargs(methodDescription.hasVarArgs()).addParameters((Iterable)new Mapped(param -> ParameterSpec.builder((TypeName)TypeName.get((TypeMirror)param.asType()), (String)param.getSimpleName().toString(), (Modifier[])new Modifier[0]).addAnnotations((Iterable)new Mapped(AnnotationSpec::get, param.getAnnotationMirrors())).build(), methodDescription.parameters())).addStatement("return new $1L$2L($3L)", new Object[]{methodDescription.fullyQualifiedTargetClassName(), staticMethod.clazz().getTypeParameters().isEmpty() ? "" : "<>", String.join((CharSequence)", ", (Iterable<? extends CharSequence>)new Mapped(VariableElement::getSimpleName, methodDescription.parameters()))});
        builder.addJavadoc(methodDescription.javaDoc(this.processingEnv), new Object[0]);
        return builder.build();
    }
}

