/*
 * Decompiled with CFR 0.152.
 */
package org.dnwiebe.orienteer;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import org.dnwiebe.orienteer.converters.Converter;
import org.dnwiebe.orienteer.converters.Converters;
import org.dnwiebe.orienteer.helpers.Fragmenter;
import org.dnwiebe.orienteer.helpers.Fragments;
import org.dnwiebe.orienteer.lookups.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Orienteer {
    Converters converters = new Converters();
    Fragmenter fragmenter = new Fragmenter();
    boolean initialCheck = true;
    Logger logger = Logger.getLogger(Orienteer.class.getName());

    public Orienteer addConverter(Converter converter) {
        return this.addConverter(converter, null);
    }

    public <T extends Lookup> Orienteer addConverter(Converter converter, Class<T> lookupType) {
        try {
            Method convertMethod = converter.getClass().getMethod("convert", String.class);
            Class<?> targetType = convertMethod.getReturnType();
            this.converters.add(targetType, lookupType, converter);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return this;
    }

    public Orienteer inhibitInitialCheck() {
        this.initialCheck = false;
        return this;
    }

    public <T> T make(Class<T> singletonInterface, Lookup ... lookups) {
        this.validateInterface(singletonInterface);
        Object singleton = Proxy.newProxyInstance(Orienteer.class.getClassLoader(), new Class[]{singletonInterface}, (InvocationHandler)new ConfigurationHandler(this.fragmenter, lookups, this.converters, this.logger));
        if (this.initialCheck) {
            this.verifyAccess(singletonInterface, singleton);
        }
        return (T)singleton;
    }

    private void validateInterface(Class singletonInterface) {
        Method[] methods;
        this.validateClassObject(singletonInterface);
        for (Method method : methods = singletonInterface.getMethods()) {
            this.validateReturnType(method);
            this.validateParameters(method);
        }
    }

    private void validateClassObject(Class singletonInterface) {
        if (!singletonInterface.isInterface()) {
            throw new IllegalArgumentException("Configuration singletons must be built on interfaces, not classes like " + singletonInterface.getName() + ".");
        }
    }

    private void validateReturnType(Method method) {
        if (!this.converters.getTargetTypes().contains(method.getReturnType())) {
            StringBuilder buf = new StringBuilder();
            for (Class<?> type : this.converters.getTargetTypes()) {
                if (buf.length() > 0) {
                    buf.append(", ");
                }
                buf.append(type.getName());
            }
            throw new IllegalArgumentException("The " + method.getName() + " method of the " + method.getDeclaringClass().getName() + " interface returns type " + method.getReturnType().getName() + ". Methods on configuration interfaces must return one of the following types: " + buf.toString());
        }
    }

    private void validateParameters(Method method) {
        if (method.getParameterTypes().length > 0) {
            throw new IllegalArgumentException("The " + method.getName() + " method of the " + method.getDeclaringClass().getName() + " interface takes a parameter. Methods on configuration interfaces must be parameterless.");
        }
    }

    private <T> void verifyAccess(Class<T> type, T singleton) {
        Method[] methods = type.getMethods();
        ArrayList<String> problems = new ArrayList<String>();
        for (Method method : methods) {
            try {
                method.invoke(singleton, new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                this.logger.severe(this.dumpStackTrace(cause));
                problems.add(method.getName());
            }
        }
        if (!problems.isEmpty()) {
            throw new IllegalStateException("Couldn't retrieve configurations: " + this.join(problems));
        }
    }

    private String dumpStackTrace(Throwable e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        return sw.toString();
    }

    private String join(List<String> list) {
        StringBuilder buf = new StringBuilder();
        for (String string : list) {
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append(string);
        }
        return buf.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConfigurationHandler
    implements InvocationHandler {
        private final Lookup[] lookups;
        private final Converters converters;
        private final Fragmenter fragmenter;
        private final Logger logger;

        ConfigurationHandler(Fragmenter fragmenter, Lookup[] lookups, Converters converters, Logger logger) {
            this.fragmenter = fragmenter;
            this.lookups = new Lookup[lookups.length];
            for (int i = 0; i < lookups.length; ++i) {
                this.lookups[i] = lookups[i];
            }
            this.converters = converters;
            this.logger = logger;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            this.logger.info("Seeking configuration value for '" + method.getName() + "'");
            List<String> fragments = this.getFragments(method);
            for (Lookup lookup : this.lookups) {
                String value;
                String name = lookup.nameFromFragments(fragments);
                Object result = this.processValue(method, lookup, name, value = lookup.valueFromName(name, method.getDeclaringClass()));
                if (result == null) continue;
                return result;
            }
            this.logger.warning("NOT CONFIGURED: " + method.getDeclaringClass().getName() + "." + method.getName() + "()");
            return null;
        }

        private List<String> getFragments(Method method) {
            Fragments annotation = method.getAnnotation(Fragments.class);
            if (annotation != null) {
                return Arrays.asList(annotation.value());
            }
            return this.fragmenter.fragment(method.getName());
        }

        private Object processValue(Method method, Lookup lookup, String name, String value) throws Exception {
            String logPreamble = "  Consulting " + lookup.getName() + " for '" + name + "': ";
            if (value == null) {
                this.logger.info(logPreamble + "not found");
                return null;
            }
            Converter<?> converter = this.converters.find(method.getReturnType(), lookup.getClass());
            Object result = converter.convert(value);
            this.logger.info(logPreamble + "found '" + result + "'");
            this.logger.info("Configured: " + method.getDeclaringClass().getName() + "." + method.getName() + "() <- " + result);
            return result;
        }
    }
}

