/*
 * Decompiled with CFR 0.152.
 */
package org.dnwiebe.orienteer.converters;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.dnwiebe.orienteer.converters.BooleanConverter;
import org.dnwiebe.orienteer.converters.Converter;
import org.dnwiebe.orienteer.converters.DoubleConverter;
import org.dnwiebe.orienteer.converters.IntegerConverter;
import org.dnwiebe.orienteer.converters.LongConverter;
import org.dnwiebe.orienteer.converters.StringConverter;
import org.dnwiebe.orienteer.lookups.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Converters {
    private Map<Pair<Class, Class>, Converter> map = new HashMap<Pair<Class, Class>, Converter>();

    public Converters() {
        this.add(String.class, null, new StringConverter());
        this.add(Integer.class, null, new IntegerConverter());
        this.add(Long.class, null, new LongConverter());
        this.add(Double.class, null, new DoubleConverter());
        this.add(Boolean.class, null, new BooleanConverter());
    }

    public <T, L extends Lookup> void add(Class<T> targetType, Class<L> lookupType, Converter<T> converter) {
        this.map.put(new Pair<Class<T>, Class<L>>(targetType, lookupType), converter);
    }

    public <T, L extends Lookup> Converter<T> find(Class<T> targetType, Class<L> lookupType) {
        this.validateTargetType(targetType);
        Converter candidate = this.map.get(new Pair<Class<T>, Class<L>>(targetType, lookupType));
        if (candidate != null) {
            return candidate;
        }
        return this.map.get(new Pair<Class<T>, Object>(targetType, null));
    }

    public Set<Class<?>> getTargetTypes() {
        HashSet result = new HashSet();
        Set<Pair<Class, Class>> pairs = this.map.keySet();
        for (Pair<Class, Class> pair : pairs) {
            result.add(pair.a());
        }
        return result;
    }

    private void validateTargetType(Class<?> targetType) {
        if (targetType == null) {
            throw new IllegalArgumentException("You must provide a target type to find a Converter");
        }
        if (targetType.isPrimitive()) {
            throw new IllegalArgumentException("Converters do not support primitive types like '" + targetType.getName() + "', only object types");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Pair<A, B> {
        private A _a;
        private B _b;

        public Pair(A a, B b) {
            this._a = a;
            this._b = b;
        }

        public A a() {
            return this._a;
        }

        public B b() {
            return this._b;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (!(o instanceof Pair)) {
                return false;
            }
            Pair that = (Pair)o;
            if (!this.matches(this.a(), that.a())) {
                return false;
            }
            return this.matches(this.b(), that.b());
        }

        private boolean matches(Object a, Object b) {
            if (a == null && b != null) {
                return false;
            }
            if (a != null && b == null) {
                return false;
            }
            if (a == null) {
                return true;
            }
            return a.equals(b);
        }

        public int hashCode() {
            int aCode = this.a() == null ? 0 : this.a().hashCode();
            int bCode = this.b() == null ? 0 : this.b().hashCode();
            return (aCode << 16) + bCode;
        }
    }
}

