/*
 * Decompiled with CFR 0.152.
 */
package org.dnwiebe.orienteer.helpers;

import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Fragmenter {
    public List<String> fragment(String name) {
        FragmentationState state = new FragmentationState();
        for (int i = 0; i < name.length(); ++i) {
            state.acceptCharacter(name.charAt(i));
        }
        state.finish();
        return state.getResult();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FragmentationState {
        private int accumulatedUppers = 1;
        private int accumulatedDigits = 0;
        private StringBuilder wordSoFar = new StringBuilder();
        private List<String> result = new ArrayList<String>();

        private FragmentationState() {
        }

        public void acceptCharacter(char c) {
            if (Character.isUpperCase(c)) {
                this.processUpperCaseCharacter(c);
            } else if (Character.isDigit(c)) {
                this.processDigit(c);
            } else {
                this.processLowerCaseCharacter(c);
            }
        }

        public void finish() {
            this.result.add(this.wordSoFar.toString());
        }

        public List<String> getResult() {
            return this.result;
        }

        private void processDigit(char c) {
            if (this.accumulatedDigits == 0 && this.wordSoFar.length() > 0) {
                this.finishWord();
            }
            this.wordSoFar.append(c);
            ++this.accumulatedDigits;
            this.accumulatedUppers = 0;
        }

        private void processLowerCaseCharacter(char c) {
            this.finishUppercaseRegionIfNecessary();
            this.finishDigitRegionIfNecessary();
            this.wordSoFar.append(c);
            this.accumulatedUppers = 0;
        }

        private void processUpperCaseCharacter(char c) {
            this.finishLowercaseRegionIfNecessary();
            this.finishDigitRegionIfNecessary();
            this.wordSoFar.append(c);
            ++this.accumulatedUppers;
        }

        private void finishWord() {
            this.result.add(this.wordSoFar.toString());
            this.wordSoFar = new StringBuilder();
        }

        private char reduceByOneChar(StringBuilder buf) {
            char lastChar = buf.charAt(buf.length() - 1);
            buf.setLength(buf.length() - 1);
            return lastChar;
        }

        private void finishUppercaseRegionIfNecessary() {
            if (this.accumulatedUppers > 1) {
                char firstOfThisWord = this.reduceByOneChar(this.wordSoFar);
                this.finishWord();
                this.wordSoFar.append(firstOfThisWord);
            }
        }

        private void finishLowercaseRegionIfNecessary() {
            if (this.accumulatedUppers == 0 && this.accumulatedDigits == 0) {
                this.finishWord();
            }
        }

        private void finishDigitRegionIfNecessary() {
            if (this.accumulatedDigits > 0) {
                this.finishWord();
                this.accumulatedDigits = 0;
            }
        }
    }
}

