/*
 * Decompiled with CFR 0.152.
 */
package org.dnwiebe.orienteer.helpers;

import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapLiteral {
    public static <K, V> Map<K, V> convert(Class<K> keyClass, Class<V> valueClass, Object ... keysAndValues) {
        MapLiteral.checkParameterCount(keysAndValues);
        StringBuilder keyErrors = new StringBuilder();
        StringBuilder valueErrors = new StringBuilder();
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        for (int i = 0; i < keysAndValues.length; i += 2) {
            Object v;
            boolean error = false;
            Object k = keysAndValues[i];
            if (!keyClass.isAssignableFrom(k.getClass())) {
                MapLiteral.appendDelimited(keyErrors, k.toString() + " (" + k.getClass().getName() + ")");
                error = true;
            }
            if (!valueClass.isAssignableFrom((v = keysAndValues[i + 1]).getClass())) {
                MapLiteral.appendDelimited(valueErrors, k.toString() + " -> " + v.toString() + " (" + v.getClass().getName() + ")");
                error = true;
            }
            if (error) continue;
            result.put(k, v);
        }
        MapLiteral.checkErrorBuffers(keyClass, keyErrors, valueClass, valueErrors);
        return result;
    }

    private static void appendDelimited(StringBuilder buf, String s) {
        if (buf.length() > 0) {
            buf.append(", ");
        }
        buf.append(s);
    }

    private static void checkParameterCount(Object[] keysAndValues) {
        if ((keysAndValues.length & 1) != 0) {
            throw new IllegalArgumentException("Need value for every key, but found odd number (" + keysAndValues.length + ") of key-and-value parameters");
        }
    }

    private static void checkErrorBuffers(Class<?> keyClass, StringBuilder keyErrors, Class<?> valueClass, StringBuilder valueErrors) {
        StringBuilder buf = new StringBuilder();
        if (keyErrors.length() > 0) {
            buf.append("Cannot convert keys to type ").append(keyClass.getName()).append(": ").append(keyErrors.toString());
        }
        if (valueErrors.length() > 0) {
            if (buf.length() > 0) {
                buf.append("\n");
            }
            buf.append("Cannot convert values to type ").append(valueClass.getName()).append(": ").append(valueErrors.toString());
        }
        if (buf.length() > 0) {
            throw new IllegalArgumentException(buf.toString());
        }
    }
}

