/*
 * Decompiled with CFR 0.152.
 */
package org.dnwiebe.orienteer.lookups;

import com.fasterxml.jackson.jr.ob.JSON;
import java.io.InputStream;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dnwiebe.orienteer.lookups.JsonNestingLookup;
import org.dnwiebe.orienteer.lookups.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JsonLookup
extends Lookup {
    protected final Map<String, Object> tree;

    protected JsonLookup(final Reader rdr, String configRoot) {
        Supplier<Map<String, Object>> supplier = new Supplier<Map<String, Object>>(){

            @Override
            public Map<String, Object> supply() throws Exception {
                return JSON.std.mapFrom((Object)rdr);
            }
        };
        this.tree = this.makeTree(supplier, configRoot);
    }

    protected JsonLookup(final InputStream istr, String configRoot) {
        Supplier<Map<String, Object>> supplier = new Supplier<Map<String, Object>>(){

            @Override
            public Map<String, Object> supply() throws Exception {
                return JSON.std.mapFrom((Object)istr);
            }
        };
        this.tree = this.makeTree(supplier, configRoot);
    }

    protected JsonLookup(String resourceName, String configRoot) {
        this(JsonNestingLookup.class.getClassLoader().getResourceAsStream(resourceName), configRoot);
    }

    protected JsonLookup(String name, final Reader rdr, String configRoot) {
        super(name);
        Supplier<Map<String, Object>> supplier = new Supplier<Map<String, Object>>(){

            @Override
            public Map<String, Object> supply() throws Exception {
                return JSON.std.mapFrom((Object)rdr);
            }
        };
        this.tree = this.makeTree(supplier, configRoot);
    }

    protected JsonLookup(String name, final InputStream istr, String configRoot) {
        super(name);
        Supplier<Map<String, Object>> supplier = new Supplier<Map<String, Object>>(){

            @Override
            public Map<String, Object> supply() throws Exception {
                return JSON.std.mapFrom((Object)istr);
            }
        };
        this.tree = this.makeTree(supplier, configRoot);
    }

    protected JsonLookup(String name, String resourceName, String configRoot) {
        this(name, JsonNestingLookup.class.getClassLoader().getResourceAsStream(resourceName), configRoot);
    }

    private Map<String, Object> makeTree(Supplier<Map<String, Object>> supplier, String configRoot) {
        Map result;
        try {
            result = supplier.supply();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        if (configRoot != null && (result = (Map)this.valueFromName(new Pair("." + configRoot), result)) == null) {
            throw new IllegalArgumentException("Could not find config root '" + configRoot + "' in JSON structure");
        }
        return result;
    }

    protected Object valueFromName(Pair name, Map<String, Object> map) {
        Object object = map.get(name.head);
        return this.recurse(name, object);
    }

    protected Object valueFromName(Pair name, List<Object> list) {
        try {
            int index = Integer.parseInt(name.head);
            if (index >= list.size()) {
                return null;
            }
            Object object = list.get(index);
            return this.recurse(name, object);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private Object recurse(Pair name, Object object) {
        if (object == null) {
            return null;
        }
        if (name.tail.length() == 0) {
            return object;
        }
        if (object instanceof Map) {
            return this.valueFromName(new Pair(name.tail), (Map)object);
        }
        if (object instanceof List) {
            return this.valueFromName(new Pair(name.tail), (List)object);
        }
        throw new UnsupportedOperationException("Should I return null here?");
    }

    protected static class Pair {
        public final String head;
        public final String tail;
        private static final Pattern[] PATTERNS = new Pattern[]{Pattern.compile("^\\[([A-Za-z0-9_]*)](\\..*)$"), Pattern.compile("^\\[([A-Za-z0-9_]*)](\\[.*)$"), Pattern.compile("^\\[([A-Za-z0-9_]*)]()$"), Pattern.compile("^\\.([A-Za-z0-9_]*)(\\..*)$"), Pattern.compile("^\\.([A-Za-z0-9_]*)(\\[.*)$"), Pattern.compile("^\\.([A-Za-z0-9_]*)()$")};

        public Pair(String name) {
            Matcher matcher = null;
            boolean matched = false;
            for (Pattern pattern : PATTERNS) {
                matcher = pattern.matcher(name);
                if (!matcher.matches()) continue;
                matched = true;
                break;
            }
            if (!matched) {
                this.head = "";
                this.tail = "";
            } else {
                this.head = matcher.group(1);
                this.tail = matcher.group(2);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface Supplier<T> {
        public T supply() throws Exception;
    }
}

