/*
 * Decompiled with CFR 0.152.
 */
package org.dnwiebe.orienteer.lookups;

import java.io.InputStream;
import java.io.Reader;
import java.util.List;
import org.dnwiebe.orienteer.lookups.JsonLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonNestingLookup
extends JsonLookup {
    public JsonNestingLookup(Reader rdr, String configRoot) {
        super(rdr, configRoot);
    }

    public JsonNestingLookup(InputStream istr, String configRoot) {
        super(istr, configRoot);
    }

    public JsonNestingLookup(String resourceName, String configRoot) {
        super(resourceName, configRoot);
    }

    public JsonNestingLookup(String name, Reader rdr, String configRoot) {
        super(name, rdr, configRoot);
    }

    public JsonNestingLookup(String name, InputStream istr, String configRoot) {
        super(name, istr, configRoot);
    }

    public JsonNestingLookup(String name, String resourceName, String configRoot) {
        super(name, resourceName, configRoot);
    }

    @Override
    public String nameFromFragments(List<String> fragments) {
        StringBuilder buf = new StringBuilder();
        for (String fragment : fragments) {
            if (this.isNumber(fragment)) {
                buf.append("[").append(fragment).append("]");
                continue;
            }
            if (buf.length() > 0) {
                buf.append(".");
            }
            buf.append(fragment.toLowerCase());
        }
        return buf.toString();
    }

    @Override
    public String valueFromName(String name, Class singletonType) {
        Object value = this.valueFromName(new JsonLookup.Pair("." + name), this.tree);
        return value == null ? null : value.toString();
    }

    private boolean isNumber(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isDigit(s.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

