/*
 * Decompiled with CFR 0.152.
 */
package org.dnwiebe.orienteer.lookups;

import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import org.dnwiebe.orienteer.lookups.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesLookup
extends Lookup {
    private final Properties properties;

    public PropertiesLookup(String resourceName) {
        this(PropertiesLookup.class.getClassLoader().getResourceAsStream(resourceName));
    }

    public PropertiesLookup(InputStream istr) {
        this.properties = new Properties();
        try {
            this.properties.load(istr);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public PropertiesLookup(Properties properties) {
        this.properties = properties;
    }

    public PropertiesLookup(String name, String resourceName) {
        this(name, PropertiesLookup.class.getClassLoader().getResourceAsStream(resourceName));
    }

    public PropertiesLookup(String name, InputStream istr) {
        super(name);
        this.properties = new Properties();
        try {
            this.properties.load(istr);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public PropertiesLookup(String name, Properties properties) {
        super(name);
        this.properties = properties;
    }

    @Override
    public String nameFromFragments(List<String> fragments) {
        StringBuilder buf = new StringBuilder();
        for (String fragment : fragments) {
            if (buf.length() > 0) {
                buf.append(".");
            }
            buf.append(fragment.toLowerCase());
        }
        return buf.toString();
    }

    @Override
    public String valueFromName(String name, Class singletonType) {
        return this.properties.getProperty(name);
    }
}

