/*
 * Decompiled with CFR 0.152.
 */
package org.docbook.extensions.xslt20;

import com.nwalsh.annotations.SaxonExtensionFunction;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.om.AtomicArray;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.ArrayIterator;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;

@SaxonExtensionFunction
public class ImageProperties
extends ExtensionFunctionDefinition {
    private static final StructuredQName qName = new StructuredQName("", "http://docbook.org/extensions/xslt20", "image-properties");
    private static final Pattern dimPatn = Pattern.compile("^(\\d+(\\.\\d*)?)(.*)$");

    public StructuredQName getFunctionQName() {
        return qName;
    }

    public int getMinimumNumberOfArguments() {
        return 1;
    }

    public int getMaximumNumberOfArguments() {
        return 1;
    }

    public SequenceType[] getArgumentTypes() {
        return new SequenceType[]{SequenceType.SINGLE_STRING};
    }

    public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
        return SequenceType.makeSequenceType((ItemType)BuiltInAtomicType.INTEGER, (int)57344);
    }

    public ExtensionFunctionCall makeCallExpression() {
        return new PropertiesCall();
    }

    private class PropertiesCall
    extends ExtensionFunctionCall
    implements ImageObserver {
        boolean imageLoaded = false;
        boolean imageFailed = false;
        Image image = null;
        int width = -1;
        int depth = -1;

        private PropertiesCall() {
        }

        public Sequence call(XPathContext xPathContext, Sequence[] sequences) throws XPathException {
            String imageFn = ((StringValue)sequences[0].head()).getStringValue();
            this.imageLoaded = false;
            this.imageFailed = false;
            this.image = null;
            this.width = -1;
            this.depth = -1;
            System.setProperty("java.awt.headless", "true");
            try {
                URL url = new URL(imageFn);
                this.image = Toolkit.getDefaultToolkit().getImage(url);
            }
            catch (MalformedURLException mue) {
                this.image = Toolkit.getDefaultToolkit().getImage(imageFn);
            }
            this.width = this.image.getWidth(this);
            this.depth = this.image.getHeight(this);
            while (!(this.imageFailed || this.width != -1 && this.depth != -1)) {
                try {
                    Thread.currentThread();
                    Thread.sleep(50L);
                }
                catch (Exception mue) {
                    // empty catch block
                }
                this.width = this.image.getWidth(this);
                this.depth = this.image.getHeight(this);
            }
            this.image.flush();
            if ((this.width == -1 || this.depth == -1) && this.imageFailed) {
                BufferedReader ir = null;
                String line = null;
                int lineLimit = 100;
                try {
                    ir = new BufferedReader(new FileReader(new File(imageFn)));
                    line = ir.readLine();
                    if (line != null && line.startsWith("%PDF-")) {
                        while (lineLimit > 0 && line != null) {
                            --lineLimit;
                            if (line.startsWith("/CropBox [")) {
                                if ((line = line.substring(10)).indexOf("]") >= 0) {
                                    line = line.substring(0, line.indexOf("]"));
                                }
                                this.parseBox(line);
                                lineLimit = 0;
                            }
                            line = ir.readLine();
                        }
                    } else if (line != null && line.startsWith("%!") && line.indexOf(" EPSF-") > 0) {
                        while (lineLimit > 0 && line != null) {
                            --lineLimit;
                            if (line.startsWith("%%BoundingBox: ")) {
                                line = line.substring(15);
                                this.parseBox(line);
                                lineLimit = 0;
                            }
                            line = ir.readLine();
                        }
                    } else if (line != null && (line.startsWith("<?xml") || line.startsWith("<!DOCTYPE") || line.startsWith("<svg"))) {
                        while (lineLimit > 0 && line != null) {
                            int dqpos;
                            int sqpos;
                            String ex;
                            int pos;
                            --lineLimit;
                            if (line.contains("width=") && this.width == -1) {
                                pos = line.indexOf("width=");
                                ex = line.substring(pos + 7);
                                sqpos = ex.indexOf("'");
                                pos = sqpos < (dqpos = ex.indexOf("\"")) && sqpos >= 0 ? sqpos : dqpos;
                                this.width = this.convertUnits(ex.substring(0, pos));
                            }
                            if (line.contains("height=") && this.depth == -1) {
                                pos = line.indexOf("height=");
                                ex = line.substring(pos + 8);
                                sqpos = ex.indexOf("'");
                                pos = sqpos < (dqpos = ex.indexOf("\"")) && sqpos >= 0 ? sqpos : dqpos;
                                this.depth = this.convertUnits(ex.substring(0, pos));
                            }
                            if (this.width >= 0 && this.depth >= 0) {
                                lineLimit = 0;
                            }
                            line = ir.readLine();
                        }
                    } else {
                        System.err.println("Failed to interpret image: " + imageFn);
                    }
                }
                catch (Exception e) {
                    System.err.println("Failed to load image: " + imageFn);
                    this.width = -1;
                    this.depth = -1;
                }
                if (ir != null) {
                    try {
                        ir.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (this.width >= 0) {
                Int64Value[] props = new Int64Value[]{new Int64Value((long)this.width), new Int64Value((long)this.depth)};
                ArrayIterator iter = new ArrayIterator((Item[])props);
                return new AtomicArray((SequenceIterator)iter);
            }
            return EmptySequence.getInstance();
        }

        private void parseBox(String line) {
            int[] corners = new int[4];
            int count = 0;
            StringTokenizer st = new StringTokenizer(line);
            while (count < 4 && st.hasMoreTokens()) {
                try {
                    corners[count++] = Integer.parseInt(st.nextToken());
                }
                catch (Exception exception) {}
            }
            this.width = corners[2] - corners[0];
            this.depth = corners[3] - corners[1];
        }

        @Override
        public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
            if ((infoflags & 0x40) == 64 || (infoflags & 0x80) == 128) {
                this.imageFailed = true;
                return false;
            }
            return (infoflags & 0x20) != 32;
        }

        public int convertUnits(String dim) {
            Matcher matcher = dimPatn.matcher(dim);
            if (matcher.matches()) {
                String magnitude = matcher.group(1);
                String units = matcher.group(3);
                Double d = Double.parseDouble(magnitude);
                d = d * this.unitsScale(units);
                return d.intValue();
            }
            if (dim.matches("^\\d+(\\.\\d*)?$")) {
                Double d = Double.parseDouble(dim);
                return d.intValue();
            }
            throw new UnsupportedOperationException("Cannot parse " + dim + " as a dimension");
        }

        public double unitsScale(String units) {
            if ("pt".equals(units)) {
                return 1.3333333333333333;
            }
            if ("in".equals(units)) {
                return 96.0;
            }
            if ("cm".equals(units)) {
                return 37.79527559055118;
            }
            if ("mm".equals(units)) {
                return 3.7795275590551185;
            }
            if ("px".equals(units)) {
                return 1.0;
            }
            return 1.0;
        }
    }
}

