/*
 * Decompiled with CFR 0.152.
 */
package docet.maven;

import docet.engine.model.FaqEntry;
import docet.maven.DocetIssue;
import docet.maven.DocetPluginUtils;
import docet.maven.Severity;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Date;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;

@Mojo(name="builddoc")
public class DocetMojo
extends AbstractMojo {
    private static final String DEFAULT_INDEX_BASEDIR = "index";
    @Parameter(property="basedir", defaultValue="${project.basedir}")
    private String basedir;
    @Parameter(property="outputdir", defaultValue="${project.build.directory}/docet")
    private String outputdir;
    @Parameter(property="classesdir", defaultValue="${project.build.directory}/classes")
    private String classesdir;
    @Parameter(property="sourcedir", defaultValue="src/main/docs")
    private String sourcedir;
    @Parameter(property="noindex", defaultValue="false")
    private boolean noindex;
    @Parameter(property="zip", defaultValue="true")
    private boolean zip;
    @Parameter(property="bundlezip", defaultValue="false")
    private boolean bundlezip;
    @Parameter(property="compactindex", defaultValue="true")
    private boolean compactindex;
    @Parameter(property="zipfilename", defaultValue="documentation.zip")
    private String zipfilename;
    @Parameter(property="skipvalidation", defaultValue="false")
    private boolean skipvalidation;
    @Parameter(property="attach", defaultValue="true")
    private boolean attach;
    @Component
    private MavenProjectHelper projectHelper;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        DocetPluginUtils.Holder<Integer> errors = new DocetPluginUtils.Holder<Integer>(0);
        DocetPluginUtils.Holder<Integer> warnings = new DocetPluginUtils.Holder<Integer>(0);
        Path outDirPath = Paths.get(this.outputdir, new String[0]);
        Path indexDirPath = outDirPath.resolve(DEFAULT_INDEX_BASEDIR);
        this.getLog().info((CharSequence)("Base directory (basedir): " + this.basedir));
        this.getLog().info((CharSequence)("Source directory (sourcedir): " + this.sourcedir));
        this.getLog().info((CharSequence)("Output directory (outputdir): " + this.outputdir));
        this.getLog().info((CharSequence)("Classes directory (classesDir): " + this.classesdir));
        Path baseDirPath = Paths.get(this.basedir, new String[0]);
        Path classesDirPath = Paths.get(this.classesdir, new String[0]);
        Path srcDir = baseDirPath.resolve(this.sourcedir);
        if (!Files.isReadable(srcDir)) {
            throw new MojoFailureException("Document directory '" + srcDir.toAbsolutePath() + "' does not exist or is not readable, please check the path");
        }
        try {
            if (!Files.isDirectory(outDirPath, new LinkOption[0])) {
                Files.createDirectories(outDirPath, new FileAttribute[0]);
            }
        }
        catch (IOException e2) {
            throw new MojoFailureException("Error while generating output directory", (Throwable)e2);
        }
        Date start = new Date();
        EnumMap<DocetPluginUtils.Language, List<FaqEntry>> faqs = new EnumMap<DocetPluginUtils.Language, List<FaqEntry>>(DocetPluginUtils.Language.class);
        if (this.skipvalidation) {
            this.getLog().info((CharSequence)"--- Validating DOCet source files: SKIPPED");
        } else {
            this.getLog().info((CharSequence)"--- Validating DOCet source files...");
            Map<DocetPluginUtils.Language, List<DocetIssue>> results = DocetPluginUtils.validateDocs(srcDir, faqs, this.getLog());
            results.entrySet().stream().forEach(e -> ((List)e.getValue()).forEach(issue -> {
                if (issue.getSeverity() == Severity.ERROR) {
                    this.getLog().error((CharSequence)("[" + e.getKey() + "] -> " + issue.getMsg()));
                    errors.setValue((Integer)errors.getValue() + 1);
                } else if (issue.getSeverity() == Severity.WARN) {
                    this.getLog().warn((CharSequence)("[" + e.getKey() + "] -> " + issue.getMsg()));
                    warnings.setValue((Integer)warnings.getValue() + 1);
                }
            }));
            this.getLog().info((CharSequence)"--- Validating DOCet PDFs structure...");
            results = DocetPluginUtils.validatePdfs(srcDir, this.getLog());
            results.entrySet().stream().forEach(e -> ((List)e.getValue()).forEach(issue -> {
                if (issue.getSeverity() == Severity.ERROR) {
                    this.getLog().error((CharSequence)("[" + e.getKey() + "] -> " + issue.getMsg()));
                    errors.setValue((Integer)errors.getValue() + 1);
                } else if (issue.getSeverity() == Severity.WARN) {
                    this.getLog().warn((CharSequence)("[" + e.getKey() + "] -> " + issue.getMsg()));
                    warnings.setValue((Integer)warnings.getValue() + 1);
                }
            }));
        }
        if (this.getLog().isDebugEnabled()) {
            faqs.entrySet().stream().forEach(e -> {
                this.getLog().debug((CharSequence)("[FAQ TO BE EXPORTED] [" + e.getKey() + "] " + ((List)e.getValue()).stream().map(faq -> faq.getFaqPath().toFile().getName()).reduce((f1, f2) -> f1 + ", " + f2).orElse("")));
                this.getLog().debug((CharSequence)("[FAQ COUNT] [" + e.getKey() + "] " + ((List)e.getValue()).size()));
            });
        }
        if (errors.getValue() > 0) {
            if (!this.noindex) {
                this.getLog().error((CharSequence)"--- Indexing DOCet source files: SKIPPED due to VALIDATION ERRORS");
            }
            if (this.zip) {
                this.getLog().error((CharSequence)"--- Zipping DOCet disabled: SKIPPED due to VALIDATION ERRORS");
            }
        } else {
            if (this.noindex) {
                this.getLog().info((CharSequence)"--- Indexing DOCet disabled: SKIPPING");
            } else {
                this.getLog().info((CharSequence)("Index directory: " + indexDirPath.toAbsolutePath()));
                this.getLog().info((CharSequence)"--- Indexing DOCet source files...");
                try {
                    if (!Files.isDirectory(indexDirPath, new LinkOption[0])) {
                        Files.createDirectories(indexDirPath, new FileAttribute[0]);
                    }
                }
                catch (IOException e3) {
                    throw new MojoFailureException("Error while generating index directory", (Throwable)e3);
                }
                DocetPluginUtils.indexDocs(indexDirPath, srcDir, faqs, this.getLog(), this.compactindex);
            }
            if (!this.zip) {
                this.getLog().info((CharSequence)"--- Zipping DOCet disabled: SKIPPING");
            } else {
                this.getLog().info((CharSequence)("bundleZip: " + this.bundlezip));
                Path zipFile = this.bundlezip ? classesDirPath.resolve(this.zipfilename) : outDirPath.resolve(this.zipfilename);
                try {
                    if (!Files.isDirectory(zipFile.getParent(), new LinkOption[0])) {
                        Files.createDirectories(zipFile.getParent(), new FileAttribute[0]);
                    }
                }
                catch (IOException e4) {
                    throw new MojoFailureException("Error while generating zip output directory", (Throwable)e4);
                }
                this.getLog().info((CharSequence)("--- Zipping DOCet docet docs and index...to " + zipFile.toAbsolutePath()));
                int zippedNo = DocetPluginUtils.zippingDocs(srcDir, outDirPath, indexDirPath, !this.noindex, zipFile, faqs, this.getLog());
                this.getLog().info((CharSequence)(zippedNo + " files added to archive '" + zipFile.toAbsolutePath() + "'"));
                if (this.attach) {
                    this.getLog().info((CharSequence)("--- Installing DOCet zip artifact '" + zipFile.toAbsolutePath() + "'"));
                    this.getLog().info((CharSequence)("project: " + this.project));
                    this.projectHelper.attachArtifact(this.project, "zip", "docs", zipFile.toFile());
                } else {
                    this.getLog().info((CharSequence)("--- Installing DOCet zip artifact '" + zipFile.toAbsolutePath() + "': DISABLED"));
                }
            }
        }
        Date end = new Date();
        String warnMessage = "";
        if (warnings.getValue() > 0) {
            warnMessage = "Warnings: " + warnings.getValue();
        }
        String errorMessage = "";
        if (errors.getValue() > 0) {
            errorMessage = "Errors: " + errors.getValue();
        }
        this.getLog().info((CharSequence)("Total execution time: " + (end.getTime() - start.getTime()) + "ms \n\t" + warnMessage + "\n\t" + errorMessage));
        if (errors.getValue() > 0) {
            throw new MojoFailureException("Building ended up with" + errors.getValue() + " errors!");
        }
    }
}

