/*
 * Decompiled with CFR 0.152.
 */
package docet.maven;

import docet.engine.model.FaqEntry;
import docet.maven.DocetIssue;
import docet.maven.DocetPluginUtils;
import docet.maven.Severity;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Date;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="generatepdf")
public class DocetPdfGenerationMojo
extends AbstractMojo {
    @Parameter(property="basedir", defaultValue="${project.basedir}")
    private String basedir;
    @Parameter(property="outputdir", defaultValue="target")
    private String outputDir;
    @Parameter(property="sourcedir", defaultValue="src/docs")
    private String sourceDir;
    @Parameter(property="skipvalidation", defaultValue="false")
    private boolean skipValidation;
    @Parameter(property="lang", defaultValue="it")
    private String lang;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Map<DocetPluginUtils.Language, List<DocetIssue>> results;
        DocetPluginUtils.Holder<Integer> errors = new DocetPluginUtils.Holder<Integer>(0);
        DocetPluginUtils.Holder<Integer> warnings = new DocetPluginUtils.Holder<Integer>(0);
        this.getLog().info((CharSequence)("Base directory (basedir): " + this.basedir));
        this.getLog().info((CharSequence)("Source directory: " + this.sourceDir));
        this.getLog().info((CharSequence)("Output directory: " + this.outputDir + "/pdf"));
        this.getLog().info((CharSequence)("Language: " + this.lang));
        Path baseDirPath = Paths.get(this.basedir, new String[0]);
        Path srcDir = baseDirPath.resolve(this.sourceDir);
        if (!Files.isReadable(srcDir)) {
            throw new MojoFailureException("Document directory '" + srcDir.toAbsolutePath() + "' does not exist or is not readable, please check the path");
        }
        Path outDirPath = Paths.get(this.outputDir, new String[0]).resolve("pdf").resolve(this.lang);
        try {
            if (!Files.exists(outDirPath, new LinkOption[0])) {
                Files.createDirectories(outDirPath, new FileAttribute[0]);
            }
        }
        catch (IOException e2) {
            throw new MojoFailureException("Error while generating output directory", (Throwable)e2);
        }
        Path outTmpPath = Paths.get(this.outputDir, new String[0]).resolve("tmp");
        try {
            if (!Files.exists(outTmpPath, new LinkOption[0])) {
                Files.createDirectories(outTmpPath, new FileAttribute[0]);
            }
        }
        catch (IOException e3) {
            throw new MojoFailureException("Error while generating output temporary directory", (Throwable)e3);
        }
        Date start = new Date();
        EnumMap<DocetPluginUtils.Language, List<FaqEntry>> faqs = new EnumMap<DocetPluginUtils.Language, List<FaqEntry>>(DocetPluginUtils.Language.class);
        if (this.skipValidation) {
            this.getLog().info((CharSequence)"--- Preemptive DOCet source files validation: DISABLED");
        } else {
            this.getLog().info((CharSequence)"--- Preemptive DOCet source files validation...");
            results = DocetPluginUtils.validateDocs(srcDir, faqs, this.getLog());
            results.entrySet().stream().forEach(e -> ((List)e.getValue()).forEach(issue -> {
                if (issue.getSeverity() == Severity.ERROR) {
                    this.getLog().error((CharSequence)("[" + e.getKey() + "] -> " + issue.getMsg()));
                    errors.setValue((Integer)errors.getValue() + 1);
                } else if (issue.getSeverity() == Severity.WARN) {
                    this.getLog().warn((CharSequence)("[" + e.getKey() + "] -> " + issue.getMsg()));
                    warnings.setValue((Integer)warnings.getValue() + 1);
                }
            }));
        }
        if (errors.getValue() == 0) {
            this.getLog().info((CharSequence)"--- Generating PDFs....");
            results = DocetPluginUtils.generatePdfsForLanguage(srcDir, outDirPath, outTmpPath, this.lang, this.getLog());
            results.entrySet().stream().forEach(e -> ((List)e.getValue()).forEach(issue -> {
                if (issue.getSeverity() == Severity.ERROR) {
                    this.getLog().error((CharSequence)("[" + e.getKey() + "] -> " + issue.getMsg()));
                    errors.setValue((Integer)errors.getValue() + 1);
                } else if (issue.getSeverity() == Severity.WARN) {
                    this.getLog().warn((CharSequence)("[" + e.getKey() + "] -> " + issue.getMsg()));
                    warnings.setValue((Integer)warnings.getValue() + 1);
                }
            }));
        }
        Date end = new Date();
        String warnMessage = "";
        if (warnings.getValue() > 0) {
            warnMessage = "Warnings: " + warnings.getValue();
        }
        String errorMessage = "";
        if (errors.getValue() > 0) {
            errorMessage = "Errors: " + errors.getValue();
        }
        this.getLog().info((CharSequence)("Total execution time: " + (end.getTime() - start.getTime()) + "ms \n\t" + warnMessage + "\n\t" + errorMessage));
        if (errors.getValue() > 0) {
            throw new MojoFailureException("Validation ended up with" + errors.getValue() + " errors!");
        }
    }
}

