/*
 * Decompiled with CFR 0.152.
 */
package docet.maven;

import docet.engine.model.FaqEntry;
import docet.engine.model.TOC;
import docet.maven.DocetIssue;
import docet.maven.Severity;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.fr.FrenchAnalyzer;
import org.apache.lucene.analysis.it.ItalianAnalyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.IntField;
import org.apache.lucene.document.LongField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.sax.BodyContentHandler;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.parser.Parser;
import org.jsoup.select.Elements;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public final class DocetPluginUtils {
    private static AutoDetectParser tikaParser;
    public static final String FAQ_DEFAULT_PAGE_PREFIX = "faq_";
    public static final int SHORT_SEARCH_TEXT_DEFAULT_LENGTH = 300;
    public static final int SHORT_SEARCH_ANSWER_TEXT_DEFAULT_LENGTH = 90;
    public static final String FAQ_TOC_ID = "docet-faq-menu";
    public static final String FAQ_HOME_ANCHOR_ID = "docet-faq-main-link";
    private static final String CONFIG_NAMES_FOLDER_PAGES = "pages";
    private static final String CONFIG_NAMES_FOLDER_PDFS = "pdf";
    private static final String CONFIG_NAMES_FOLDER_IMAGES = "imgs";
    private static final String CONFIG_NAMES_FILE_TOC = "toc.html";
    private static final String DOCET_META_ATTR_REFERENCE_HIDDEN_PAGE = "docet-hidden-page";
    private static final String DOCET_HTML_ATTR_REFERENCE_LANGUAGE_NAME = "reference-language";
    private static final Charset ENCODING_UTF8;
    private static final int INDEX_DOCTYPE_PAGE = 1;
    private static final int INDEX_DOCTYPE_FAQ = 2;
    private static final String DEFAULT_TIKA_CONFIG = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><external-parsers></external-parsers>\n";

    public static AutoDetectParser getTikaParser() {
        if (tikaParser == null) {
            tikaParser = new AutoDetectParser();
        }
        return tikaParser;
    }

    private DocetPluginUtils() {
    }

    public static Map<Language, List<DocetIssue>> validateDocs(Path srcDir, Map<Language, List<FaqEntry>> faqs, Log log) throws MojoFailureException {
        EnumMap<Language, List<DocetIssue>> result = new EnumMap<Language, List<DocetIssue>>(Language.class);
        for (Language lang : Language.values()) {
            Path langPath = srcDir.resolve(lang.toString());
            if (Files.exists(langPath = langPath.resolve(CONFIG_NAMES_FOLDER_PAGES), new LinkOption[0]) && Files.isDirectory(langPath, new LinkOption[0])) {
                ArrayList<FaqEntry> entriesForLang = new ArrayList<FaqEntry>();
                faqs.put(lang, entriesForLang);
                int indexed = DocetPluginUtils.validateDocsForLanguage(langPath, lang, entriesForLang, (severity, msg) -> {
                    ArrayList<DocetIssue> messages = new ArrayList<DocetIssue>();
                    messages.add(new DocetIssue((Severity)((Object)severity), (String)msg));
                    result.merge(lang, messages, (l1, l2) -> {
                        l1.addAll(l2);
                        return l1;
                    });
                }, log);
                if (indexed != 0) continue;
                ArrayList<DocetIssue> messages = new ArrayList<DocetIssue>();
                messages.add(new DocetIssue(Severity.WARN, "No docs found for language"));
                result.put(lang, messages);
                continue;
            }
            ArrayList<DocetIssue> messages = new ArrayList<DocetIssue>();
            messages.add(new DocetIssue(Severity.WARN, "No folder found for language"));
            result.put(lang, messages);
        }
        return result;
    }

    public static Map<Language, List<DocetIssue>> validatePdfs(Path srcDir, Log log) throws MojoFailureException {
        EnumMap<Language, List<DocetIssue>> result = new EnumMap<Language, List<DocetIssue>>(Language.class);
        for (Language lang : Language.values()) {
            Path langPath = srcDir.resolve(lang.toString());
            if (Files.exists(langPath = langPath.resolve(CONFIG_NAMES_FOLDER_PDFS), new LinkOption[0]) && Files.isDirectory(langPath, new LinkOption[0])) {
                int indexed = DocetPluginUtils.validatePdfsForLanguage(langPath, lang, (severity, msg) -> {
                    ArrayList<DocetIssue> messages = new ArrayList<DocetIssue>();
                    messages.add(new DocetIssue((Severity)((Object)severity), (String)msg));
                    result.merge(lang, messages, (l1, l2) -> {
                        l1.addAll(l2);
                        return l1;
                    });
                }, log);
                if (indexed != 0) continue;
                ArrayList<DocetIssue> messages = new ArrayList<DocetIssue>();
                messages.add(new DocetIssue(Severity.WARN, "No pdfs found for language"));
                result.put(lang, messages);
                continue;
            }
            ArrayList<DocetIssue> messages = new ArrayList<DocetIssue>();
            messages.add(new DocetIssue(Severity.WARN, "No pdfs found for language"));
            result.put(lang, messages);
        }
        return result;
    }

    private static Set<String> retrieveImageNames(Path imgsFolder, BiConsumer<Severity, String> call, final Log log) throws IOException {
        final HashSet<String> res = new HashSet<String>();
        if (!Files.isDirectory(imgsFolder, new LinkOption[0])) {
            call.accept(Severity.WARN, "[IMGS] Directory " + imgsFolder.toAbsolutePath() + " not found");
            return res;
        }
        Files.walkFileTree(imgsFolder, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path file, BasicFileAttributes attrs) throws IOException {
                if (file.toFile().getName().startsWith(".")) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (file.getFileName().toString().startsWith(".")) {
                    return FileVisitResult.CONTINUE;
                }
                String fileName = file.toFile().getName();
                if (log.isDebugEnabled()) {
                    log.debug((CharSequence)("[retrieveImageNames] add image file " + fileName + " to set of found images"));
                }
                res.add(fileName);
                return FileVisitResult.CONTINUE;
            }
        });
        return res;
    }

    public static int validatePdfsForLanguage(Path path, Language lang, final BiConsumer<Severity, String> call, Log log) throws MojoFailureException {
        final Holder<Integer> scannedDocs = new Holder<Integer>(0);
        try {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path file, BasicFileAttributes attrs) throws IOException {
                    if (file.toFile().getName().startsWith(".")) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (file.getFileName().toString().startsWith(".")) {
                        return FileVisitResult.CONTINUE;
                    }
                    try {
                        DocetPluginUtils.validatePdf(file, call);
                        scannedDocs.setValue((Integer)scannedDocs.value + 1);
                    }
                    catch (Exception ex) {
                        call.accept(Severity.ERROR, "File " + file + " cannot be read. " + ex);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
            return (Integer)((Holder)scannedDocs).value;
        }
        catch (Exception e) {
            throw new MojoFailureException("Failure while visiting source docs.", (Throwable)e);
        }
    }

    public static int validateDocsForLanguage(final Path path, Language lang, List<FaqEntry> faqs, final BiConsumer<Severity, String> call, Log log) throws MojoFailureException {
        final Holder<Integer> scannedDocs = new Holder<Integer>(0);
        final Holder<Boolean> mainPageFound = new Holder<Boolean>(false);
        final HashMap<String, List<String>> titleInPages = new HashMap<String, List<String>>();
        final HashMap<String, Integer> filesCount = new HashMap<String, Integer>();
        HashMap<String, String> foundFaqPages = new HashMap<String, String>();
        try {
            Path toc = path.getParent().resolve(CONFIG_NAMES_FILE_TOC);
            final HashMap<String, String> linkedPagesInToc = new HashMap<String, String>();
            if (Files.exists(toc, new LinkOption[0])) {
                DocetPluginUtils.validateToc(toc, linkedPagesInToc, call);
                DocetPluginUtils.validateFaqIndex(toc, foundFaqPages, linkedPagesInToc, call);
            } else {
                call.accept(Severity.ERROR, "TOC 'Table of Contents' file 'toc.html' not found!");
            }
            Path imgs = path.getParent().resolve(CONFIG_NAMES_FOLDER_IMAGES);
            Set<String> foundImages = DocetPluginUtils.retrieveImageNames(imgs, call, log);
            final HashSet<String> imagesLinkedInPages = new HashSet<String>();
            if (log.isDebugEnabled()) {
                linkedPagesInToc.keySet().stream().forEach(item -> log.debug((CharSequence)("[" + (Object)((Object)lang) + "] LINKED PAGE FOUND -> '" + item + "'")));
            }
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path file, BasicFileAttributes attrs) throws IOException {
                    if (file.toFile().getName().startsWith(".")) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (file.getFileName().toString().startsWith(".")) {
                        return FileVisitResult.CONTINUE;
                    }
                    if (file.endsWith("main.html")) {
                        mainPageFound.setValue(true);
                        linkedPagesInToc.put("main.html", "Main page");
                    }
                    try {
                        String fileName = file.toFile().getName();
                        if (linkedPagesInToc.get(fileName) == null) {
                            Document unlinkedDoc = Jsoup.parse((String)DocetPluginUtils.readAll(file, ENCODING_UTF8));
                            Element headElement = unlinkedDoc.getElementsByTag("head").first();
                            if (headElement == null) {
                                call.accept(Severity.ERROR, "NON-LINKED (UNUSED) FILE FOUND: " + fileName);
                                return FileVisitResult.CONTINUE;
                            }
                            Elements metaElements = headElement.select("meta[name]");
                            for (Element el : metaElements) {
                                if (!DocetPluginUtils.DOCET_META_ATTR_REFERENCE_HIDDEN_PAGE.equals(el.attr("name"))) continue;
                                DocetPluginUtils.validateDoc(path, file, call, titleInPages, imagesLinkedInPages, filesCount);
                                scannedDocs.setValue((Integer)scannedDocs.getValue() + 1);
                                return FileVisitResult.CONTINUE;
                            }
                            call.accept(Severity.ERROR, "NON-LINKED (UNUSED) FILE FOUND: " + fileName);
                            return FileVisitResult.CONTINUE;
                        }
                        DocetPluginUtils.validateDoc(path, file, call, titleInPages, imagesLinkedInPages, filesCount);
                        scannedDocs.setValue((Integer)scannedDocs.getValue() + 1);
                    }
                    catch (Exception ex) {
                        call.accept(Severity.ERROR, "File " + file + " cannot be read. " + ex);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
            DocetPluginUtils.checkForDuplicatePageTitles(titleInPages, call);
            DocetPluginUtils.checkForDuplicateFileNames(filesCount, call);
            DocetPluginUtils.checkForOrphanImages(foundImages, imagesLinkedInPages, call);
            Path faqPath = path.getParent().resolve("faq");
            DocetPluginUtils.validateFaqs(faqPath, faqs, call, foundFaqPages, linkedPagesInToc, false);
            DocetPluginUtils.validateFaqs(faqPath, faqs, call, foundFaqPages, linkedPagesInToc, true);
            DocetPluginUtils.checkForOrphanFaqLinks(faqs, foundFaqPages.keySet(), call);
            if (!mainPageFound.getValue().booleanValue()) {
                call.accept(Severity.WARN, "Main page file 'main.html' not found");
            }
            linkedPagesInToc.keySet().stream().filter(pageName -> pageName.startsWith(FAQ_DEFAULT_PAGE_PREFIX)).forEach(pageName -> call.accept(Severity.ERROR, "NON-LINKED (UNUSED) FAQ FILE FOUND: " + pageName));
        }
        catch (Exception e) {
            throw new MojoFailureException("Failure while visiting source docs.", (Throwable)e);
        }
        return scannedDocs.getValue();
    }

    private static void checkForOrphanImages(Set<String> imgsInFileSystem, Set<String> imgsLinked, BiConsumer<Severity, String> issueLogger) {
        Set linkedImgsNames = imgsLinked.stream().map(img -> img.split("@")[0]).collect(Collectors.toSet());
        imgsInFileSystem.stream().filter(img -> !linkedImgsNames.contains(img)).forEach(img -> issueLogger.accept(Severity.ERROR, "[ORPHAN IMAGE] Found UNUSED IMAGE " + img));
    }

    private static void checkForOrphanFaqLinks(List<FaqEntry> faqsToAdd, Set<String> faqsWithLinks, BiConsumer<Severity, String> issueCall) {
        List faqsToAddNames = faqsToAdd.stream().map(entry -> entry.getFaqPath().toFile().getName()).collect(Collectors.toList());
        faqsWithLinks.stream().filter(faq -> !faqsToAddNames.contains(faq.split("@")[0])).collect(Collectors.toList()).forEach(orphan -> {
            String[] tokens = orphan.split("@");
            String srcPage = tokens[1];
            String targetFaqPage = tokens[0];
            issueCall.accept(Severity.ERROR, "[FAQ] [ORPHAN LINK] [" + srcPage + "] links to unexisting faq -> " + targetFaqPage);
        });
    }

    private static void validateFaqs(Path faqFolderPath, final List<FaqEntry> faqs, final BiConsumer<Severity, String> call, final Map<String, String> faqPages, final Map<String, String> pagesFoundInTOC, final boolean generateEntries) throws IOException {
        if (!Files.isDirectory(faqFolderPath, new LinkOption[0])) {
            call.accept(Severity.WARN, "[FAQ] Directory " + faqFolderPath.toAbsolutePath() + " not found");
            return;
        }
        Files.walkFileTree(faqFolderPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path file, BasicFileAttributes attrs) throws IOException {
                if (file.toFile().getName().startsWith(".")) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (file.getFileName().toString().startsWith(".")) {
                    return FileVisitResult.CONTINUE;
                }
                String fileName = file.getFileName().toString();
                Document htmlDoc = Jsoup.parseBodyFragment((String)DocetPluginUtils.readAll(file, ENCODING_UTF8));
                Elements links = htmlDoc.select("a.faq-link");
                links.stream().forEach(link -> faqPages.put(link.attr("href").split("#")[0] + "@" + fileName, link.text()));
                if (generateEntries) {
                    String title = (String)pagesFoundInTOC.remove(DocetPluginUtils.FAQ_DEFAULT_PAGE_PREFIX + fileName);
                    boolean found = faqPages.keySet().stream().anyMatch(faq -> faq.startsWith(fileName + "@"));
                    if (found || title != null) {
                        String faqTitle = title != null ? title : faqPages.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(fileName)).findFirst().map(e -> (String)e.getValue()).orElse("");
                        try {
                            DocetPluginUtils.parseFaqEntry(file, faqTitle, faqs, call);
                        }
                        catch (Exception ex) {
                            call.accept(Severity.WARN, "FAQ File " + file + " cannot be read. " + ex);
                        }
                    } else {
                        call.accept(Severity.ERROR, "[FAQ] Found an unused faq file '" + file + "'");
                    }
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private static void parseFaqEntry(Path file, String faqTitle, List<FaqEntry> faqs, BiConsumer<Severity, String> call) throws IOException, SAXException, TikaException {
        Path pagesPath = file.getParent().getParent().resolve(CONFIG_NAMES_FOLDER_PAGES);
        Path pdfPath = pagesPath.getParent().resolve(CONFIG_NAMES_FOLDER_PDFS);
        Path imagesPath = pagesPath.getParent().resolve(CONFIG_NAMES_FOLDER_IMAGES);
        Path faqPath = pagesPath.getParent().resolve("faq");
        Document htmlDoc = Jsoup.parseBodyFragment((String)DocetPluginUtils.readAll(file, ENCODING_UTF8));
        Elements divMain = htmlDoc.select("div#main");
        switch (divMain.size()) {
            case 0: {
                call.accept(Severity.ERROR, "[FAQ] [" + file.getFileName() + "] Body is empty");
                break;
            }
            case 1: {
                break;
            }
            default: {
                call.accept(Severity.ERROR, "[FAQ] [" + file.getFileName() + "] Expected just one main element <div id=\"main\">, found: " + divMain.size());
            }
        }
        Elements links = htmlDoc.select("a:not(.question)");
        links.stream().forEach(link -> {
            if (!link.hasAttr("href")) {
                call.accept(Severity.ERROR, "[FAQ] [" + file.getFileName() + "] Found anchor without HREF attribute '" + link + "'");
                return;
            }
            String href = link.attr("href");
            boolean isFaqLink = link.hasClass("faq-link");
            String pageLink = null;
            if (href.startsWith("#")) {
                return;
            }
            try {
                boolean isPdfLink;
                boolean pageExists;
                if (href.startsWith("http://") || href.startsWith("https://")) {
                    pageExists = true;
                    pageLink = href;
                    isPdfLink = false;
                } else {
                    String[] linkTokens = link.attr("href").split("/");
                    pageLink = linkTokens[linkTokens.length - 1];
                    if (pageLink.startsWith("#")) {
                        pageExists = !htmlDoc.select(pageLink).isEmpty();
                        isPdfLink = false;
                    } else if (pageLink.isEmpty()) {
                        call.accept(Severity.WARN, "[FAQ] [" + file.getFileName() + "] Found anchor '" + link + "' WITH EMPTY HREF: was this done on purpose?");
                        pageExists = true;
                        isPdfLink = false;
                    } else if (pageLink.endsWith(".pdf")) {
                        isPdfLink = true;
                        pageExists = DocetPluginUtils.fileExists(pdfPath, pageLink.replace(".pdf", ".html"));
                    } else {
                        isPdfLink = false;
                        pageExists = DocetPluginUtils.fileExists(isFaqLink ? faqPath : pagesPath, pageLink);
                    }
                }
                if (!pageExists) {
                    if (isPdfLink) {
                        call.accept(Severity.ERROR, "[FAQ] [" + file.getFileName() + "] Referred pdf '" + pageLink + "' does not exist");
                    } else {
                        call.accept(Severity.ERROR, "[FAQ] [" + file.getFileName() + "] Referred " + (isFaqLink ? "faq" : "") + " page '" + pageLink + "' does not exist");
                    }
                }
            }
            catch (IOException e) {
                call.accept(Severity.ERROR, "[FAQ] [" + file.getFileName() + "] Referred page '" + pageLink + "' existence cannot be checked. Reason: " + e);
            }
        });
        Elements images = htmlDoc.getElementsByTag("img");
        images.stream().forEach(image -> {
            if (!image.hasAttr("src")) {
                call.accept(Severity.ERROR, "[FAQ] [" + file.getFileName() + "] Found image without SRC attribute '" + image + "'");
                return;
            }
            String[] linkTokens = image.attr("src").split("/");
            String imageLink = linkTokens[linkTokens.length - 1];
            String fileExtension = imageLink.substring(imageLink.lastIndexOf(46) + 1);
            boolean formatAllowed = DocetPluginUtils.allowedFileExtension(fileExtension);
            try {
                if (formatAllowed) {
                    boolean imageExists = DocetPluginUtils.fileExists(imagesPath, imageLink);
                    if (!imageExists) {
                        call.accept(Severity.ERROR, "[FAQ] [" + file.getFileName() + "] Referred image '" + imageLink + "' does not exist");
                    }
                } else {
                    call.accept(Severity.ERROR, "[FAQ] [" + file.getFileName() + "] Referred image '" + imageLink + "' unsupported format");
                }
            }
            catch (IOException e) {
                call.accept(Severity.ERROR, "[FAQ] [" + file.getFileName() + "] Referred image '" + imageLink + "' existence cannot be inferred. Reason: " + e);
            }
        });
        Elements title = htmlDoc.select("h1");
        long foundTitles = title.stream().peek(h1 -> {
            if (h1.text().isEmpty()) {
                call.accept(Severity.ERROR, "[FAQ] [" + file.getFileName() + "] Title is empty");
            }
        }).count();
        if (foundTitles > 1L) {
            call.accept(Severity.ERROR, "[FAQ] [" + file.getFileName() + "] Found " + foundTitles + ". Just one should be provided");
        }
        if (foundTitles == 0L) {
            call.accept(Severity.ERROR, "[FAQ] [" + file.getFileName() + "] No titles Found: 1 must be provided");
        }
        Elements divBoxes = htmlDoc.select("div");
        divBoxes.stream().forEach(div -> {
            if (!(!div.hasClass("msg") || div.hasClass("tip") || div.hasClass("info") || div.hasClass("note") || div.hasClass("warning"))) {
                call.accept(Severity.ERROR, "[FAQ] [" + file.getFileName() + "] Found div.msg with not qualifying class [tip|info|note|warning]");
            }
        });
        faqs.add(new FaqEntry(file, faqTitle));
    }

    private static void validateDoc(Path rootPath, Path file, BiConsumer<Severity, String> call, Map<String, List<String>> titleInPages, Set<String> linkedImages, Map<String, Integer> filesCount) throws IOException, SAXException, TikaException {
        Path pagesPath = rootPath;
        Path pdfPath = rootPath.getParent().resolve(CONFIG_NAMES_FOLDER_PDFS);
        Path imagesPath = rootPath.getParent().resolve(CONFIG_NAMES_FOLDER_IMAGES);
        Path faqPath = rootPath.getParent().resolve("faq");
        String fileName = file.getFileName().toString();
        filesCount.merge(fileName, 1, (c1, c2) -> c1 + c2);
        Document htmlDoc = Jsoup.parseBodyFragment((String)DocetPluginUtils.readAll(file, ENCODING_UTF8));
        Elements divMain = htmlDoc.select("div#main");
        switch (divMain.size()) {
            case 0: {
                call.accept(Severity.ERROR, "[" + file.getFileName() + "] Body is empty");
                break;
            }
            case 1: {
                break;
            }
            default: {
                call.accept(Severity.ERROR, "[" + file.getFileName() + "] Expected just one main element <div id=\"main\">, found: " + divMain.size());
            }
        }
        Elements links = htmlDoc.select("a:not(.question)");
        links.stream().forEach(link -> {
            if (!link.hasAttr("href")) {
                call.accept(Severity.ERROR, "[" + file.getFileName() + "] Found anchor without HREF attribute '" + link + "'");
                return;
            }
            String href = link.attr("href");
            boolean isFaqLink = link.hasClass("faq-link");
            String pageLink = null;
            if (href.startsWith("#")) {
                return;
            }
            try {
                boolean isPdfLink;
                boolean pageExists;
                if (href.startsWith("http://") || href.startsWith("https://")) {
                    pageExists = true;
                    pageLink = href;
                    isPdfLink = false;
                } else {
                    String[] linkTokens = link.attr("href").split("/");
                    pageLink = linkTokens[linkTokens.length - 1];
                    if (pageLink.startsWith("#")) {
                        pageExists = !htmlDoc.select(pageLink).isEmpty();
                        isPdfLink = false;
                    } else if (pageLink.isEmpty()) {
                        call.accept(Severity.WARN, "[" + file.getFileName() + "] Found anchor '" + link + "' WITH EMPTY HREF: was this done on purpose?");
                        pageExists = true;
                        isPdfLink = false;
                    } else if (pageLink.endsWith(".pdf")) {
                        isPdfLink = true;
                        pageExists = DocetPluginUtils.fileExists(pdfPath, pageLink.replace(".pdf", ".html"));
                    } else {
                        isPdfLink = false;
                        pageExists = DocetPluginUtils.fileExists(isFaqLink ? faqPath : pagesPath, pageLink);
                    }
                }
                if (!pageExists) {
                    if (isPdfLink) {
                        call.accept(Severity.ERROR, "[" + file.getFileName() + "] Referred pdf '" + pageLink + "' does not exist");
                    } else {
                        call.accept(Severity.ERROR, "[" + file.getFileName() + "] Referred " + (isFaqLink ? "faq" : "") + " page '" + pageLink + "' does not exist");
                    }
                }
            }
            catch (IOException e) {
                call.accept(Severity.ERROR, "[" + file.getFileName() + "] Referred page '" + pageLink + "' existence cannot be checked. Reason: " + e);
            }
        });
        Elements images = htmlDoc.getElementsByTag("img");
        images.stream().forEach(image -> {
            if (!image.hasAttr("src")) {
                call.accept(Severity.ERROR, "[" + file.getFileName() + "] Found image without SRC attribute '" + image + "'");
                return;
            }
            String[] linkTokens = image.attr("src").split("/");
            String imageLink = linkTokens[linkTokens.length - 1];
            linkedImages.add(imageLink + "@" + fileName);
            String fileExtension = imageLink.substring(imageLink.lastIndexOf(46) + 1);
            boolean formatAllowed = DocetPluginUtils.allowedFileExtension(fileExtension);
            try {
                if (formatAllowed) {
                    boolean imageExists = DocetPluginUtils.fileExists(imagesPath, imageLink);
                    if (!imageExists) {
                        call.accept(Severity.ERROR, "[" + file.getFileName() + "] Referred image '" + imageLink + "' does not exist");
                    }
                } else {
                    call.accept(Severity.ERROR, "[" + file.getFileName() + "] Referred image '" + imageLink + "' unsupported format");
                }
            }
            catch (IOException e) {
                call.accept(Severity.ERROR, "[" + file.getFileName() + "] Referred image '" + imageLink + "' existence cannot be inferred. Reason: " + e);
            }
        });
        Elements title = htmlDoc.select("h1");
        long foundTitles = title.stream().peek(h1 -> {
            if (h1.text().isEmpty()) {
                call.accept(Severity.ERROR, "[" + file.getFileName() + "] Title is empty");
            }
        }).count();
        if (foundTitles > 1L) {
            call.accept(Severity.ERROR, "[" + file.getFileName() + "] Found " + foundTitles + ". Just one should be provided");
        }
        if (foundTitles == 0L) {
            call.accept(Severity.ERROR, "[" + file.getFileName() + "] No titles Found: 1 must be provided");
        } else if (foundTitles == 1L) {
            ArrayList<String> currentPageAsList = new ArrayList<String>();
            currentPageAsList.add(file.getFileName().toString());
            titleInPages.merge(title.text().trim(), currentPageAsList, (l1, l2) -> {
                l1.addAll(l2);
                return l1;
            });
        }
        Elements divBoxes = htmlDoc.select("div");
        divBoxes.stream().forEach(div -> {
            if (!(!div.hasClass("msg") || div.hasClass("tip") || div.hasClass("info") || div.hasClass("note") || div.hasClass("warning"))) {
                call.accept(Severity.ERROR, "[" + file.getFileName() + "] Found div.msg with not qualifying class [tip|info|note|warning]");
            }
        });
    }

    private static void checkForDuplicatePageTitles(Map<String, List<String>> titleInPages, BiConsumer<Severity, String> call) {
        titleInPages.entrySet().stream().forEach(entry -> {
            if (((List)entry.getValue()).size() > 1) {
                call.accept(Severity.ERROR, "Title '" + (String)entry.getKey() + "' has been used on multiple pages: " + Arrays.toString(((List)entry.getValue()).toArray(new String[0])));
            }
        });
    }

    private static void checkForDuplicateFileNames(Map<String, Integer> pageNameCount, BiConsumer<Severity, String> call) {
        pageNameCount.entrySet().stream().forEach(entry -> {
            if ((Integer)entry.getValue() > 1) {
                call.accept(Severity.ERROR, "[" + (String)entry.getKey() + "] found " + entry.getValue() + " instances: this is going to cause linking issues!");
            }
        });
    }

    private static void validateFaqIndex(Path faq, Map<String, String> foundFaqs, Map<String, String> foundLinkedFaqs, BiConsumer<Severity, String> call) throws IOException {
        Document htmlDoc = Jsoup.parseBodyFragment((String)DocetPluginUtils.readAll(faq, ENCODING_UTF8));
        Elements faqItems = htmlDoc.select("#docet-faq-menu a");
        if (faqItems.isEmpty()) {
            call.accept(Severity.WARN, "[TOC] NO FAQs defined in table of contents");
            return;
        }
        faqItems.forEach(item -> {
            String faqHref = item.attr("href").split("#")[0];
            Path faqItemFile = faq.getParent().resolve("faq").resolve(faqHref);
            if (!Files.exists(faqItemFile, new LinkOption[0])) {
                call.accept(Severity.ERROR, "[FAQ] A file '" + faqHref + "' is linked in faq list but does not exist");
            } else {
                foundFaqs.put(faqHref + "@" + faq.getFileName(), item.text());
                foundLinkedFaqs.put(FAQ_DEFAULT_PAGE_PREFIX + faqHref.split("#")[0], item.text().trim());
            }
        });
    }

    private static void validatePdf(Path pdfToc, BiConsumer<Severity, String> call) throws IOException, SAXException {
        String pdfName = pdfToc.getFileName().toString();
        Document pdfDoc = Jsoup.parse((String)DocetPluginUtils.readAll(pdfToc, ENCODING_UTF8));
        Element title = pdfDoc.getElementsByTag("title").first();
        if (title != null) {
            if (title.text().isEmpty()) {
                call.accept(Severity.ERROR, "[PDF] [" + pdfName + "] Title cannot be empty");
            }
        } else {
            call.accept(Severity.ERROR, "[PDF] [" + pdfName + "] No valid title was found");
        }
        Elements nav = pdfDoc.getElementsByTag("nav");
        DocetPluginUtils.checkNavStructure(nav, "[PDF] [" + pdfName + "]", call);
        Path pagesPathForLang = pdfToc.getParent().getParent().resolve(CONFIG_NAMES_FOLDER_PAGES);
        Path mainDocsFolder = pdfToc.getParent().getParent().getParent();
        Elements links = pdfDoc.getElementsByTag("a");
        links.stream().forEach(link -> {
            Path pagesCheckFolder;
            String[] linkTokens = link.attr("href").split("/");
            String pageLink = linkTokens[linkTokens.length - 1];
            boolean pageExists = false;
            String refLanguage = link.attr(DOCET_HTML_ATTR_REFERENCE_LANGUAGE_NAME);
            if (refLanguage.isEmpty()) {
                pagesCheckFolder = pagesPathForLang;
            } else {
                Language validlang = Language.getLanguageByCode(refLanguage);
                if (validlang == null) {
                    call.accept(Severity.ERROR, "[PDF] [" + pdfName + "] page '" + pageLink + "' reference language '" + refLanguage + "' is not supported!");
                    return;
                }
                pagesCheckFolder = mainDocsFolder.resolve(refLanguage);
            }
            try {
                pageExists = DocetPluginUtils.fileExists(pagesCheckFolder, pageLink);
                if (!pageExists) {
                    String referenceLangMsg = refLanguage.isEmpty() ? "" : " (reference language=" + refLanguage + ")";
                    call.accept(Severity.ERROR, "[PDF] [" + pdfName + "] page '" + pageLink + "'" + referenceLangMsg + " does not exist");
                }
            }
            catch (IOException e) {
                call.accept(Severity.ERROR, "[PDF] [" + pdfName + "] page '" + pageLink + "' existence cannot be checked. Reason: " + e);
            }
        });
    }

    private static void validateToc(Path toc, Map<String, String> linkedPagesFound, BiConsumer<Severity, String> call) throws IOException, SAXException {
        Document htmlDoc = Jsoup.parseBodyFragment((String)DocetPluginUtils.readAll(toc, ENCODING_UTF8));
        Elements nav = htmlDoc.getElementsByTag("nav");
        DocetPluginUtils.checkNavStructure(nav, "[TOC]", call);
        HashSet linkedPages = new HashSet();
        Path pagesPath = toc.getParent().resolve(CONFIG_NAMES_FOLDER_PAGES);
        Path faqPath = toc.getParent().resolve("faq");
        Elements links = htmlDoc.getElementsByTag("a");
        Element faqMainLink = htmlDoc.getElementById(FAQ_HOME_ANCHOR_ID);
        Elements faqAnchors = new Elements();
        if (faqMainLink != null && !(faqAnchors = faqMainLink.parent().select("ul")).isEmpty()) {
            faqAnchors = faqAnchors.select("a");
        }
        Elements faqUltimateAnchors = faqAnchors;
        links.stream().forEach(link -> {
            String[] linkTokens = link.attr("href").split("/");
            String pageLink = linkTokens[linkTokens.length - 1];
            boolean pageExists = false;
            boolean pageAlreadyLinked = false;
            boolean isFaq = faqUltimateAnchors.contains(link);
            try {
                pageExists = DocetPluginUtils.fileExists(isFaq ? faqPath : pagesPath, pageLink);
                if (!pageExists) {
                    call.accept(Severity.ERROR, "[TOC] Referred " + (isFaq ? "FAQ" : "") + " page '" + pageLink + "' does not exist");
                } else {
                    boolean bl = pageAlreadyLinked = !linkedPages.add(isFaq + "-" + pageLink);
                    if (isFaq) {
                        linkedPagesFound.put(FAQ_DEFAULT_PAGE_PREFIX + pageLink.split("#")[0], link.text().trim());
                    } else {
                        linkedPagesFound.put(pageLink.split("#")[0], link.text().trim());
                    }
                }
                if (pageAlreadyLinked) {
                    call.accept(Severity.ERROR, "[TOC] " + (isFaq ? "FAQ" : "") + " page '" + pageLink + "' is mentioned in TOC multiple times");
                }
            }
            catch (IOException e) {
                call.accept(Severity.ERROR, "[TOC] Referred " + (isFaq ? "FAQ" : "") + " page '" + pageLink + "' existence cannot be checked. Reason: " + e);
            }
        });
    }

    private static void checkNavStructure(Elements nav, String logPrefix, BiConsumer<Severity, String> call) {
        int navNum = nav.size();
        if (navNum == 0) {
            call.accept(Severity.ERROR, logPrefix + " is currently empty");
        }
        if (navNum > 1) {
            call.accept(Severity.ERROR, logPrefix + " defined " + navNum + " navs. One expected.");
        }
        nav.stream().forEach(n -> {
            List straightChildUls;
            Elements ul = n.getElementsByTag("ul");
            int ulNum = ul.size();
            if (ulNum == 0) {
                call.accept(Severity.ERROR, logPrefix + " is currently empty");
            }
            if ((straightChildUls = n.childNodes().stream().filter(nd -> "ul".equals(nd.nodeName())).collect(Collectors.toList())).size() > 1) {
                call.accept(Severity.ERROR, logPrefix + " nav contains " + ulNum + " ULs. One expected.");
            }
            if (ulNum == 1) {
                Elements lis = ((Element)ul.get(0)).children();
                if (lis.isEmpty()) {
                    call.accept(Severity.ERROR, logPrefix + " is currently empty");
                }
                lis.stream().forEach(l -> {
                    if (!"li".equals(l.tag().toString())) {
                        call.accept(Severity.ERROR, logPrefix + " Expected <li>, found: <" + l.tag() + ">");
                    } else {
                        Elements anchor = l.children();
                        switch (anchor.size()) {
                            case 0: {
                                call.accept(Severity.ERROR, logPrefix + " Empty <li> found");
                                break;
                            }
                            case 1: {
                                if ("a".equals(((Element)anchor.get(0)).tag().toString())) break;
                                call.accept(Severity.ERROR, logPrefix + " found <li> with no <a> included");
                                break;
                            }
                            case 2: {
                                if (!"a".equals(((Element)anchor.get(0)).tag().toString())) {
                                    call.accept(Severity.ERROR, logPrefix + " <li> -> expected <a>, found <" + ((Element)anchor.get(0)).tag() + ">");
                                }
                                if ("ul".equals(((Element)anchor.get(1)).tag().toString())) break;
                                call.accept(Severity.ERROR, logPrefix + " <li> -> expected <ul>, found <" + ((Element)anchor.get(1)).tag() + ">");
                                break;
                            }
                            default: {
                                call.accept(Severity.ERROR, logPrefix + " found <li> containing " + anchor.size() + " elements. An <li> must include no more than a <a> and a <ul>!");
                            }
                        }
                    }
                });
            }
        });
    }

    private static boolean fileExists(Path basePath, String fileName) throws IOException {
        final Holder<Boolean> result = new Holder<Boolean>(false);
        final String actualFileName = fileName.contains("#") ? fileName.split("#")[0] : fileName;
        Files.walkFileTree(basePath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (file.endsWith(actualFileName)) {
                    result.setValue(true);
                    return FileVisitResult.TERMINATE;
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return (Boolean)((Holder)result).value;
    }

    private static boolean allowedFileExtension(String fileExtension) {
        return Arrays.asList(ForbiddenExtensions.values()).stream().filter(ext -> ext.extension().equals(fileExtension)).count() == 0L;
    }

    public static void copyingDocs(Path outDir, Log log) {
        log.info((CharSequence)"Operation will be available soon!");
        throw new UnsupportedOperationException("Operation not yet available");
    }

    public static Map<Language, List<DocetIssue>> generatePdfsForLanguage(Path srcDir, Path outDir, Path tmpDir, String langCode, Log log) throws MojoFailureException {
        EnumMap<Language, List<DocetIssue>> result = new EnumMap<Language, List<DocetIssue>>(Language.class);
        ArrayList<DocetIssue> messages = new ArrayList<DocetIssue>();
        Path langPath = srcDir.resolve(langCode);
        langPath = langPath.resolve(CONFIG_NAMES_FOLDER_PAGES);
        Language lang = Language.getLanguageByCode(langCode);
        if (lang == null) {
            throw new MojoFailureException("Language [" + langCode + "] is not supported!");
        }
        if (Files.isDirectory(langPath, new LinkOption[0])) {
            Path tocPath = langPath.getParent().resolve(CONFIG_NAMES_FILE_TOC);
            Path outputDir = outDir;
            try {
                TOC comprenhesiveToc = DocetPluginUtils.parseTOCFromPath(tocPath, tmpDir, messages);
                comprenhesiveToc.getItems().stream().forEach(item -> {
                    String outFileName = Paths.get(item.getPagePath(), new String[0]).getFileName().toString();
                    outFileName = outFileName.replaceFirst("\\.html", "\\.pdf");
                    Path pdfFile = outputDir.resolve(outFileName);
                    log.debug((CharSequence)("reading " + item + "; generating pdf: " + pdfFile));
                });
            }
            catch (IOException e) {
                messages.add(new DocetIssue(Severity.ERROR, "Impossible to read TOC. Reason: " + e));
            }
        } else {
            messages.add(new DocetIssue(Severity.WARN, "No folder found for language"));
        }
        result.put(lang, messages);
        return result;
    }

    private static TOC parseTOCFromPath(Path tocFilePath, Path tmpDir, List<DocetIssue> messages) throws IOException {
        TOC toc = new TOC();
        Document htmlDoc = Jsoup.parseBodyFragment((String)DocetPluginUtils.readAll(tocFilePath, ENCODING_UTF8));
        Elements mainTOCItems = htmlDoc.select("nav#docet-menu>ul>li");
        mainTOCItems.forEach(el -> {
            String fileName = ((Element)el.getElementsByTag("a").get(0)).attr("href");
            try {
                Path actualPagePath = DocetPluginUtils.searchFileInBasePathByName(tocFilePath.getParent().resolve(CONFIG_NAMES_FOLDER_PAGES), fileName);
                Document sanitizedDoc = DocetPluginUtils.prepareHTMLForConversion(actualPagePath, tocFilePath.getParent());
                actualPagePath = DocetPluginUtils.saveDocumentToDirectory(sanitizedDoc, actualPagePath.getFileName().toString(), tmpDir);
                TOC.TOCItem item = new TOC.TOCItem(actualPagePath.toString());
                DocetPluginUtils.populateTOCSubtree(tocFilePath, tmpDir, item, el.select("ul>li"), 1, messages);
                toc.addItem(item);
            }
            catch (Exception e) {
                messages.add(new DocetIssue(Severity.ERROR, "Error while parsing TOC. Reason: " + e));
            }
        });
        return toc;
    }

    private static Path saveDocumentToDirectory(Document doc, String fileName, Path tmpDir) throws IOException {
        Path outTmpPath = tmpDir.resolve(fileName);
        DocetPluginUtils.writeAll(outTmpPath, doc.outerHtml(), ENCODING_UTF8);
        return outTmpPath;
    }

    private static void populateTOCSubtree(Path tocFilePath, Path tmpDir, TOC.TOCItem item, Elements domSubitems, int level, List<DocetIssue> messages) {
        if (domSubitems.isEmpty()) {
            return;
        }
        domSubitems.forEach(el -> {
            try {
                String fileName = ((Element)el.getElementsByTag("a").get(0)).attr("href");
                Path actualPagePath = DocetPluginUtils.searchFileInBasePathByName(tocFilePath.getParent().resolve(CONFIG_NAMES_FOLDER_PAGES), fileName);
                Document sanitizedDoc = DocetPluginUtils.prepareHTMLForConversion(actualPagePath, tocFilePath.getParent());
                actualPagePath = DocetPluginUtils.saveDocumentToDirectory(sanitizedDoc, actualPagePath.getFileName().toString(), tmpDir);
                TOC.TOCItem subItem = new TOC.TOCItem(actualPagePath.toString(), level);
                DocetPluginUtils.populateTOCSubtree(tocFilePath, tmpDir, subItem, el.select("ul>li"), level + 1, messages);
                item.addSubItem(subItem);
            }
            catch (Exception e) {
                messages.add(new DocetIssue(Severity.ERROR, "Error while parsing TOC. Reason: " + e));
            }
        });
    }

    private static Document prepareHTMLForConversion(Path htmlPagePath, Path basePath) throws IOException {
        Document doc = Jsoup.parse((String)DocetPluginUtils.readAll(htmlPagePath, ENCODING_UTF8), (String)"", (Parser)Parser.xmlParser());
        doc.getElementsByTag("head").append("<link href=\"src/docs/mndoc.css\" type=\"text/css\" rel=\"stylesheet\" />");
        Elements images = doc.select("img");
        for (Element img : images) {
            img.attr("src", DocetPluginUtils.searchFileInBasePathByName(basePath, img.attr("src")).toString());
        }
        return doc;
    }

    private static Path searchFileInBasePathByName(Path basePath, String fileName) throws IOException {
        final Holder<Object> result = new Holder<Object>(null);
        final String parsedFilename = fileName.split("#")[0];
        Files.walkFileTree(basePath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (file.endsWith(parsedFilename)) {
                    result.setValue(file);
                    return FileVisitResult.TERMINATE;
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return (Path)((Holder)result).value;
    }

    public static int zippingDocs(final Path srcDir, final Path outDir, final Path indexDir, boolean includeIndex, Path zipFileName, Map<Language, List<FaqEntry>> faqs, final Log log) throws MojoFailureException {
        final Holder<Integer> scannedDocs = new Holder<Integer>(0);
        final FileToZipFilter filter = new FileToZipFilter();
        try (OutputStream fos = Files.newOutputStream(zipFileName, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
             final ZipOutputStream zos = new ZipOutputStream(fos);){
            Files.walkFileTree(srcDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path file, BasicFileAttributes attrs) throws IOException {
                    if (file.toFile().getName().startsWith(".")) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Path normalizedPath = srcDir.normalize().relativize(file.normalize());
                    if (file.getFileName().toString().startsWith(".")) {
                        return FileVisitResult.CONTINUE;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((CharSequence)("Visiting file " + file.getFileName() + "; path " + normalizedPath));
                    }
                    if (filter.accept(file.toFile())) {
                        Language lang = DocetPluginUtils.extractLanguageFromPath(file);
                        if (file.toFile().getName().equals(DocetPluginUtils.CONFIG_NAMES_FILE_TOC)) {
                            Path tocPath = DocetPluginUtils.generateTocForFaq(outDir, file, lang, log);
                            DocetPluginUtils.writeFileToArchive(zos, srcDir.getParent().relativize(srcDir), tocPath);
                        } else {
                            DocetPluginUtils.writeFileToArchive(zos, srcDir.getParent().relativize(srcDir), file);
                        }
                    } else if (log.isDebugEnabled()) {
                        log.debug((CharSequence)("Skipped " + file.getFileName()));
                    }
                    scannedDocs.setValue((Integer)scannedDocs.getValue() + 1);
                    return FileVisitResult.CONTINUE;
                }
            });
            if (includeIndex) {
                Files.walkFileTree(indexDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        if (file.getFileName().toString().startsWith(".")) {
                            return FileVisitResult.CONTINUE;
                        }
                        if (log.isDebugEnabled()) {
                            log.debug((CharSequence)("Visiting index file " + file.getFileName() + "; path " + outDir.normalize().relativize(file.normalize())));
                        }
                        DocetPluginUtils.writeFileToArchive(zos, indexDir.getParent().relativize(indexDir), file);
                        scannedDocs.setValue((Integer)scannedDocs.getValue() + 1);
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
        }
        catch (IOException e) {
            throw new MojoFailureException("Error while generating zip archive: " + e, (Throwable)e);
        }
        return scannedDocs.getValue();
    }

    private static Language extractLanguageFromPath(Path path) {
        String pathRegexSeparator = "\\".equals(File.separator) ? "\\\\" : File.separator;
        String languagePathPattern = "(it|en|fr)" + pathRegexSeparator + "(faq|imgs|pdf|pages|toc\\.html)";
        Pattern pattern = Pattern.compile(languagePathPattern);
        Matcher matcher = pattern.matcher(path.toString());
        String lang = "";
        while (matcher.find()) {
            lang = matcher.group(1);
        }
        return Language.getLanguageByCode(lang);
    }

    private static Path generateTocForFaq(Path outDir, Path tocFile, Language lang, Log log) throws IOException {
        Element faqTocAnchor;
        Element faqHomeLink;
        Path outFaqDir = outDir.resolve(lang.toString());
        Files.createDirectories(outFaqDir, new FileAttribute[0]);
        Path outTocFile = outFaqDir.resolve(CONFIG_NAMES_FILE_TOC);
        Document htmlDoc = Jsoup.parseBodyFragment((String)DocetPluginUtils.readAll(tocFile, ENCODING_UTF8));
        if (log.isDebugEnabled()) {
            log.debug((CharSequence)htmlDoc.html());
        }
        if ((faqHomeLink = htmlDoc.getElementById(FAQ_HOME_ANCHOR_ID)) != null) {
            faqHomeLink.addClass("faq-a");
        }
        if ((faqTocAnchor = htmlDoc.getElementById(FAQ_TOC_ID)) != null) {
            Elements faqs = faqTocAnchor.select("a");
            faqs.stream().forEach(faq -> faq.addClass("faq-a"));
        }
        DocetPluginUtils.writeAll(outTocFile, htmlDoc.outerHtml(), ENCODING_UTF8);
        return outTocFile;
    }

    private static void writeFileToArchive(ZipOutputStream zos, Path baseSrcPath, Path filePath) throws IOException {
        byte[] buffer = new byte[1024];
        String zipPath = baseSrcPath.resolve(DocetPluginUtils.extractLanguageRelativePath(filePath)).toString();
        ZipEntry ze = new ZipEntry(zipPath);
        zos.putNextEntry(ze);
        try (InputStream in = Files.newInputStream(filePath, new OpenOption[0]);){
            int len;
            while ((len = in.read(buffer)) > 0) {
                zos.write(buffer, 0, len);
            }
        }
        zos.closeEntry();
    }

    private static String extractLanguageRelativePath(Path absolutePath) {
        String fileName = absolutePath != null && absolutePath.getFileName() != null ? absolutePath.getFileName().toString() : "";
        String pathRegexSeparator = "\\".equals(File.separator) ? "\\\\" : File.separator;
        String languagePathPattern = "(it|en|fr)" + pathRegexSeparator + "(faq|imgs|pages|pdf|toc\\.html)";
        Pattern pattern = Pattern.compile(languagePathPattern);
        String pathString = absolutePath != null ? absolutePath.toString() : "";
        Matcher matcher = pattern.matcher(pathString);
        String lang = "";
        String folderType = "";
        while (matcher.find()) {
            lang = matcher.group(1);
            folderType = matcher.group(2);
        }
        String result = lang + File.separator + folderType;
        if (result.endsWith(File.separator)) {
            result = fileName;
        } else if (!fileName.equals(CONFIG_NAMES_FILE_TOC)) {
            result = result + File.separator + fileName;
        }
        return result;
    }

    public static void indexDocs(Path outDir, Path srcDir, Map<Language, List<FaqEntry>> faqs, Log log, boolean compact) throws MojoFailureException {
        for (Language lang : Language.values()) {
            Path langPath = srcDir.resolve(lang.toString());
            if (Files.isDirectory(langPath = langPath.resolve(CONFIG_NAMES_FOLDER_PAGES), new LinkOption[0])) {
                DocetPluginUtils.indexDocsForLanguage(outDir, langPath, lang, faqs.get((Object)lang), log, compact);
                continue;
            }
            log.warn((CharSequence)("[" + (Object)((Object)lang) + "] No folder found for language"));
        }
    }

    public static int indexDocsForLanguage(Path outDir, Path path, final Language lang, List<FaqEntry> faqs, final Log log, boolean compact) throws MojoFailureException {
        final Holder<Integer> indexedDocs = new Holder<Integer>(0);
        try (FSDirectory dir = FSDirectory.open((Path)outDir);){
            Analyzer analyzer = new AnalyzerBuilder().language(lang).build();
            IndexWriterConfig iwc = new IndexWriterConfig(analyzer);
            iwc.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
            try (final IndexWriter writer = new IndexWriter((Directory)dir, iwc);){
                log.info((CharSequence)("[" + (Object)((Object)lang) + "] Building search index for language"));
                Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult preVisitDirectory(Path file, BasicFileAttributes attrs) throws IOException {
                        if (file.toFile().getName().startsWith(".")) {
                            return FileVisitResult.SKIP_SUBTREE;
                        }
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        if (file.getFileName().toString().startsWith(".")) {
                            return FileVisitResult.CONTINUE;
                        }
                        log.debug((CharSequence)("Visiting " + file));
                        try {
                            DocetPluginUtils.indexDoc(writer, file, attrs.lastModifiedTime().toMillis(), lang.toString(), log);
                            indexedDocs.setValue((Integer)indexedDocs.getValue() + 1);
                        }
                        catch (Exception ex) {
                            log.warn((CharSequence)("[" + (Object)((Object)lang) + "] File " + file + " cannot be read."), (Throwable)ex);
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
                Optional.ofNullable(faqs).orElseGet(() -> new ArrayList()).stream().forEach(faqPage -> {
                    try {
                        Path faqFile = faqPage.getFaqPath();
                        DocetPluginUtils.indexFaqPage(writer, faqFile, faqPage.getTitle(), faqFile.toFile().lastModified(), lang.toString(), log);
                        indexedDocs.setValue((Integer)indexedDocs.getValue() + 1);
                    }
                    catch (Exception ex) {
                        log.warn((CharSequence)("[" + (Object)((Object)lang) + "] FAQ File " + faqPage.getFaqPath() + " cannot be read."), (Throwable)ex);
                    }
                });
                if (compact) {
                    writer.forceMerge(1);
                }
                writer.commit();
                if (indexedDocs.getValue() == 0) {
                    log.warn((CharSequence)("[" + (Object)((Object)lang) + "] \t -> No docs found for language"));
                }
            }
            catch (IOException e) {
                throw new MojoFailureException("Impossible to index Docet docs.", (Throwable)e);
            }
        }
        catch (IOException e) {
            throw new MojoFailureException("Impossible to index Docet docs.", (Throwable)e);
        }
        return indexedDocs.getValue();
    }

    private static void indexGenericDoc(IndexWriter writer, Path file, long lastModified, String lang, String docTitle, String docAbstract, int docType, Log log) throws IOException, SAXException, TikaException {
        org.apache.lucene.document.Document doc = new org.apache.lucene.document.Document();
        try (InputStream stream = Files.newInputStream(file, new OpenOption[0]);){
            StringField pathField = new StringField("path", file.toString(), Field.Store.YES);
            doc.add((IndexableField)pathField);
            doc.add((IndexableField)new LongField("modified", lastModified, Field.Store.NO));
            doc.add((IndexableField)new TextField("contents-" + lang, DocetPluginUtils.convertDocToText(stream), Field.Store.YES));
            doc.add((IndexableField)new StringField("language", lang, Field.Store.YES));
            doc.add((IndexableField)new StringField("id", DocetPluginUtils.constructPageIdFromFilePath(file), Field.Store.YES));
            doc.add((IndexableField)new StringField("title", docTitle, Field.Store.YES));
            doc.add((IndexableField)new IntField("doctype", docType, Field.Store.YES));
            doc.add((IndexableField)new TextField("abstract", docAbstract, Field.Store.YES));
        }
        if (writer.getConfig().getOpenMode() == IndexWriterConfig.OpenMode.CREATE) {
            log.info((CharSequence)("[" + lang + "] Adding " + file + " to index"));
            log.debug((CharSequence)("document: " + doc));
            writer.addDocument((Iterable)doc);
        } else {
            log.debug((CharSequence)("[" + lang + "] Updating " + file + " to index"));
            writer.updateDocument(new Term("path", file.toString()), (Iterable)doc);
        }
    }

    private static void indexDoc(IndexWriter writer, Path file, long lastModified, String lang, Log log) throws IOException, SAXException, TikaException {
        String docTitle = "";
        String excerpt = "...";
        Document htmlDoc = Jsoup.parseBodyFragment((String)DocetPluginUtils.readAll(file, ENCODING_UTF8));
        docTitle = ((Element)htmlDoc.getElementsByTag("h1").get(0)).text();
        Elements pars = htmlDoc.select("div#main p#abstract");
        if (!pars.isEmpty()) {
            Element abstractPar = (Element)pars.get(0);
            String firstPar = abstractPar.text();
            String abstractText = firstPar != null && !firstPar.isEmpty() ? firstPar : "";
            excerpt = abstractText.length() <= 300 ? abstractText : abstractText.substring(0, 300) + "...";
        }
        DocetPluginUtils.indexGenericDoc(writer, file, lastModified, lang, docTitle, excerpt, 1, log);
    }

    private static void indexFaqPage(IndexWriter writer, Path file, String faqTitle, long lastModified, String lang, Log log) throws IOException, SAXException, TikaException {
        String excerpt = "";
        StringBuilder excerptBuilder = new StringBuilder();
        Document htmlDoc = Jsoup.parseBodyFragment((String)DocetPluginUtils.readAll(file, ENCODING_UTF8));
        Elements pars = htmlDoc.select("div.faq-item");
        for (Element faq : pars) {
            Elements questions = faq.select(".question");
            Elements answers = faq.select(".answer");
            String question = "";
            if (!questions.isEmpty()) {
                question = "<b> " + ((Element)questions.get(0)).text() + "</b><br/>";
            }
            String answer = "";
            if (!answers.isEmpty()) {
                String rawAnswer = ((Element)answers.get(0)).text();
                if (rawAnswer.length() > 90) {
                    rawAnswer = rawAnswer.substring(0, 90) + "...";
                }
                answer = rawAnswer;
            }
            excerptBuilder.append(question).append(answer).append("<br/>");
            excerpt = excerptBuilder.toString();
            if (excerpt.length() < 300) continue;
            break;
        }
        DocetPluginUtils.indexGenericDoc(writer, file, lastModified, lang, "FAQ - " + faqTitle, excerpt, 2, log);
    }

    private static String getFileSeparatorForString() {
        String separatorStr = "\\".equals(File.separator) ? "\\\\" : "/";
        return separatorStr;
    }

    private static String readAll(Path path, Charset cs) throws IOException {
        return new String(Files.readAllBytes(path), cs);
    }

    private static void writeAll(Path path, String data, Charset cs) throws IOException {
        try (OutputStream os = Files.newOutputStream(path, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            os.write(data.getBytes(ENCODING_UTF8));
        }
    }

    private static String constructPageIdFromFilePath(Path file) {
        String[] tokens = file.toString().split(DocetPluginUtils.getFileSeparatorForString());
        String fileName = tokens[tokens.length - 1];
        return fileName.split(".html")[0];
    }

    static String convertDocToText(InputStream streamDoc) throws IOException, SAXException, TikaException {
        AutoDetectParser parser = DocetPluginUtils.getTikaParser();
        BodyContentHandler handler = new BodyContentHandler();
        Metadata metadata = new Metadata();
        parser.parse(streamDoc, (ContentHandler)handler, metadata);
        return handler.toString();
    }

    static {
        ENCODING_UTF8 = StandardCharsets.UTF_8;
    }

    private static class AnalyzerBuilder {
        private Language lang = Language.IT;

        public AnalyzerBuilder language(Language lang) {
            this.lang = lang;
            return this;
        }

        public Analyzer build() {
            FrenchAnalyzer analyzer;
            switch (this.lang) {
                case FR: {
                    analyzer = new FrenchAnalyzer();
                    break;
                }
                case IT: {
                    analyzer = new ItalianAnalyzer();
                    break;
                }
                default: {
                    analyzer = new StandardAnalyzer();
                }
            }
            return analyzer;
        }
    }

    private static class FileToZipFilter
    implements FileFilter {
        private final String[] toSkipExtensions = new String[]{"css"};

        private FileToZipFilter() {
        }

        @Override
        public boolean accept(File file) {
            for (String extension : this.toSkipExtensions) {
                if (!file.getName().toLowerCase().endsWith(extension)) continue;
                return false;
            }
            return true;
        }
    }

    public static class Holder<T> {
        private T value;

        Holder(T value) {
            this.setValue(value);
        }

        T getValue() {
            return this.value;
        }

        void setValue(T value) {
            this.value = value;
        }
    }

    private static enum ForbiddenExtensions {
        JPEG("jpeg"),
        JPG("jpg");

        private String extension;

        private ForbiddenExtensions(String extension) {
            this.extension = extension;
        }

        public String extension() {
            return this.extension;
        }
    }

    public static enum Language {
        EN,
        FR,
        IT;


        public String toString() {
            return super.toString().toLowerCase();
        }

        public static Language getLanguageByCode(String code) {
            List foundLangs = Arrays.asList(Language.values()).stream().filter(l -> l.toString().equals(code)).collect(Collectors.toList());
            if (foundLangs.isEmpty()) {
                return null;
            }
            return (Language)((Object)foundLangs.get(0));
        }
    }
}

