/*
 * Decompiled with CFR 0.152.
 */
package org.docshare.mvc;

import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.FileTemplateLoader;
import freemarker.cache.MultiTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.cache.WebappTemplateLoader;
import freemarker.core.ParseException;
import freemarker.template.Configuration;
import freemarker.template.MalformedTemplateNameException;
import freemarker.template.Template;
import freemarker.template.TemplateExceptionHandler;
import freemarker.template.TemplateNotFoundException;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.HashMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.docshare.log.Log;
import org.docshare.mvc.CallCacheMap;
import org.docshare.mvc.Config;
import org.docshare.mvc.Controller;
import org.docshare.mvc.Loader;
import org.docshare.mvc.Rewriter;
import org.docshare.mvc.URLFilter;
import org.docshare.mvc.except.FreeMarkerHandler;
import org.docshare.util.RequestHelper;
import org.docshare.util.TextTool;

public class MVCFilter
implements Filter {
    private static MVCFilter ins;
    private Configuration fmCfg;
    private ServletContext application;
    private Rewriter rewriter = null;
    static Loader loader;
    HashMap<String, Object> map = new HashMap();

    static MVCFilter getIns() {
        return ins;
    }

    public void destroy() {
    }

    public Configuration getFmCfg() {
        return this.fmCfg;
    }

    private String getPureURI(String Uri, String context) {
        return Uri.replaceFirst(context + "/", "");
    }

    private boolean process(String uri, String context, HttpServletRequest req, HttpServletResponse resp, FilterChain chain) throws Exception {
        boolean r;
        String method;
        String cname;
        String temp = this.getPureURI(uri, context);
        Log.v("process " + temp);
        if (!temp.contains("/")) {
            temp = "index/" + temp;
        }
        String action = Config.controller + "." + temp;
        if ((action = action.replace("/", ".")).endsWith(".")) {
            cname = action.substring(0, action.length() - 1);
            method = "index";
        } else {
            int t = action.lastIndexOf(".");
            cname = action.substring(0, t);
            method = action.substring(t + 1);
        }
        if (cname == null || method == null) {
            Log.i((Object)("action fail =" + action));
            return false;
        }
        if (!cname.endsWith("Controller")) {
            int p = cname.lastIndexOf(".");
            String lastname = cname.substring(p + 1);
            lastname = Character.toUpperCase(lastname.charAt(0)) + lastname.substring(1) + "Controller";
            cname = cname.substring(0, p + 1) + lastname;
            cname = TextTool.underLineToUpper(cname);
        }
        if (r = loader.call(uri, cname, method, req, resp)) {
            return true;
        }
        Log.i((Object)("action fail =" + action));
        return false;
    }

    public byte[] loadResource(String path) {
        URL u = ClassLoader.getSystemResource(path);
        if (u == null) {
            u = this.getClass().getResource(path);
        }
        if (u == null) {
            return null;
        }
        String p2 = u.getPath();
        Log.d(p2);
        return TextTool.readAllBytes(p2);
    }

    public void outErr(HttpServletResponse resp, String msg) {
        try {
            resp.setCharacterEncoding("utf-8");
            resp.setContentType("text/html; charset=UTF-8");
            PrintWriter pw = resp.getWriter();
            pw.println(TextTool.txt2HTML(msg));
            pw.close();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        boolean succ;
        HttpServletRequest req2 = (HttpServletRequest)req;
        req2.setCharacterEncoding(Config.pageEncoding);
        String uri = req2.getRequestURI();
        String context = req2.getContextPath();
        for (URLFilter urlFilter : Config.urlFilters) {
            if (urlFilter != null) {
                uri = urlFilter.doFilter(uri, req2, resp);
            }
            if (uri == null) {
                chain.doFilter(req, resp);
                return;
            }
            if (!uri.equals("yangmvc-done")) continue;
            return;
        }
        if (context == null) {
            context = "";
        }
        Log.d("filter > ", uri, ",param = [", RequestHelper.params(req2), "]");
        if (uri.contains(".")) {
            chain.doFilter(req, resp);
            return;
        }
        boolean bl = succ = Config.reloadable ? false : CallCacheMap.runCallCache(uri, req2, (HttpServletResponse)resp);
        if (succ) {
            return;
        }
        try {
            this.process(uri, context, req2, (HttpServletResponse)resp, chain);
        }
        catch (Exception e) {
            String msg = Log.getErrMsg(e);
            Log.e(msg);
            Controller controller = new Controller();
            controller.request = req2;
            controller.response = (HttpServletResponse)resp;
            controller.response.reset();
            controller.response.setStatus(500);
            controller.response.setContentType("text/plain");
            loader.runPostProcessing(uri, controller, msg);
        }
    }

    private String loadConfig(String cfgName, String def) {
        String r = this.application.getInitParameter(cfgName);
        return r == null ? def : r;
    }

    public void init(FilterConfig cfg) throws ServletException {
        ins = this;
        boolean loaded = Config.loadProperties("/web.properties");
        this.application = cfg.getServletContext();
        if (!loaded) {
            try {
                String tpl = cfg.getInitParameter("template");
                if (tpl == null) {
                    Log.i((Object)"no configure in web.xml ");
                } else {
                    Config.template = tpl;
                }
                String ctr = cfg.getInitParameter("controller");
                if (ctr != null) {
                    Config.controller = ctr;
                }
                Config.template = Config.template == null ? "/view" : Config.template;
                String string = Config.controller = Config.controller == null ? "org.demo" : Config.controller;
                if (this.application.getInitParameter("dbusr") != null) {
                    Config.dbusr = this.loadConfig("dbusr", Config.dbusr);
                    Config.dbhost = this.loadConfig("dbhost", Config.dbhost);
                    Config.dbpwd = this.loadConfig("dbpwd", Config.dbpwd);
                    Config.dbname = this.loadConfig("dbname", Config.dbname);
                    Config.dbport = this.loadConfig("dbport", Config.dbport);
                    Config.dbtype = this.loadConfig("dbtype", Config.dbtype);
                    Config.dbschema = this.loadConfig("dbschema", Config.dbschema);
                    Config.reloadable = Boolean.parseBoolean(this.loadConfig("reloadable", Config.reloadable + ""));
                }
            }
            catch (Exception e1) {
                Log.e("can't load YangMVC config from  web.xml------------");
            }
        } else {
            Log.i((Object)"loaded from web.properties, skip load from web.xml");
        }
        if (Config.getProperty("groovy", null) == null) {
            loader = new Loader();
        } else {
            try {
                loader = (Loader)Class.forName("org.docshare.mvc.GroovyLoader").newInstance();
            }
            catch (Exception e) {
                Log.e(e);
                loader = new Loader();
            }
        }
        try {
            String initCls = Config.controller + ".Init";
            Log.d("try load init class " + initCls);
            Class.forName(initCls).newInstance();
        }
        catch (ClassNotFoundException e) {
            Log.d("init class not found");
        }
        catch (InstantiationException e) {
            Log.e("init class can not Instantiation : InstantiationException ");
        }
        catch (IllegalAccessException e) {
            Log.e("init class can not Instantiation : IllegalAccessException");
        }
        this.initFreeMarker();
        String hidePwd = Config.dbpwd;
        Config.dbpwd = "[hidden]";
        Log.i((Object)Config.str());
        Config.dbpwd = hidePwd;
    }

    private void initFreeMarker() {
        MultiTemplateLoader mtl;
        this.fmCfg = new Configuration(Configuration.VERSION_2_3_25);
        this.fmCfg.setDefaultEncoding("utf-8");
        this.fmCfg.setLocalizedLookup(false);
        this.fmCfg.setTemplateExceptionHandler((TemplateExceptionHandler)new FreeMarkerHandler());
        this.fmCfg.setClassicCompatible(true);
        ClassTemplateLoader ctl = new ClassTemplateLoader(MVCFilter.class, "/view");
        WebappTemplateLoader wtl = new WebappTemplateLoader(this.application, Config.template);
        try {
            FileTemplateLoader ftl1 = new FileTemplateLoader(new File(Config.template));
            mtl = new MultiTemplateLoader(new TemplateLoader[]{wtl, ftl1, ctl});
            Log.i((Object)("[template dir] " + this.application.getRealPath(Config.template)));
            Log.i((Object)("[template dir] " + new File(Config.template).getAbsolutePath()));
            Log.i((Object)("[template dir] classpath " + Config.template));
            Log.i((Object)"Find template dir ,use it !");
        }
        catch (IOException e) {
            mtl = new MultiTemplateLoader(new TemplateLoader[]{wtl, ctl});
            Log.i((Object)("[template dir] " + this.application.getRealPath(Config.template)));
            Log.i((Object)"[template dir] classpath /view");
        }
        this.fmCfg.setTemplateLoader((TemplateLoader)mtl);
    }

    public static Template getTemplate(String name) throws TemplateNotFoundException, MalformedTemplateNameException, ParseException, IOException {
        return MVCFilter.getIns().getFmCfg().getTemplate(name);
    }
}

