/*
 * Decompiled with CFR 0.152.
 */
package org.docshare.mvc;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.docshare.log.Log;
import org.docshare.mvc.Controller;
import org.docshare.util.TextTool;

class UploadProcesser {
    private HttpServletRequest request;
    private Controller c;
    private ServletContext app = null;
    private static HashSet<String> forbitMap = new HashSet();

    public UploadProcesser(Controller c, HttpServletRequest request, HttpServletResponse response, ServletContext app) {
        this.request = request;
        this.c = c;
        this.app = app;
    }

    public void process() throws FileUploadException {
        DiskFileItemFactory factory = new DiskFileItemFactory();
        ServletContext servletContext = this.app;
        File repository = (File)servletContext.getAttribute("javax.servlet.context.tempdir");
        factory.setRepository(repository);
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        List items = upload.parseRequest(this.request);
        for (FileItem item : items) {
            if (item.isFormField()) {
                this.processFormField(item);
                continue;
            }
            this.processUploadedFile(item);
        }
    }

    private String randomFileName(String oldFileName) {
        String after = TextTool.getLastAfter(oldFileName, ".");
        String[] forbit = new String[]{"jsp", "php", "aspx", "exe", "sh"};
        if (forbitMap.isEmpty()) {
            for (String s : forbit) {
                forbitMap.add(s);
            }
        }
        if (forbitMap.contains(after)) {
            after = after + ".txt";
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd/HHmmss");
        String path = "/upload/" + df.format(new Date()) + (int)(Math.random() * 1000.0) + "." + after;
        return path;
    }

    private void processUploadedFile(FileItem item) {
        String fieldName = item.getFieldName();
        String fileName = item.getName();
        String contentType = item.getContentType();
        boolean isInMemory = item.isInMemory();
        long sizeInBytes = item.getSize();
        String sep = System.getProperty("line.separator");
        String path = this.randomFileName(fileName);
        String real = this.app.getRealPath(path);
        File f = new File(real);
        if (!f.getParentFile().exists()) {
            Log.d("mkdir " + f.getParent());
            f.getParentFile().mkdirs();
        }
        File uploadedFile = new File(real);
        try {
            item.write(uploadedFile);
            Log.d("write param " + fieldName + " file to " + real);
        }
        catch (Exception e) {
            Log.e(e);
        }
        this.c.putParam(fieldName, path);
    }

    private void processFormField(FileItem item) {
        String name = item.getFieldName();
        String value = item.getString();
        this.c.putParam(name, this.transUtf8(value));
    }

    private String transUtf8(String p) {
        try {
            return new String(p.getBytes("ISO-8859-1"), "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return p;
        }
    }
}

