/*
 * Decompiled with CFR 0.152.
 */
package org.docshare.mvc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import org.docshare.log.Log;
import org.docshare.mvc.MethodAccessCacher;

class YangClassLoader
extends ClassLoader {
    private int version;
    private Object root;
    private String reloadPackage;

    public YangClassLoader(int v, String clsRoot, String reloadPackage) {
        this.version = v;
        if (!clsRoot.endsWith("/")) {
            clsRoot = clsRoot + "/";
        }
        this.root = clsRoot;
        this.reloadPackage = reloadPackage;
    }

    public String name2Path(String cname) {
        return this.root + cname.replace(".", "/") + ".class";
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        if (!name.startsWith(this.reloadPackage)) {
            return YangClassLoader.class.getClassLoader().loadClass(name);
        }
        try {
            Log.d("YangClassLoader v" + this.version + ", load " + name);
            Log.d("YangClassLoader " + this.getClass().getResource(this.name2Path(name)));
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            InputStream input = this.getClass().getResourceAsStream(this.name2Path(name));
            if (input == null) {
                return null;
            }
            byte[] buf = new byte[1024];
            int num = input.read(buf);
            while (num > 0) {
                buffer.write(buf, 0, num);
                num = input.read(buf);
            }
            input.close();
            byte[] classData = buffer.toByteArray();
            Class<?> ret = this.defineClass(name, classData, 0, classData.length);
            MethodAccessCacher.put(name, ret);
            return ret;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }
}

