/*
 * Decompiled with CFR 0.152.
 */
package org.docshare.orm;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import org.docshare.log.Log;

public class StatementPool {
    HashMap<String, PreparedStatement> cache = new HashMap();

    public PreparedStatement get(Connection con, String sql) throws SQLException {
        PreparedStatement p;
        if (this.cache.containsKey(sql)) {
            Log.v("StatementPool: return cached PreparedStatement");
            p = this.cache.get(sql);
        } else {
            p = con.prepareStatement(sql, 1);
            this.cache.put(sql, p);
        }
        return p;
    }

    public void clear() {
        for (PreparedStatement p : this.cache.values()) {
            try {
                p.close();
            }
            catch (SQLException sQLException) {}
        }
        this.cache.clear();
    }
}

