/*
 * Decompiled with CFR 0.152.
 */
package org.docshare.util;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.docshare.log.Log;
import org.docshare.mvc.IBean;
import org.docshare.util.TextTool;

public class BeanUtil {
    public static List<String> propList(Object obj) {
        ArrayList<String> ret = new ArrayList<String>();
        Field[] fa = obj.getClass().getFields();
        Method[] ma = obj.getClass().getMethods();
        for (Field field : fa) {
            ret.add(field.getName());
        }
        for (AccessibleObject accessibleObject : ma) {
            String name = ((Method)accessibleObject).getName();
            if (!name.startsWith("set") || name.length() <= 3) continue;
            ret.add(TextTool.firstLower(name.substring(3)));
        }
        return ret;
    }

    public static HashMap<String, Object> obj2Map(Object obj) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        Field[] fa = obj.getClass().getFields();
        Method[] ma = obj.getClass().getMethods();
        for (Field field : fa) {
            try {
                HashMap<String, Object> v = field.get(obj);
                if (v != null && v instanceof IBean) {
                    v = BeanUtil.obj2Map(v);
                }
                ret.put(field.getName(), v);
            }
            catch (Exception e) {
                Log.d(e);
            }
        }
        for (AccessibleObject accessibleObject : ma) {
            String name = ((Method)accessibleObject).getName();
            if (!name.startsWith("get") || name.equals("getClass") || name.length() <= 3) continue;
            try {
                Object v = ((Method)accessibleObject).invoke(obj, null);
                ret.put(TextTool.firstLower(name.substring(3)), v);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    private static Method getMethod(Object obj, String mname) {
        Method[] ma;
        for (Method m : ma = obj.getClass().getMethods()) {
            if (!mname.equals(m.getName())) continue;
            return m;
        }
        return null;
    }

    public static Object get(Object obj, String pname) {
        if (pname.contains(".")) {
            pname = TextTool.getBefore(pname, ".");
        }
        Class<?> clazz = obj.getClass();
        try {
            Field f = clazz.getField(pname);
            if (f != null) {
                return f.get(obj);
            }
        }
        catch (Exception f) {
            // empty catch block
        }
        String getname = "get" + TextTool.firstUpper(pname);
        Method getm = BeanUtil.getMethod(obj, getname);
        if (getm == null) {
            return null;
        }
        try {
            Object fieldVal = getm.invoke(obj, new Object[0]);
            return fieldVal;
        }
        catch (Exception e) {
            Log.d(e);
            return null;
        }
    }

    public static boolean set(Object obj, String pname, Object val) {
        String sub;
        block15: {
            sub = null;
            if (pname.contains(".")) {
                sub = TextTool.getAfter(pname, ".");
                pname = TextTool.getBefore(pname, ".");
            }
            Class<?> clazz = obj.getClass();
            try {
                Field f = clazz.getField(pname);
                if (sub == null) {
                    f.set(obj, BeanUtil.transType(val, f.getType().getSimpleName()));
                } else {
                    Object fieldVal = f.get(obj);
                    BeanUtil.set(fieldVal, sub, val);
                }
                return true;
            }
            catch (SecurityException e) {
                Log.e("SecurityException");
                e.printStackTrace();
            }
            catch (NoSuchFieldException e) {
            }
            catch (IllegalArgumentException e) {
                String t = val == null ? null : val.toString();
                Log.e("arg type not match class=%s , fiend = %s , valtype = %s  val=  %s", obj.getClass().getName(), pname, val.getClass().getName(), t);
            }
            catch (IllegalAccessException e) {
                String getname = "get" + TextTool.firstUpper(pname);
                Method getm = BeanUtil.getMethod(obj, getname);
                if (getm != null) break block15;
                Log.e("IllegalAccessException of class %s ,field  %s    make sure the class and field are all public", obj.getClass().getName(), pname);
            }
        }
        try {
            if (sub != null) {
                String getname = "get" + TextTool.firstUpper(pname);
                Method getm = BeanUtil.getMethod(obj, getname);
                Object fieldVal = getm.invoke(obj, new Object[0]);
                if (fieldVal == null) {
                    return false;
                }
                BeanUtil.set(fieldVal, sub, val);
            } else {
                String setname = "set" + TextTool.firstUpper(pname);
                Method setm = BeanUtil.getMethod(obj, setname);
                if (setm == null) {
                    return false;
                }
                Class<?>[] params = setm.getParameterTypes();
                if (params == null || params.length != 1) {
                    return false;
                }
                String ptype = params[0].getSimpleName();
                setm.invoke(obj, BeanUtil.transType(val, ptype));
            }
            return true;
        }
        catch (Exception e) {
            Log.d(e);
            return false;
        }
    }

    private static Object transType(Object obj, String toType) {
        if (obj == null) {
            return null;
        }
        String sval = obj.toString();
        if (toType.equals("String")) {
            return sval;
        }
        if (toType.equals("int") || toType.equals("Integer")) {
            return Integer.parseInt(sval);
        }
        if ((toType = toType.toLowerCase()).equals("long")) {
            return Long.parseLong(sval);
        }
        if (toType.equals("float")) {
            return Float.valueOf(Float.parseFloat(sval));
        }
        if (toType.equals("double")) {
            return Double.parseDouble(sval);
        }
        if (toType.equals("boolean") || toType.equals("java.lang.Boolean")) {
            return Boolean.parseBoolean(sval);
        }
        return obj;
    }

    public static void prop2StaticField(Properties prop, Class<?> clz) {
        Field[] fa;
        for (Field f : fa = clz.getFields()) {
            String name = f.getName();
            String val = prop.getProperty(name);
            try {
                Object ov = BeanUtil.transType(val, f.getType().getName());
                if (ov == null) continue;
                f.set(null, ov);
                Log.d("set " + clz.getName() + " field " + name + " to " + val);
            }
            catch (Exception e) {
                Log.d(e);
            }
        }
    }
}

