/*
 * Decompiled with CFR 0.152.
 */
package org.docshare.util;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Scanner;
import org.docshare.log.Log;

public class FileTool {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(String source, String dest) {
        block6: {
            FileInputStream in = null;
            FileOutputStream out = null;
            try {
                int len;
                in = new FileInputStream(new File(source));
                out = new FileOutputStream(new File(dest));
                byte[] buffer = new byte[4096];
                while ((len = ((InputStream)in).read(buffer)) > 0) {
                    ((OutputStream)out).write(buffer, 0, len);
                }
                FileTool.safelyClose(in);
            }
            catch (Exception e) {
                Log.e(e);
                break block6;
            }
            finally {
                FileTool.safelyClose(in);
                FileTool.safelyClose(out);
            }
            FileTool.safelyClose(out);
        }
    }

    public static void safelyClose(Closeable out) {
        try {
            if (out == null) {
                return;
            }
            out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - bad return control flow
     */
    public static byte[] readBytes(String filename) {
        byte[] byArray;
        byte[] ret = new byte[10249216];
        int p = 0;
        FileInputStream fin = null;
        try {
            int i;
            int n;
            fin = new FileInputStream(filename);
            byte[] b = new byte[1024000];
            while ((n = fin.read(b)) > 0) {
                for (i = 0; i < n; ++i) {
                    ret[p++] = b[i];
                }
            }
            byte[] newr = new byte[p];
            for (i = 0; i < p; ++i) {
                newr[i] = ret[i];
            }
            byArray = newr;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            FileTool.safelyClose(fin);
        }
        catch (IOException e2) {
            e2.printStackTrace();
            {
                catch (Throwable throwable) {
                    FileTool.safelyClose(fin);
                    throw throwable;
                }
            }
            FileTool.safelyClose(fin);
        }
        FileTool.safelyClose(fin);
        return byArray;
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readAllCRLF(String f) {
        BufferedReader br = null;
        StringBuilder sb = new StringBuilder();
        try {
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), "GB2312"));
            while (br.ready()) {
                sb.append(br.readLine() + "\r\n");
            }
            FileTool.safelyClose(br);
        }
        catch (Exception e) {
            String string = null;
            return string;
        }
        finally {
            FileTool.safelyClose(br);
        }
        return sb.toString();
    }

    public static String readAll(String f, String charset) {
        if (!FileTool.exists(f)) {
            return null;
        }
        try {
            return FileTool.readAll(new FileInputStream(f), charset);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readAll(InputStream in, String charset) {
        if (in == null) {
            return null;
        }
        BufferedReader br = null;
        StringBuilder sb = new StringBuilder();
        try {
            InputStreamReader reader = new InputStreamReader(in, charset);
            br = new BufferedReader(reader);
            while (br.ready()) {
                sb.append(br.readLine() + "\n");
            }
            reader.close();
            FileTool.safelyClose(br);
        }
        catch (Exception e) {
            e.printStackTrace();
            String string = null;
            return string;
        }
        finally {
            FileTool.safelyClose(br);
        }
        return sb.toString();
    }

    @Deprecated
    public static void writeUTFOLD(String f, String data) {
        try (DataOutputStream ds = new DataOutputStream(new FileOutputStream(f));){
            data = new String(data.getBytes(), "UTF-8");
            ds.writeUTF(data);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeUTF(String f, String data) {
        OutputStreamWriter out = null;
        try {
            out = new OutputStreamWriter((OutputStream)new FileOutputStream(f), "UTF-8");
            out.write(data);
            out.flush();
            FileTool.safelyClose(out);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            FileTool.safelyClose(out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeAll(String f, String data, String charset) {
        OutputStreamWriter out = null;
        try {
            out = new OutputStreamWriter((OutputStream)new FileOutputStream(f), charset);
            out.write(data);
            out.flush();
            FileTool.safelyClose(out);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            FileTool.safelyClose(out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static void writeAll(String f, String data) {
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(f);
            pw.print(data);
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                FileTool.safelyClose(pw);
                throw throwable;
            }
            FileTool.safelyClose(pw);
        }
        FileTool.safelyClose(pw);
    }

    public static String getParentDir(String d) {
        int i = (d = d.replace('\\', '/')).lastIndexOf(92);
        if (i <= 0) {
            return null;
        }
        d = d.substring(0, i);
        return d;
    }

    public static void makeDir(String d) {
        File f = new File(d);
        if (f.exists()) {
            return;
        }
        f.mkdirs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void appendFile(String f, String d) {
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(new FileWriter(f, true));
            pw.print(d);
            FileTool.safelyClose(pw);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            FileTool.safelyClose(pw);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void appendFile(String f, String d, String charset) {
        RandomAccessFile randomFile = null;
        try {
            randomFile = new RandomAccessFile(f, "rw");
            long fileLength = randomFile.length();
            randomFile.seek(fileLength);
            randomFile.write(d.getBytes(charset));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (randomFile != null) {
                try {
                    randomFile.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static boolean delFile(String f) {
        try {
            File file = new File(f);
            file.delete();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean exists(String filename) {
        if (filename == null) {
            return false;
        }
        File f = new File(filename);
        return f.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<Double> loadBinMatrix(String file) {
        DataInputStream di = null;
        try {
            ArrayList<Double> al = new ArrayList<Double>();
            di = new DataInputStream(new FileInputStream(file));
            while (di.available() >= 8) {
                double d = di.readDouble();
                al.add(d);
            }
            di.close();
            ArrayList<Double> arrayList = al;
            FileTool.safelyClose(di);
            return arrayList;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            FileTool.safelyClose(di);
        }
        return null;
    }

    public static ArrayList<Double> loadTextMatrix(String filename) {
        ArrayList<Double> al = new ArrayList<Double>();
        FileReader fr = null;
        try {
            fr = new FileReader(filename);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        Scanner sc = new Scanner(fr);
        while (sc.hasNextDouble()) {
            double num = sc.nextDouble();
            al.add(num);
            if (al.size() % 10000 != 0) continue;
            System.out.println("load m " + al.size());
        }
        FileTool.safelyClose(sc);
        System.out.println("al= " + al.size() + "\n");
        return al;
    }

    public static void saveBinMatrix(String file, ArrayList<?> al) {
        try {
            DataOutputStream dp = new DataOutputStream(new FileOutputStream(file));
            for (int i = 0; i < al.size(); ++i) {
                double d = (Double)al.get(i);
                dp.writeDouble(d);
            }
            dp.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    public static long lastModify(String fn) {
        File f = new File(fn);
        return f.lastModified();
    }

    public static void printHashMap(HashMap<?, ?> hm) {
        for (String key : hm.keySet()) {
            Integer value = (Integer)hm.get(key);
            System.out.println(key + "=" + value);
        }
    }

    public static void touch(String f) {
        FileTool.writeAll(f, "");
    }

    public static void delPath(String filepath) {
        File[] sfl;
        if (!FileTool.exists(filepath)) {
            return;
        }
        File f = new File(filepath);
        for (File sf : sfl = f.listFiles()) {
            if (sf.isFile()) {
                sf.delete();
                continue;
            }
            if (!sf.isDirectory()) continue;
            FileTool.delPath(sf.getPath());
        }
        f.delete();
    }

    public static String[] readLines(String filename, String charset) {
        return FileTool.readAll(filename, charset).split("\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readResource(String fname, String charset) {
        try (Scanner sc = null;){
            InputStream sm = FileTool.class.getClassLoader().getResourceAsStream(fname);
            sc = new Scanner(sm);
            StringBuilder sb = new StringBuilder();
            while (sc.hasNextLine()) {
                String line = sc.nextLine();
                sb.append(line);
                sb.append("\n");
            }
            String string = sb.toString();
            return string;
        }
    }

    public static void writeAll(OutputStream os, String data, String charset) {
        try {
            OutputStreamWriter out = new OutputStreamWriter(os, charset);
            out.write(data);
            out.flush();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void writeAll(InputStream in, OutputStream os) {
        byte[] buf = new byte[10240];
        try {
            int readed = in.read(buf);
            while (readed > 0) {
                os.write(buf, 0, readed);
                readed = in.read(buf);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void safelyClose(AutoCloseable obj) {
        if (obj == null) {
            return;
        }
        try {
            obj.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

