/*
 * Decompiled with CFR 0.152.
 */
package org.docshare.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.docshare.log.Log;
import org.docshare.util.IOUtil;

public class HttpHelper {
    static HttpClient client = new HttpClient();

    public static String get(String url) {
        return HttpHelper.get(url, "utf-8");
    }

    public static String get(String url, String charset) {
        GetMethod method = new GetMethod(url);
        client.getHttpConnectionManager().getParams().setConnectionTimeout(10000);
        String response = null;
        try {
            int status = client.executeMethod((HttpMethod)method);
            if (status == 200) {
                InputStream inputStream = method.getResponseBodyAsStream();
                response = IOUtil.readStream(inputStream, charset);
            } else {
                response = null;
            }
        }
        catch (HttpException e) {
            Log.e(e);
        }
        catch (IOException e) {
            Log.e(e);
        }
        return response;
    }

    public static String post(String postUrl, Map<String, Object> params) {
        return HttpHelper.post(postUrl, params, "utf-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String post(String postUrl, Map<String, Object> params, String charset) {
        String response = "";
        PostMethod postMethod = new PostMethod(postUrl);
        if (params != null) {
            for (String key : params.keySet()) {
                postMethod.addParameter(key, params.get(key).toString());
            }
        }
        try {
            client.getParams().setParameter("http.protocol.content-charset", (Object)charset);
            client.getHttpConnectionManager().getParams().setConnectionTimeout(10000);
            int status = client.executeMethod((HttpMethod)postMethod);
            InputStream inputStream = postMethod.getResponseBodyAsStream();
            response = IOUtil.readStream(inputStream, charset);
            if (("" + status).startsWith("5")) {
                response = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            postMethod.releaseConnection();
        }
        return response;
    }
}

