/*
 * Decompiled with CFR 0.152.
 */
package org.docstr.gradle.plugins.gwt;

import java.io.File;
import org.docstr.gradle.plugins.gwt.GwtPluginExtension;
import org.docstr.gradle.plugins.gwt.GwtTestOptions;
import org.docstr.gradle.plugins.gwt.GwtTestOptionsBase;
import org.gradle.api.internal.IConventionAware;

public class GwtTestExtension
extends GwtTestOptionsBase {
    private File war;
    private File deploy;
    private File extra;
    private File workDir;
    private File gen;
    private File cacheDir;

    protected String getParameterString() {
        StringBuilder builder = new StringBuilder();
        this.dirArgIfSet(builder, "-war", this.getWar());
        this.dirArgIfSet(builder, "-deploy", this.getDeploy());
        this.dirArgIfSet(builder, "-extra", this.getExtra());
        this.dirArgIfSet(builder, "-workDir", this.getWorkDir());
        this.dirArgIfSet(builder, "-gen", this.getGen());
        this.argIfSet(builder, "-logLevel", (Object)this.getLogLevel());
        this.argIfSet(builder, "-port", Boolean.TRUE.equals(this.getAutoPort()) ? "auto" : this.getPort());
        this.argIfSet(builder, "-whitelist", this.getWhitelist());
        this.argIfSet(builder, "-blacklist", this.getBlacklist());
        this.argIfSet(builder, "-logdir", this.getLogDir());
        this.argIfSet(builder, "-codeServerPort", Boolean.TRUE.equals(this.getAutoCodeServerPort()) ? "auto" : this.getCodeServerPort());
        this.argIfSet(builder, "-style", (Object)this.getStyle());
        this.argIfEnabled(builder, this.getEa(), "-ea");
        this.argIfEnabled(builder, this.getDisableClassMetadata(), "-XdisableClassMetadata");
        this.argIfEnabled(builder, this.getDisableCastChecking(), "-XdisableCastChecking");
        this.argIfEnabled(builder, this.getDraftCompile(), "-draftCompile");
        this.argIfSet(builder, "-localWorkers", this.getLocalWorkers());
        this.argIfEnabled(builder, this.getProd(), "-prod");
        this.argIfSet(builder, "-testMethodTimeout", this.getTestMethodTimeout());
        this.argIfSet(builder, "-testBeginTimeout", this.getTestBeginTimeout());
        this.argIfSet(builder, "-runStyle", this.getRunStyle());
        this.argIfEnabled(builder, this.getNotHeadless(), "-notHeadless");
        this.argIfEnabled(builder, this.getStandardsMode(), "-standardsMode");
        this.argIfEnabled(builder, this.getQuirksMode(), "-quirksMode");
        this.argIfSet(builder, "-Xtries", this.getTries());
        this.argIfSet(builder, "-userAgents", this.getUserAgents());
        return builder.toString();
    }

    private void argIfEnabled(StringBuilder builder, Boolean condition, String arg) {
        if (Boolean.TRUE.equals(condition)) {
            this.arg(builder, arg);
        }
    }

    private void dirArgIfSet(StringBuilder builder, String arg, File dir) {
        if (dir != null) {
            dir.mkdirs();
            this.arg(builder, arg, dir);
        }
    }

    private void argIfSet(StringBuilder builder, String arg, Object value) {
        if (value != null) {
            this.arg(builder, arg, value);
        }
    }

    private void arg(StringBuilder builder, Object ... args) {
        for (Object arg : args) {
            if (builder.length() > 0) {
                builder.append(' ');
            }
            builder.append(arg.toString());
        }
    }

    protected void configure(GwtPluginExtension extension, IConventionAware conventionAware) {
        GwtTestOptions testOptions = extension.getTest();
        conventionAware.getConventionMapping().map("war", () -> extension.getDevWar());
        conventionAware.getConventionMapping().map("extra", () -> extension.getExtraDir());
        conventionAware.getConventionMapping().map("workDir", () -> extension.getWorkDir());
        conventionAware.getConventionMapping().map("gen", () -> extension.getGenDir());
        conventionAware.getConventionMapping().map("cacheDir", () -> extension.getCacheDir());
        conventionAware.getConventionMapping().map("logLevel", () -> extension.getLogLevel());
        conventionAware.getConventionMapping().map("port", () -> testOptions.getPort());
        conventionAware.getConventionMapping().map("autoPort", () -> testOptions.getAutoPort());
        conventionAware.getConventionMapping().map("whitelist", () -> testOptions.getWhitelist());
        conventionAware.getConventionMapping().map("blacklist", () -> testOptions.getBlacklist());
        conventionAware.getConventionMapping().map("logDir", () -> testOptions.getLogDir());
        conventionAware.getConventionMapping().map("codeServerPort", () -> testOptions.getCodeServerPort());
        conventionAware.getConventionMapping().map("autoCodeServerPort", () -> testOptions.getAutoCodeServerPort());
        conventionAware.getConventionMapping().map("style", () -> testOptions.getStyle());
        conventionAware.getConventionMapping().map("ea", () -> testOptions.getEa());
        conventionAware.getConventionMapping().map("disableClassMetadata", () -> testOptions.getDisableClassMetadata());
        conventionAware.getConventionMapping().map("disableCastChecking", () -> testOptions.getDisableCastChecking());
        conventionAware.getConventionMapping().map("draftCompile", () -> testOptions.getDraftCompile());
        conventionAware.getConventionMapping().map("localWorkers", () -> testOptions.getLocalWorkers());
        conventionAware.getConventionMapping().map("prod", () -> testOptions.getProd());
        conventionAware.getConventionMapping().map("testMethodTimeout", () -> testOptions.getTestMethodTimeout());
        conventionAware.getConventionMapping().map("testBeginTimeout", () -> testOptions.getTestBeginTimeout());
        conventionAware.getConventionMapping().map("runStyle", () -> testOptions.getRunStyle());
        conventionAware.getConventionMapping().map("notHeadless", () -> testOptions.getNotHeadless());
        conventionAware.getConventionMapping().map("standardsMode", () -> testOptions.getStandardsMode());
        conventionAware.getConventionMapping().map("quirksMode", () -> testOptions.getQuirksMode());
        conventionAware.getConventionMapping().map("tries", () -> testOptions.getTries());
        conventionAware.getConventionMapping().map("userAgents", () -> testOptions.getUserAgents());
    }

    public File getWar() {
        return this.war;
    }

    public void setWar(File war) {
        this.war = war;
    }

    public File getDeploy() {
        return this.deploy;
    }

    public void setDeploy(File deploy) {
        this.deploy = deploy;
    }

    public File getExtra() {
        return this.extra;
    }

    public void setExtra(File extra) {
        this.extra = extra;
    }

    public File getWorkDir() {
        return this.workDir;
    }

    public void setWorkDir(File workDir) {
        this.workDir = workDir;
    }

    public File getGen() {
        return this.gen;
    }

    public void setGen(File gen) {
        this.gen = gen;
    }

    public File getCacheDir() {
        return this.cacheDir;
    }

    public void setCacheDir(File cacheDir) {
        this.cacheDir = cacheDir;
    }
}

