/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.out.microsoft_graph;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.docx4j.Docx4J;
import org.docx4j.convert.out.MicrosoftGraphConversionSettings;
import org.docx4j.convert.out.common.Exporter;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.packages.PresentationMLPackage;
import org.plutext.msgraph.convert.ConversionException;
import org.plutext.msgraph.convert.PptxToPdfConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PptxToPdfExporter
implements Exporter<MicrosoftGraphConversionSettings> {
    private static Logger log = LoggerFactory.getLogger(PptxToPdfExporter.class);
    private static PptxToPdfExporter instance = null;
    private PptxToPdfConverter converter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Exporter<MicrosoftGraphConversionSettings> getInstance(PptxToPdfConverter converter) {
        if (instance != null) return instance;
        Class<PptxToPdfExporter> clazz = PptxToPdfExporter.class;
        synchronized (PptxToPdfExporter.class) {
            if (instance != null) return instance;
            instance = new PptxToPdfExporter(converter);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public PptxToPdfExporter(PptxToPdfConverter converter) {
        this.converter = converter;
    }

    public void export(MicrosoftGraphConversionSettings conversionSettings, OutputStream outputStream) throws Docx4JException {
        OpcPackage pkg = conversionSettings.getOpcPackage();
        this.export(pkg, outputStream);
    }

    public void export(OpcPackage pkg, OutputStream outputStream) throws Docx4JException {
        if (pkg instanceof PresentationMLPackage) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Docx4J.save((OpcPackage)pkg, (OutputStream)baos);
            try {
                byte[] pdfBytes = this.converter.convert(baos.toByteArray());
                IOUtils.write((byte[])pdfBytes, (OutputStream)outputStream);
            }
            catch (ConversionException e) {
                throw new Docx4JException(e.getMessage(), (Exception)((Object)e));
            }
            catch (IOException e) {
                throw new Docx4JException(e.getMessage(), (Exception)e);
            }
        } else {
            throw new Docx4JException("PptxToPdfExporter can't export " + pkg.getClass().getName());
        }
    }

    public void export(File officeFile, OutputStream target) throws Docx4JException {
        try {
            byte[] pdfBytes = this.converter.convert(officeFile);
            IOUtils.write((byte[])pdfBytes, (OutputStream)target);
        }
        catch (Exception e1) {
            throw new Docx4JException(e1.getMessage(), e1);
        }
    }
}

