/*
 * Decompiled with CFR 0.152.
 */
package com.topologi.diffx.xml;

import com.topologi.diffx.xml.IllegalCloseElementException;
import com.topologi.diffx.xml.UnclosedElementException;
import com.topologi.diffx.xml.XMLWriter;
import com.topologi.diffx.xml.XMLWriterBase;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public final class XMLWriterImpl
extends XMLWriterBase
implements XMLWriter {
    private static final Element ROOT = new Element("", true);
    private final List<Element> elements = new ArrayList<Element>();

    public XMLWriterImpl(Writer writer) throws NullPointerException {
        super(writer, false);
        this.elements.add(ROOT);
    }

    public XMLWriterImpl(Writer writer, boolean indent) throws NullPointerException {
        super(writer, indent);
        this.elements.add(ROOT);
    }

    @Override
    void deNude() throws IOException {
        if (this.isNude) {
            this.writer.write(62);
            if (this.peekElement().hasChildren && this.indent) {
                this.writer.write(10);
            }
            this.isNude = false;
        }
    }

    @Override
    public void openElement(String name) throws IOException {
        this.openElement(name, false);
    }

    @Override
    public void openElement(String name, boolean hasChildren) throws IOException {
        this.deNude();
        this.indent();
        this.elements.add(new Element(name, hasChildren));
        this.writer.write(60);
        this.writer.write(name);
        this.isNude = true;
        ++this.depth;
    }

    @Override
    public void closeElement() throws IOException, IllegalCloseElementException {
        Element elt = this.popElement();
        if (elt == ROOT) {
            throw new IllegalCloseElementException();
        }
        --this.depth;
        if (this.isNude) {
            this.writer.write(47);
            this.isNude = false;
        } else {
            if (elt.hasChildren) {
                this.indent();
            }
            this.writer.write(60);
            this.writer.write(47);
            int x = elt.name.indexOf(32);
            if (x < 0) {
                this.writer.write(elt.name);
            } else {
                this.writer.write(elt.name.substring(0, x));
            }
        }
        this.writer.write(62);
        if (this.indent) {
            Element parent = this.peekElement();
            if (parent.hasChildren && parent != ROOT) {
                this.writer.write(10);
            }
        }
    }

    @Override
    public void emptyElement(String element) throws IOException {
        this.deNude();
        this.indent();
        this.writer.write(60);
        this.writer.write(element);
        this.writer.write(47);
        this.writer.write(62);
        if (this.indent) {
            Element parent = this.peekElement();
            if (parent.hasChildren && parent != ROOT) {
                this.writer.write(10);
            }
        }
    }

    private Element peekElement() {
        return this.elements.get(this.elements.size() - 1);
    }

    private Element popElement() {
        return this.elements.remove(this.elements.size() - 1);
    }

    public void openElement(String uri, String name) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("This class does not handle namespaces.");
    }

    @Override
    public void openElement(String uri, String name, boolean hasChildren) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("This class does not handle namespaces.");
    }

    @Override
    public void emptyElement(String uri, String element) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("This class does not handle namespaces");
    }

    @Override
    public void setPrefixMapping(String uri, String prefix) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("This class does not handle namespaces");
    }

    @Override
    public void attribute(String uri, String name, String value) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("This class does not handle namespaces");
    }

    @Override
    public void attribute(String uri, String name, int value) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("This class does not handle namespaces");
    }

    @Override
    public void close() throws IOException, UnclosedElementException {
        Element open = this.peekElement();
        if (open != ROOT) {
            throw new UnclosedElementException(open.name);
        }
        this.writer.close();
    }

    private static final class Element {
        private final String name;
        private final boolean hasChildren;

        public Element(String name, boolean hasChildren) {
            this.name = name;
            this.hasChildren = hasChildren;
        }
    }
}

