/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.out.fo;

import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import javax.xml.bind.JAXBContext;
import org.docx4j.UnitsOfMeasurement;
import org.docx4j.XmlUtils;
import org.docx4j.convert.out.FOSettings;
import org.docx4j.convert.out.common.AbstractWmlConversionContext;
import org.docx4j.convert.out.common.ConversionSectionWrapper;
import org.docx4j.convert.out.common.preprocess.PartialDeepCopy;
import org.docx4j.convert.out.fo.FOPAreaTreeHelper;
import org.docx4j.events.EventFinished;
import org.docx4j.events.PackageIdentifier;
import org.docx4j.events.ProcessStep;
import org.docx4j.events.StartEvent;
import org.docx4j.events.WellKnownProcessSteps;
import org.docx4j.jaxb.Context;
import org.docx4j.model.structure.HeaderFooterPolicy;
import org.docx4j.model.structure.PageDimensions;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.WordprocessingML.FontTablePart;
import org.plutext.jaxb.xslfo.ConditionalPageMasterReference;
import org.plutext.jaxb.xslfo.LayoutMasterSet;
import org.plutext.jaxb.xslfo.ObjectFactory;
import org.plutext.jaxb.xslfo.OddOrEvenType;
import org.plutext.jaxb.xslfo.PagePositionType;
import org.plutext.jaxb.xslfo.PageSequenceMaster;
import org.plutext.jaxb.xslfo.RegionAfter;
import org.plutext.jaxb.xslfo.RegionBefore;
import org.plutext.jaxb.xslfo.RegionBody;
import org.plutext.jaxb.xslfo.RepeatablePageMasterAlternatives;
import org.plutext.jaxb.xslfo.SimplePageMaster;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;

public class LayoutMasterSetBuilder {
    protected static Logger log = LoggerFactory.getLogger(LayoutMasterSetBuilder.class);
    private static ObjectFactory factory;

    public static DocumentFragment getLayoutMasterSetFragment(AbstractWmlConversionContext context) {
        LayoutMasterSet lms = LayoutMasterSetBuilder.getFoLayoutMasterSet(context);
        FOSettings foSettings = (FOSettings)context.getConversionSettings();
        if (!foSettings.lsLayoutMasterSetCalculationInProgress()) {
            LayoutMasterSetBuilder.fixExtents(lms, context, true);
        }
        Document document = XmlUtils.marshaltoW3CDomDocument((Object)lms, (JAXBContext)Context.getXslFoContext());
        DocumentFragment docfrag = document.createDocumentFragment();
        docfrag.appendChild(document.getDocumentElement());
        return docfrag;
    }

    private static void fixExtents(LayoutMasterSet lms, AbstractWmlConversionContext context, boolean useXSLT) {
        WordprocessingMLPackage wordMLPackage = context.getWmlPackage();
        StartEvent startEvent = new StartEvent((PackageIdentifier)wordMLPackage, (ProcessStep)WellKnownProcessSteps.FO_EXTENTS);
        startEvent.publish();
        if (log.isDebugEnabled()) {
            log.debug("incoming LMS: " + XmlUtils.marshaltoString((Object)lms, (JAXBContext)Context.getXslFoContext()));
        }
        TreeSet<String> relationshipTypes = new TreeSet<String>();
        relationshipTypes.add("http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument");
        relationshipTypes.add("http://schemas.openxmlformats.org/officeDocument/2006/relationships/header");
        relationshipTypes.add("http://schemas.openxmlformats.org/officeDocument/2006/relationships/footer");
        relationshipTypes.add("http://schemas.openxmlformats.org/officeDocument/2006/relationships/endnotes");
        relationshipTypes.add("http://schemas.openxmlformats.org/officeDocument/2006/relationships/footnotes");
        relationshipTypes.add("http://schemas.openxmlformats.org/officeDocument/2006/relationships/comments");
        try {
            WordprocessingMLPackage hfPkg = (WordprocessingMLPackage)PartialDeepCopy.process((OpcPackage)wordMLPackage, relationshipTypes);
            FOPAreaTreeHelper.trimContent(hfPkg);
            Document areaTree = FOPAreaTreeHelper.getAreaTreeViaFOP(hfPkg, useXSLT);
            log.debug(XmlUtils.w3CDomNodeToString((Node)areaTree));
            HashMap<String, Integer> headerBpda = new HashMap<String, Integer>();
            HashMap<String, Integer> footerBpda = new HashMap<String, Integer>();
            FOPAreaTreeHelper.calculateHFExtents(areaTree, headerBpda, footerBpda);
            FOPAreaTreeHelper.adjustLayoutMasterSet(lms, context.getSections(), headerBpda, footerBpda);
            FontTablePart ftp = hfPkg.getMainDocumentPart().getFontTablePart();
            if (ftp != null) {
                ftp.deleteEmbeddedFontTempFiles();
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("resulting LMS: " + XmlUtils.marshaltoString((Object)lms, (JAXBContext)Context.getXslFoContext()));
        }
        new EventFinished(startEvent).publish();
    }

    public static void appendLayoutMasterSetFragment(AbstractWmlConversionContext context, Node foRoot) {
        LayoutMasterSet lms = LayoutMasterSetBuilder.getFoLayoutMasterSet(context);
        FOSettings foSettings = (FOSettings)context.getConversionSettings();
        if (!foSettings.lsLayoutMasterSetCalculationInProgress()) {
            LayoutMasterSetBuilder.fixExtents(lms, context, false);
        }
        Document document = XmlUtils.marshaltoW3CDomDocument((Object)lms, (JAXBContext)Context.getXslFoContext());
        XmlUtils.treeCopy((Node)document.getDocumentElement(), (Node)foRoot);
    }

    private static LayoutMasterSet getFoLayoutMasterSet(AbstractWmlConversionContext context) {
        LayoutMasterSet lms = LayoutMasterSetBuilder.getFactory().createLayoutMasterSet();
        List sections = context.getSections().getList();
        ConversionSectionWrapper section = null;
        for (int i = 0; i < sections.size(); ++i) {
            section = (ConversionSectionWrapper)sections.get(i);
            HeaderFooterPolicy hf = section.getHeaderFooterPolicy();
            String sectionName = "s" + Integer.toString(i + 1);
            if (hf.getFirstHeader() != null || hf.getFirstFooter() != null) {
                lms.getSimplePageMasterOrPageSequenceMaster().add(LayoutMasterSetBuilder.createSimplePageMaster(sectionName + "-firstpage", section.getPageDimensions(), "firstpage", hf.getFirstHeader() != null, hf.getFirstFooter() != null));
            }
            if (hf.getEvenHeader() != null || hf.getEvenFooter() != null) {
                lms.getSimplePageMasterOrPageSequenceMaster().add(LayoutMasterSetBuilder.createSimplePageMaster(sectionName + "-evenpage", section.getPageDimensions(), "evenpage", hf.getEvenHeader() != null, hf.getEvenFooter() != null));
            }
            if (hf.getDefaultHeader() != null || hf.getDefaultFooter() != null) {
                lms.getSimplePageMasterOrPageSequenceMaster().add(LayoutMasterSetBuilder.createSimplePageMaster(sectionName + "-default", section.getPageDimensions(), "default", hf.getDefaultHeader() != null, hf.getDefaultFooter() != null));
            }
            if (hf.getDefaultHeader() == null && hf.getDefaultFooter() == null) {
                lms.getSimplePageMasterOrPageSequenceMaster().add(LayoutMasterSetBuilder.createSimplePageMaster(sectionName + "-simple", section.getPageDimensions(), "simple", true, true));
            }
            lms.getSimplePageMasterOrPageSequenceMaster().add(LayoutMasterSetBuilder.createPageSequenceMaster(hf, sectionName));
        }
        return lms;
    }

    private static PageSequenceMaster createPageSequenceMaster(HeaderFooterPolicy hf, String sectionName) {
        boolean noHeadersFootersAfterFirstPage = true;
        PageSequenceMaster psm = LayoutMasterSetBuilder.getFactory().createPageSequenceMaster();
        psm.setMasterName(sectionName);
        RepeatablePageMasterAlternatives rpma = LayoutMasterSetBuilder.getFactory().createRepeatablePageMasterAlternatives();
        psm.getSinglePageMasterReferenceOrRepeatablePageMasterReferenceOrRepeatablePageMasterAlternatives().add(rpma);
        if (hf.getFirstHeader() != null || hf.getFirstFooter() != null) {
            ConditionalPageMasterReference cpmr1 = LayoutMasterSetBuilder.getFactory().createConditionalPageMasterReference();
            cpmr1.setMasterReference(sectionName + "-firstpage");
            cpmr1.setPagePosition(PagePositionType.FIRST);
            rpma.getConditionalPageMasterReference().add(cpmr1);
        }
        if (hf.getEvenHeader() != null || hf.getEvenFooter() != null) {
            ConditionalPageMasterReference cpmr2 = LayoutMasterSetBuilder.getFactory().createConditionalPageMasterReference();
            cpmr2.setMasterReference(sectionName + "-evenpage");
            cpmr2.setOddOrEven(OddOrEvenType.EVEN);
            rpma.getConditionalPageMasterReference().add(cpmr2);
            ConditionalPageMasterReference cpmr3 = LayoutMasterSetBuilder.getFactory().createConditionalPageMasterReference();
            cpmr3.setMasterReference(sectionName + "-default");
            cpmr3.setOddOrEven(OddOrEvenType.ODD);
            rpma.getConditionalPageMasterReference().add(cpmr3);
            noHeadersFootersAfterFirstPage = false;
        } else if (hf.getDefaultHeader() != null || hf.getDefaultFooter() != null) {
            ConditionalPageMasterReference cpmr4 = LayoutMasterSetBuilder.getFactory().createConditionalPageMasterReference();
            cpmr4.setMasterReference(sectionName + "-default");
            rpma.getConditionalPageMasterReference().add(cpmr4);
            noHeadersFootersAfterFirstPage = false;
        }
        if (noHeadersFootersAfterFirstPage) {
            ConditionalPageMasterReference cpmr5 = LayoutMasterSetBuilder.getFactory().createConditionalPageMasterReference();
            cpmr5.setMasterReference(sectionName + "-simple");
            rpma.getConditionalPageMasterReference().add(cpmr5);
        }
        return psm;
    }

    private static SimplePageMaster createSimplePageMaster(String masterName, PageDimensions page, String appendRegionName, boolean needBefore, boolean needAfter) {
        SimplePageMaster spm = LayoutMasterSetBuilder.getFactory().createSimplePageMaster();
        spm.setMasterName(masterName);
        spm.setPageHeight(UnitsOfMeasurement.twipToBest((int)page.getPgSz().getH().intValue()));
        spm.setPageWidth(UnitsOfMeasurement.twipToBest((int)page.getPgSz().getW().intValue()));
        spm.setMarginLeft(UnitsOfMeasurement.twipToBest((int)page.getPgMar().getLeft().intValue()));
        spm.setMarginRight(UnitsOfMeasurement.twipToBest((int)page.getPgMar().getRight().intValue()));
        RegionBody rb = LayoutMasterSetBuilder.getFactory().createRegionBody();
        rb.setMarginLeft("0mm");
        rb.setMarginRight("0mm");
        rb.setColumnCount(String.valueOf(page.getColsNum()));
        rb.setColumnGap(UnitsOfMeasurement.twipToBest((int)page.getColsSpacing()));
        float halfPageHeight = page.getPgSz().getH().intValue() / 40;
        String halfPageHeightPts = halfPageHeight + "pt";
        spm.setRegionBody(rb);
        if (needBefore) {
            RegionBefore rBefore = LayoutMasterSetBuilder.getFactory().createRegionBefore();
            rBefore.setRegionName("xsl-region-before-" + appendRegionName);
            spm.setRegionBefore(rBefore);
            int marginTopTwips = page.getHeaderMargin();
            spm.setMarginTop(UnitsOfMeasurement.twipToBest((int)marginTopTwips));
            rBefore.setExtent(halfPageHeightPts);
            rb.setMarginTop(halfPageHeightPts);
        } else {
            spm.setMarginTop(UnitsOfMeasurement.twipToBest((int)page.getPgMar().getTop().intValue()));
        }
        if (needAfter) {
            RegionAfter rAfter = LayoutMasterSetBuilder.getFactory().createRegionAfter();
            rAfter.setRegionName("xsl-region-after-" + appendRegionName);
            spm.setRegionAfter(rAfter);
            int marginBottomTwips = page.getFooterMargin();
            spm.setMarginBottom(UnitsOfMeasurement.twipToBest((int)marginBottomTwips));
            rAfter.setExtent(halfPageHeightPts);
            rb.setMarginBottom(halfPageHeightPts);
        } else {
            spm.setMarginBottom(UnitsOfMeasurement.twipToBest((int)page.getPgMar().getBottom().intValue()));
        }
        return spm;
    }

    private static ObjectFactory getFactory() {
        if (factory == null) {
            factory = new ObjectFactory();
        }
        return factory;
    }
}

