/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.org.xhtmlrenderer.pdf;

import com.lowagie.text.pdf.PdfAnnotation;
import com.lowagie.text.pdf.PdfAppearance;
import com.lowagie.text.pdf.PdfBorderDictionary;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfFormField;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import org.docx4j.org.xhtmlrenderer.css.parser.FSColor;
import org.docx4j.org.xhtmlrenderer.layout.LayoutContext;
import org.docx4j.org.xhtmlrenderer.pdf.AbstractFormField;
import org.docx4j.org.xhtmlrenderer.pdf.ITextOutputDevice;
import org.docx4j.org.xhtmlrenderer.render.BlockBox;
import org.docx4j.org.xhtmlrenderer.render.RenderingContext;
import org.w3c.dom.Element;

public class CheckboxFormField
extends AbstractFormField {
    private static final String FIELD_TYPE = "Checkbox";

    public CheckboxFormField(LayoutContext c, BlockBox box, int cssWidth, int cssHeight) {
        this.initDimensions(c, box, cssWidth, cssHeight);
    }

    protected String getFieldType() {
        return FIELD_TYPE;
    }

    public void paint(RenderingContext c, ITextOutputDevice outputDevice, BlockBox box) {
        PdfContentByte cb = outputDevice.getCurrentPage();
        PdfWriter writer = outputDevice.getWriter();
        PdfFormField field = PdfFormField.createCheckBox((PdfWriter)writer);
        Element e = box.getElement();
        String onValue = this.getValue(e);
        boolean checked = this.isChecked(e);
        float width = outputDevice.getDeviceLength(this.getWidth());
        float height = outputDevice.getDeviceLength(this.getHeight());
        FSColor color = box.getStyle().getColor();
        FSColor darker = box.getEffBackgroundColor(c).darkenColor();
        this.createAppearances(cb, field, onValue, width, height, true, color, darker);
        this.createAppearances(cb, field, onValue, width, height, false, color, darker);
        field.setWidget(outputDevice.createLocalTargetArea(c, box), PdfAnnotation.HIGHLIGHT_INVERT);
        field.setFieldName(this.getFieldName(outputDevice, e));
        field.setBorderStyle(new PdfBorderDictionary(0.0f, 0));
        field.setValueAsName(checked ? onValue : "Off");
        field.setAppearanceState(checked ? onValue : "Off");
        if (this.isReadOnly(e)) {
            field.setFieldFlags(1);
        }
        writer.addAnnotation((PdfAnnotation)field);
    }

    private void createAppearances(PdfContentByte cb, PdfFormField field, String onValue, float width, float height, boolean normal, FSColor color, FSColor darker) {
        PdfAppearance tpOff = cb.createAppearance(width, height);
        PdfAppearance tpOn = cb.createAppearance(width, height);
        this.setStrokeColor((PdfTemplate)tpOn, color);
        this.setStrokeColor((PdfTemplate)tpOff, color);
        float sLen = Math.min(width - this.reduce(width), height - this.reduce(height));
        if (!normal) {
            this.setFillColor((PdfTemplate)tpOff, darker);
            tpOff.rectangle(0.0f, 0.0f, width, height);
            tpOff.fill();
            this.setFillColor((PdfTemplate)tpOn, darker);
            tpOn.rectangle(0.0f, 0.0f, width, height);
            tpOn.fill();
        }
        tpOn.moveTo(width / 2.0f - sLen / 2.0f, height / 2.0f - sLen / 2.0f);
        tpOn.lineTo(width / 2.0f + sLen / 2.0f, height / 2.0f + sLen / 2.0f);
        tpOn.moveTo(width / 2.0f - sLen / 2.0f, height / 2.0f + sLen / 2.0f);
        tpOn.lineTo(width / 2.0f + sLen / 2.0f, height / 2.0f - sLen / 2.0f);
        tpOn.stroke();
        if (normal) {
            field.setAppearance(PdfAnnotation.APPEARANCE_NORMAL, "Off", (PdfTemplate)tpOff);
            field.setAppearance(PdfAnnotation.APPEARANCE_NORMAL, onValue, (PdfTemplate)tpOn);
        } else {
            field.setAppearance(PdfAnnotation.APPEARANCE_DOWN, "Off", (PdfTemplate)tpOff);
            field.setAppearance(PdfAnnotation.APPEARANCE_DOWN, onValue, (PdfTemplate)tpOn);
        }
    }

    private float reduce(float value) {
        return Math.min(value, Math.max(2.0f, 0.08f * value));
    }

    public int getBaseline() {
        return 0;
    }

    public boolean hasBaseline() {
        return false;
    }
}

