/*
 * Decompiled with CFR 0.152.
 */
package org.dojotoolkit.shrinksafe;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dojotoolkit.shrinksafe.DebugData;
import org.dojotoolkit.shrinksafe.ReplacedTokens;
import org.dojotoolkit.shrinksafe.TokenMapper;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.Interpreter;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.Parser;
import org.mozilla.javascript.ScriptOrFnNode;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.UintMap;

public class Compressor {
    private static final int FUNCTION_END = 160;

    private static String compress(String encodedSource, int flags, UintMap properties, ScriptOrFnNode parseTree, boolean escapeUnicode, String stripConsole, TokenMapper tm, Map replacedTokensLookup) {
        int topFunctionType;
        int indent = properties.getInt(1, 0);
        if (indent < 0) {
            throw new IllegalArgumentException();
        }
        int indentGap = properties.getInt(2, 4);
        if (indentGap < 0) {
            throw new IllegalArgumentException();
        }
        int caseGap = properties.getInt(3, 2);
        if (caseGap < 0) {
            throw new IllegalArgumentException();
        }
        String stripConsoleRegex = "assert|count|debug|dir|dirxml|group|groupEnd|info|profile|profileEnd|time|timeEnd|trace|log";
        if (stripConsole == null) {
            stripConsoleRegex = null;
        } else if (!stripConsole.equals("normal")) {
            if (stripConsole.equals("warn")) {
                stripConsoleRegex = stripConsoleRegex + "|warn";
            } else if (stripConsole.equals("all")) {
                stripConsoleRegex = stripConsoleRegex + "|warn|error";
            } else {
                throw new IllegalArgumentException("unrecognised value for stripConsole: " + stripConsole + "!");
            }
        }
        Pattern stripConsolePattern = null;
        if (stripConsoleRegex != null) {
            stripConsolePattern = Pattern.compile(stripConsoleRegex);
        }
        StringBuffer result = new StringBuffer();
        boolean justFunctionBody = 0 != (flags & 1);
        boolean toSource = 0 != (flags & 2);
        int braceNesting = 0;
        boolean afterFirstEOL = false;
        int i = 0;
        char prevToken = '\u0000';
        boolean primeFunctionNesting = false;
        boolean inArgsList = false;
        boolean primeInArgsList = false;
        boolean discardingConsole = false;
        int consoleParenCount = 0;
        StringBuffer discardMe = new StringBuffer();
        ReplacedTokens dummyTokens = new ReplacedTokens(new HashMap(), new int[0], replacedTokensLookup, null);
        int lastMeaningfulToken = 81;
        int lastMeaningfulTokenBeforeConsole = 81;
        if (encodedSource.charAt(i) == '\u0087') {
            ++i;
            topFunctionType = -1;
        } else {
            topFunctionType = encodedSource.charAt(i + 1);
        }
        if (!toSource) {
            for (int j = 0; j < indent; ++j) {
                result.append("");
            }
        } else if (topFunctionType == 2) {
            result.append('(');
        }
        Stack<Integer> positionStack = new Stack<Integer>();
        Stack<Integer> functionPositionStack = new Stack<Integer>();
        int length = encodedSource.length();
        int lineCount = 1;
        block104: while (i < length) {
            int jumpPos;
            char thisToken;
            if (i > 0) {
                prevToken = encodedSource.charAt(i - 1);
            }
            if (discardingConsole) {
                thisToken = encodedSource.charAt(i);
                switch (thisToken) {
                    case 'V': {
                        ++consoleParenCount;
                        break;
                    }
                    case 'W': {
                        if (--consoleParenCount != 0) break;
                        discardingConsole = false;
                        if (i < length - 1) {
                            int nextToken = Compressor.getNext(encodedSource, length, i);
                            if (lastMeaningfulTokenBeforeConsole != 81 && lastMeaningfulTokenBeforeConsole != 84 && lastMeaningfulTokenBeforeConsole != 85 || nextToken != 81) {
                                result.append("undefined");
                            } else if (81 == nextToken) {
                                ++i;
                            }
                        }
                        if (i >= length - 1 || 1 != Compressor.getNext(encodedSource, length, i)) break;
                        ++i;
                    }
                }
                switch (thisToken) {
                    case '\'': 
                    case '0': {
                        jumpPos = Compressor.getSourceStringEnd(encodedSource, i + 1, escapeUnicode);
                        if ('B' == encodedSource.charAt(jumpPos)) {
                            i = Compressor.printSourceString(encodedSource, i + 1, false, discardMe, escapeUnicode);
                            continue block104;
                        }
                        i = tm.sourceCompress(encodedSource, i + 1, false, discardMe, prevToken, inArgsList, braceNesting, dummyTokens);
                        continue block104;
                    }
                    case ')': {
                        i = Compressor.printSourceString(encodedSource, i + 1, true, discardMe, escapeUnicode);
                        continue block104;
                    }
                    case '(': {
                        i = Compressor.printSourceNumber(encodedSource, i + 1, discardMe);
                        continue block104;
                    }
                }
                ++i;
                continue;
            }
            thisToken = encodedSource.charAt(i);
            switch (thisToken) {
                case '\'': 
                case '0': {
                    jumpPos = Compressor.getSourceStringEnd(encodedSource, i + 1, escapeUnicode);
                    if (stripConsolePattern != null && thisToken == '\'') {
                        int afterFnName;
                        Matcher m;
                        int nextTokenAt = tm.sourceCompress(encodedSource, i + 1, false, discardMe, prevToken, inArgsList, braceNesting, dummyTokens);
                        if (encodedSource.substring(i + 2, i + 2 + encodedSource.charAt(i + 1)).equals("console") && encodedSource.charAt(nextTokenAt) == 'k' && (m = stripConsolePattern.matcher(encodedSource.substring(nextTokenAt + 3, afterFnName = Compressor.printSourceString(encodedSource, nextTokenAt + 2, false, discardMe, escapeUnicode)))).matches() && encodedSource.charAt(afterFnName) == 'V') {
                            discardingConsole = true;
                            consoleParenCount = 0;
                            lastMeaningfulTokenBeforeConsole = lastMeaningfulToken;
                            continue block104;
                        }
                    }
                    if ('B' == encodedSource.charAt(jumpPos)) {
                        i = Compressor.printSourceString(encodedSource, i + 1, false, result, escapeUnicode);
                        continue block104;
                    }
                    ReplacedTokens replacedTokens = null;
                    if (positionStack.size() > 0) {
                        Integer pos = (Integer)positionStack.peek();
                        replacedTokens = (ReplacedTokens)replacedTokensLookup.get(pos);
                    } else {
                        replacedTokens = new ReplacedTokens(new HashMap(), new int[0], replacedTokensLookup, null);
                    }
                    i = tm.sourceCompress(encodedSource, i + 1, false, result, prevToken, inArgsList, braceNesting, replacedTokens);
                    continue block104;
                }
                case ')': {
                    i = Compressor.printSourceString(encodedSource, i + 1, true, result, escapeUnicode);
                    continue block104;
                }
                case '(': {
                    i = Compressor.printSourceNumber(encodedSource, i + 1, result);
                    continue block104;
                }
                case '-': {
                    result.append("true");
                    break;
                }
                case ',': {
                    result.append("false");
                    break;
                }
                case '*': {
                    result.append("null");
                    break;
                }
                case '+': {
                    result.append("this");
                    break;
                }
                case 'l': {
                    ++i;
                    tm.incrementFunctionNumber();
                    primeInArgsList = true;
                    primeFunctionNesting = true;
                    result.append("function");
                    if (86 != Compressor.getNext(encodedSource, length, i)) {
                        result.append(' ');
                    }
                    Integer functionPos = new Integer(i - 1);
                    functionPositionStack.push(functionPos);
                    DebugData debugData = tm.getDebugData(functionPos);
                    debugData.compressedStart = lineCount;
                    break;
                }
                case '\u00a0': {
                    Integer functionPos = (Integer)functionPositionStack.pop();
                    DebugData debugData = tm.getDebugData(functionPos);
                    debugData.compressedEnd = lineCount;
                    break;
                }
                case 'X': {
                    result.append(",");
                    break;
                }
                case 'T': {
                    ++braceNesting;
                    if (1 == Compressor.getNext(encodedSource, length, i)) {
                        indent += indentGap;
                    }
                    result.append('{');
                    break;
                }
                case 'U': {
                    if (tm.leaveNestingLevel(braceNesting)) {
                        positionStack.pop();
                    }
                    if (justFunctionBody && --braceNesting == 0) break;
                    result.append('}');
                    switch (Compressor.getNext(encodedSource, length, i)) {
                        case 1: 
                        case 160: {
                            if (Compressor.getNext(encodedSource, length, i + 1) != 81 && Compressor.getNext(encodedSource, length, i + 1) != 86 && Compressor.getNext(encodedSource, length, i + 1) != 87 && Compressor.getNext(encodedSource, length, i + 1) != 83 && Compressor.getNext(encodedSource, length, i + 1) != 85 && Compressor.getNext(encodedSource, length, i + 1) != 88 && Compressor.getNext(encodedSource, length, i + 1) != 102 && Compressor.getNext(encodedSource, length, i + 1) != 107 && Compressor.getNext(encodedSource, length, i) == 160) {
                                result.append(';');
                            }
                            indent -= indentGap;
                            break;
                        }
                        case 112: 
                        case 116: {
                            indent -= indentGap;
                            result.append("");
                        }
                    }
                    break;
                }
                case 'V': {
                    if (primeInArgsList) {
                        inArgsList = true;
                        primeInArgsList = false;
                    }
                    if (primeFunctionNesting) {
                        positionStack.push(new Integer(i));
                        tm.enterNestingLevel(braceNesting);
                        primeFunctionNesting = false;
                    }
                    result.append('(');
                    break;
                }
                case 'W': {
                    if (inArgsList) {
                        inArgsList = false;
                    }
                    result.append(')');
                    break;
                }
                case 'R': {
                    result.append('[');
                    break;
                }
                case 'S': {
                    result.append(']');
                    break;
                }
                case '\u0001': {
                    int afterName;
                    if (toSource) break;
                    boolean newLine = true;
                    if (!afterFirstEOL) {
                        afterFirstEOL = true;
                        if (justFunctionBody) {
                            result.setLength(0);
                            indent -= indentGap;
                            newLine = false;
                        }
                    }
                    if (newLine) {
                        result.append('\n');
                        ++lineCount;
                    }
                    if (i + 1 >= length) break;
                    int less = 0;
                    char nextToken = encodedSource.charAt(i + 1);
                    if (nextToken == 'r' || nextToken == 's') {
                        less = indentGap - caseGap;
                    } else if (nextToken == 'U') {
                        less = indentGap;
                    } else if (nextToken == '\'' && encodedSource.charAt(afterName = Compressor.getSourceStringEnd(encodedSource, i + 2, escapeUnicode)) == 'f') {
                        less = indentGap;
                    }
                    while (less < indent) {
                        result.append("");
                        ++less;
                    }
                    break;
                }
                case 'k': {
                    result.append('.');
                    break;
                }
                case '\u001e': {
                    result.append("new ");
                    break;
                }
                case '\u001f': {
                    result.append("delete ");
                    break;
                }
                case 'o': {
                    result.append("if");
                    break;
                }
                case 'p': {
                    result.append("else");
                    break;
                }
                case 'v': {
                    result.append("for");
                    break;
                }
                case '4': {
                    result.append(" in ");
                    break;
                }
                case 'z': {
                    result.append("with");
                    break;
                }
                case 't': {
                    result.append("while");
                    break;
                }
                case 'u': {
                    result.append("do");
                    break;
                }
                case 'P': {
                    result.append("try");
                    break;
                }
                case '{': {
                    result.append("catch");
                    break;
                }
                case '|': {
                    result.append("finally");
                    break;
                }
                case '2': {
                    result.append("throw ");
                    break;
                }
                case 'q': {
                    result.append("switch");
                    break;
                }
                case 'w': {
                    result.append("break");
                    if (39 != Compressor.getNext(encodedSource, length, i)) break;
                    result.append(' ');
                    break;
                }
                case 'x': {
                    result.append("continue");
                    if (39 != Compressor.getNext(encodedSource, length, i)) break;
                    result.append(' ');
                    break;
                }
                case 'r': {
                    result.append("case ");
                    break;
                }
                case 's': {
                    result.append("default");
                    break;
                }
                case '\u0004': {
                    result.append("return");
                    if (81 == Compressor.getNext(encodedSource, length, i)) break;
                    result.append(' ');
                    break;
                }
                case 'y': {
                    result.append("var ");
                    break;
                }
                case 'Q': {
                    result.append(';');
                    break;
                }
                case 'Y': {
                    result.append("=");
                    break;
                }
                case '`': {
                    result.append("+=");
                    break;
                }
                case 'a': {
                    result.append("-=");
                    break;
                }
                case 'b': {
                    result.append("*=");
                    break;
                }
                case 'c': {
                    result.append("/=");
                    break;
                }
                case 'd': {
                    result.append("%=");
                    break;
                }
                case 'Z': {
                    result.append("|=");
                    break;
                }
                case '[': {
                    result.append("^=");
                    break;
                }
                case '\\': {
                    result.append("&=");
                    break;
                }
                case ']': {
                    result.append("<<=");
                    break;
                }
                case '^': {
                    result.append(">>=");
                    break;
                }
                case '_': {
                    result.append(">>>=");
                    break;
                }
                case 'e': {
                    result.append("?");
                    break;
                }
                case 'B': {
                    result.append(':');
                    break;
                }
                case 'f': {
                    if (1 == Compressor.getNext(encodedSource, length, i)) {
                        result.append(':');
                        break;
                    }
                    result.append(":");
                    break;
                }
                case 'g': {
                    result.append("||");
                    break;
                }
                case 'h': {
                    result.append("&&");
                    break;
                }
                case '\t': {
                    result.append("|");
                    break;
                }
                case '\n': {
                    result.append("^");
                    break;
                }
                case '\u000b': {
                    result.append("&");
                    break;
                }
                case '.': {
                    result.append("===");
                    break;
                }
                case '/': {
                    result.append("!==");
                    break;
                }
                case '\f': {
                    result.append("==");
                    break;
                }
                case '\r': {
                    result.append("!=");
                    break;
                }
                case '\u000f': {
                    result.append("<=");
                    break;
                }
                case '\u000e': {
                    result.append("<");
                    break;
                }
                case '\u0011': {
                    result.append(">=");
                    break;
                }
                case '\u0010': {
                    result.append(">");
                    break;
                }
                case '5': {
                    result.append(" instanceof ");
                    break;
                }
                case '\u0012': {
                    result.append("<<");
                    break;
                }
                case '\u0013': {
                    result.append(">>");
                    break;
                }
                case '\u0014': {
                    result.append(">>>");
                    break;
                }
                case ' ': {
                    result.append("typeof ");
                    break;
                }
                case '}': {
                    result.append("void ");
                    break;
                }
                case '\u001a': {
                    result.append('!');
                    break;
                }
                case '\u001b': {
                    result.append('~');
                    break;
                }
                case '\u001c': {
                    result.append('+');
                    break;
                }
                case '\u001d': {
                    result.append('-');
                    break;
                }
                case 'i': {
                    if ('\u0015' == prevToken) {
                        result.append(' ');
                    }
                    result.append("++");
                    if (21 != Compressor.getNext(encodedSource, length, i)) break;
                    result.append(' ');
                    break;
                }
                case 'j': {
                    if ('\u0016' == prevToken) {
                        result.append(' ');
                    }
                    result.append("--");
                    if (22 != Compressor.getNext(encodedSource, length, i)) break;
                    result.append(' ');
                    break;
                }
                case '\u0015': {
                    result.append("+");
                    char nextToken = encodedSource.charAt(i + 1);
                    if (nextToken != '\u001c') break;
                    result.append(' ');
                    break;
                }
                case '\u0016': {
                    result.append("-");
                    char nextToken = encodedSource.charAt(i + 1);
                    if (nextToken != '\u001d') break;
                    result.append(' ');
                    break;
                }
                case '\u0017': {
                    result.append("*");
                    break;
                }
                case '\u0018': {
                    result.append("/");
                    break;
                }
                case '\u0019': {
                    result.append("%");
                    break;
                }
                case '\u008f': {
                    result.append("::");
                    break;
                }
                case '\u008e': {
                    result.append("..");
                    break;
                }
                case '\u0092': {
                    result.append('@');
                    break;
                }
                case '\u009f': {
                    System.out.println("WARNING: Found a `debugger;` statement in code being compressed");
                    result.append("debugger");
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
            if (thisToken != '\u0001') {
                lastMeaningfulToken = thisToken;
            }
            ++i;
        }
        if (toSource && topFunctionType == 2) {
            result.append(')');
        }
        return result.toString();
    }

    private static Map collectReplacedTokens(String encodedSource, boolean escapeUnicode, TokenMapper tm) {
        int length = encodedSource.length();
        int i = 0;
        char prevToken = '\u0000';
        int braceNesting = 0;
        boolean inArgsList = false;
        boolean primeFunctionNesting = false;
        boolean primeInArgsList = false;
        if (encodedSource.charAt(i) == '\u0087') {
            ++i;
        }
        Stack<Integer> positionStack = new Stack<Integer>();
        Stack<Integer> functionPositionStack = new Stack<Integer>();
        HashMap<Integer, ReplacedTokens> tokenLookup = new HashMap<Integer, ReplacedTokens>();
        block10: while (i < length) {
            if (i > 0) {
                prevToken = encodedSource.charAt(i - 1);
            }
            switch (encodedSource.charAt(i)) {
                case '\'': 
                case '0': {
                    int jumpPos = Compressor.getSourceStringEnd(encodedSource, i + 1, escapeUnicode);
                    if ('B' == encodedSource.charAt(jumpPos)) {
                        i = Compressor.printSourceString(encodedSource, i + 1, false, null, escapeUnicode);
                        continue block10;
                    }
                    i = tm.sourceCompress(encodedSource, i + 1, false, null, prevToken, inArgsList, braceNesting, null);
                    continue block10;
                }
                case ')': {
                    i = Compressor.printSourceString(encodedSource, i + 1, true, null, escapeUnicode);
                    continue block10;
                }
                case '(': {
                    i = Compressor.printSourceNumber(encodedSource, i + 1, null);
                    continue block10;
                }
                case 'l': {
                    tm.incrementFunctionNumber();
                    primeInArgsList = true;
                    primeFunctionNesting = true;
                    functionPositionStack.push(new Integer(++i - 1));
                    break;
                }
                case 'T': {
                    ++braceNesting;
                    break;
                }
                case 'U': {
                    Map m = tm.getCurrentTokens();
                    if (tm.leaveNestingLevel(braceNesting)) {
                        Integer pos = (Integer)positionStack.pop();
                        Integer functionPos = (Integer)functionPositionStack.pop();
                        int[] parents = new int[positionStack.size()];
                        int idx = 0;
                        Iterator itr = positionStack.iterator();
                        while (itr.hasNext()) {
                            parents[idx++] = (Integer)itr.next();
                        }
                        DebugData debugData = tm.getDebugData(functionPos);
                        ReplacedTokens replacedTokens = new ReplacedTokens(m, parents, tokenLookup, debugData);
                        tokenLookup.put(pos, replacedTokens);
                    }
                    --braceNesting;
                    break;
                }
                case 'V': {
                    if (primeInArgsList) {
                        inArgsList = true;
                        primeInArgsList = false;
                    }
                    if (!primeFunctionNesting) break;
                    positionStack.push(new Integer(i));
                    tm.enterNestingLevel(braceNesting);
                    primeFunctionNesting = false;
                    break;
                }
                case 'W': {
                    if (!inArgsList) break;
                    inArgsList = false;
                }
            }
            ++i;
        }
        return tokenLookup;
    }

    private static int getNext(String source, int length, int i) {
        return i + 1 < length ? (int)source.charAt(i + 1) : 0;
    }

    private static int getSourceStringEnd(String source, int offset, boolean escapeUnicode) {
        return Compressor.printSourceString(source, offset, false, null, escapeUnicode);
    }

    private static int printSourceString(String source, int offset, boolean asQuotedString, StringBuffer sb, boolean escapeUnicode) {
        int length = source.charAt(offset);
        ++offset;
        if ((0x8000 & length) != 0) {
            length = (Short.MAX_VALUE & length) << 16 | source.charAt(offset);
            ++offset;
        }
        if (sb != null) {
            String str = source.substring(offset, offset + length);
            if (!asQuotedString) {
                sb.append(str);
            } else {
                sb.append('\"');
                sb.append(Compressor.escapeString(str, escapeUnicode));
                sb.append('\"');
            }
        }
        return offset + length;
    }

    private static int printSourceNumber(String source, int offset, StringBuffer sb) {
        double number = 0.0;
        char type = source.charAt(offset);
        ++offset;
        if (type == 'S') {
            if (sb != null) {
                char ival = source.charAt(offset);
                number = ival;
            }
            ++offset;
        } else if (type == 'J' || type == 'D') {
            if (sb != null) {
                long lbits = (long)source.charAt(offset) << 48;
                lbits |= (long)source.charAt(offset + 1) << 32;
                lbits |= (long)source.charAt(offset + 2) << 16;
                number = type == 'J' ? (double)lbits : Double.longBitsToDouble(lbits |= (long)source.charAt(offset + 3));
            }
            offset += 4;
        } else {
            throw new RuntimeException();
        }
        if (sb != null) {
            sb.append(ScriptRuntime.numberToString((double)number, (int)10));
        }
        return offset;
    }

    private static String escapeString(String s, boolean escapeUnicode) {
        return Compressor.escapeString(s, '\"', escapeUnicode);
    }

    private static String escapeString(String s, char escapeQuote, boolean escapeUnicode) {
        if (escapeQuote != '\"' && escapeQuote != '\'') {
            Kit.codeBug();
        }
        StringBuffer sb = null;
        int L = s.length();
        for (int i = 0; i != L; ++i) {
            char c = s.charAt(i);
            if (' ' <= c && c <= '~' && c != escapeQuote && c != '\\') {
                if (sb == null) continue;
                sb.append(c);
                continue;
            }
            if (sb == null) {
                sb = new StringBuffer(L + 3);
                sb.append(s);
                sb.setLength(i);
            }
            int escape = -1;
            switch (c) {
                case '\b': {
                    escape = 98;
                    break;
                }
                case '\f': {
                    escape = 102;
                    break;
                }
                case '\n': {
                    escape = 110;
                    break;
                }
                case '\r': {
                    escape = 114;
                    break;
                }
                case '\t': {
                    escape = 116;
                    break;
                }
                case '\u000b': {
                    escape = 118;
                    break;
                }
                case ' ': {
                    escape = 32;
                    break;
                }
                case '\\': {
                    escape = 92;
                }
            }
            if (escape >= 0) {
                sb.append('\\');
                sb.append((char)escape);
                continue;
            }
            if (c == escapeQuote) {
                sb.append('\\');
                sb.append(escapeQuote);
                continue;
            }
            if (escapeUnicode || c == '\u0000') {
                int hexSize;
                if (c < '\u0100') {
                    sb.append("\\x");
                    hexSize = 2;
                } else {
                    sb.append("\\u");
                    hexSize = 4;
                }
                for (int shift = (hexSize - 1) * 4; shift >= 0; shift -= 4) {
                    int digit = 0xF & c >> shift;
                    int hc = digit < 10 ? 48 + digit : 87 + digit;
                    sb.append((char)hc);
                }
                continue;
            }
            sb.append(c);
        }
        return sb == null ? s : sb.toString();
    }

    public static final String compressScript(String source, int indent, int lineno, String stripConsole) {
        return Compressor.compressScript(source, indent, lineno, false, stripConsole);
    }

    public static final String compressScript(String source, int indent, int lineno, boolean escapeUnicode, String stripConsole) {
        return Compressor.compressScript(source, indent, lineno, escapeUnicode, stripConsole, null);
    }

    public static final String compressScript(String source, int indent, int lineno, boolean escapeUnicode, String stripConsole, StringBuffer debugData) {
        CompilerEnvirons compilerEnv = new CompilerEnvirons();
        Parser parser = new Parser(compilerEnv, compilerEnv.getErrorReporter());
        ScriptOrFnNode tree = parser.parse(source, null, lineno);
        String encodedSource = parser.getEncodedSource();
        if (encodedSource.length() == 0) {
            return "";
        }
        Interpreter compiler = new Interpreter();
        compiler.compile(compilerEnv, tree, encodedSource, false);
        UintMap properties = new UintMap(1);
        properties.put(1, indent);
        TokenMapper tm = new TokenMapper(tree);
        Map replacedTokensLookup = Compressor.collectReplacedTokens(encodedSource, escapeUnicode, tm);
        tm.reset();
        String compressedSource = Compressor.compress(encodedSource, 0, properties, tree, escapeUnicode, stripConsole, tm, replacedTokensLookup);
        if (debugData != null) {
            debugData.append("[\n");
            int count = 1;
            for (Integer pos : replacedTokensLookup.keySet()) {
                ReplacedTokens replacedTokens = (ReplacedTokens)replacedTokensLookup.get(pos);
                debugData.append(replacedTokens.toJson());
                if (count++ < replacedTokensLookup.size()) {
                    debugData.append(',');
                }
                debugData.append("\n");
            }
            debugData.append("]");
        }
        return compressedSource;
    }
}

