/*
 * Decompiled with CFR 0.152.
 */
package org.dojotoolkit.shrinksafe;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.dojotoolkit.shrinksafe.Compressor;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextAction;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.tools.ToolErrorReporter;
import org.mozilla.javascript.tools.shell.Global;
import org.mozilla.javascript.tools.shell.QuitAction;
import org.mozilla.javascript.tools.shell.ShellContextFactory;

public class Main {
    protected static final Global global = new Global();
    protected static final ShellContextFactory shellContextFactory = new ShellContextFactory();
    protected static ToolErrorReporter errorReporter;
    protected static int exitCode;
    protected static boolean escapeUnicode;
    protected static String stripConsole;

    public static void main(String[] args) {
        errorReporter = new ToolErrorReporter(false, global.getErr());
        shellContextFactory.setErrorReporter((ErrorReporter)errorReporter);
        IProxy iproxy = new IProxy(1, Main.processOptions(args));
        global.init((ContextFactory)shellContextFactory);
        shellContextFactory.call((ContextAction)iproxy);
    }

    public static String[] processOptions(String[] args) {
        ArrayList<String> fileList = new ArrayList<String>();
        String usageError = null;
        boolean showUsage = false;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (!arg.startsWith("-")) {
                fileList.add(arg);
                continue;
            }
            if (arg.equals("-js-version")) {
                if (++i == args.length) {
                    usageError = arg;
                }
                int version = 0;
                try {
                    version = Integer.parseInt(args[i]);
                }
                catch (NumberFormatException ex) {
                    usageError = args[i];
                }
                if (!Context.isValidLanguageVersion((int)version)) {
                    usageError = args[i];
                }
                if (usageError == null) continue;
                shellContextFactory.setLanguageVersion(version);
                continue;
            }
            if (arg.equals("-?") || arg.equals("-help")) {
                showUsage = true;
                continue;
            }
            if (arg.equals("-escape-unicode")) {
                escapeUnicode = true;
                continue;
            }
            if (!arg.equals("-stripConsole")) continue;
            if (i >= args.length - 1) {
                usageError = Main.getMessage("msg.shell.stripConsoleMissingArg");
                continue;
            }
            if ((stripConsole = args[++i]).equals("normal") || stripConsole.equals("warn") || stripConsole.equals("all")) continue;
            usageError = Main.getMessage("msg.shell.stripConsoleInvalid");
        }
        if (usageError != null) {
            global.getOut().println(Main.getMessage("msg.shell.invalid", usageError));
        }
        if (usageError != null || showUsage) {
            global.getOut().println(Main.getMessage("msg.shell.usage"));
            System.exit(1);
        }
        String[] files = new String[fileList.size()];
        files = fileList.toArray(files);
        return files;
    }

    static void processFiles(Context cx, String[] files) throws IOException {
        StringBuffer cout = new StringBuffer();
        if (files.length > 0) {
            for (int i = 0; i < files.length; ++i) {
                try {
                    String source = (String)Main.readFileOrUrl(files[i], true);
                    cout.append(Compressor.compressScript(source, 0, 1, escapeUnicode, stripConsole));
                    continue;
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
        } else {
            byte[] data = Kit.readStream((InputStream)global.getIn(), (int)4096);
            String source = new String(data);
            if (source != null) {
                cout.append(Compressor.compressScript(source, 0, 1, escapeUnicode, stripConsole));
            }
        }
        global.getOut().println(cout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object readFileOrUrl(String path, boolean convertToString) throws IOException {
        byte[] data;
        URL url = null;
        if (path.indexOf(58) >= 2) {
            try {
                url = new URL(path);
            }
            catch (MalformedURLException ex) {
                // empty catch block
            }
        }
        InputStream is = null;
        int capacityHint = 0;
        if (url == null) {
            File file = new File(path);
            capacityHint = (int)file.length();
            try {
                is = new FileInputStream(file);
            }
            catch (IOException ex) {
                Context.reportError((String)Main.getMessage("msg.couldnt.open", path));
                throw ex;
            }
        }
        try {
            URLConnection uc = url.openConnection();
            is = uc.getInputStream();
            capacityHint = uc.getContentLength();
            if (capacityHint > 0x100000) {
                capacityHint = -1;
            }
        }
        catch (IOException ex) {
            Context.reportError((String)Main.getMessage("msg.couldnt.open.url", url.toString(), ex.toString()));
            throw ex;
        }
        if (capacityHint <= 0) {
            capacityHint = 4096;
        }
        try {
            try {
                is = new BufferedInputStream(is);
                data = Kit.readStream((InputStream)is, (int)capacityHint);
            }
            finally {
                is.close();
            }
        }
        catch (IOException ex) {
            Context.reportError((String)ex.toString());
            throw ex;
        }
        Object result = convertToString ? (Object)new String(data) : data;
        return result;
    }

    private static String getMessage(String messageId) {
        return Main.getMessage(messageId, (Object[])null);
    }

    private static String getMessage(String messageId, String argument) {
        return Main.getMessage(messageId, new Object[]{argument});
    }

    private static String getMessage(String messageId, Object arg1, Object arg2) {
        return Main.getMessage(messageId, new Object[]{arg1, arg2});
    }

    private static String getMessage(String messageId, Object[] args) {
        Context cx = Context.getCurrentContext();
        Locale locale = cx == null ? Locale.getDefault() : cx.getLocale();
        ResourceBundle rb = ResourceBundle.getBundle("org.dojotoolkit.shrinksafe.resources.Messages", locale);
        String formatString = null;
        try {
            formatString = rb.getString(messageId);
        }
        catch (MissingResourceException mre) {
            throw new RuntimeException("no message resource found for message property " + messageId);
        }
        if (args == null) {
            return formatString;
        }
        MessageFormat formatter = new MessageFormat(formatString);
        return formatter.format(args);
    }

    static {
        exitCode = 0;
        escapeUnicode = false;
        stripConsole = null;
        global.initQuitAction((QuitAction)new IProxy(3, null));
    }

    private static class IProxy
    implements ContextAction,
    QuitAction {
        private static final int PROCESS_FILES = 1;
        private static final int SYSTEM_EXIT = 3;
        private int type;
        private String[] args;

        IProxy(int type, String[] args) {
            this.type = type;
            this.args = args;
        }

        public Object run(Context cx) {
            if (this.type == 1) {
                try {
                    Main.processFiles(cx, this.args);
                }
                catch (IOException ioe) {
                    Context.reportError((String)ioe.toString());
                }
            } else {
                throw Kit.codeBug();
            }
            return null;
        }

        public void quit(Context cx, int exitCode) {
            if (this.type == 3) {
                System.exit(exitCode);
                return;
            }
            throw Kit.codeBug();
        }
    }
}

