/*
 * Decompiled with CFR 0.152.
 */
package org.dominokit.domino.test.history;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.dominokit.domino.history.AppHistory;
import org.dominokit.domino.history.DefaultNormalizedToken;
import org.dominokit.domino.history.DominoDirectState;
import org.dominokit.domino.history.DominoHistory;
import org.dominokit.domino.history.HistoryInterceptor;
import org.dominokit.domino.history.HistoryToken;
import org.dominokit.domino.history.InterceptorChain;
import org.dominokit.domino.history.NormalizedToken;
import org.dominokit.domino.history.StateHistoryToken;
import org.dominokit.domino.history.StateToken;
import org.dominokit.domino.history.TokenEvent;
import org.dominokit.domino.history.TokenFilter;
import org.dominokit.domino.history.TokenParameter;

public class TestDominoHistory
implements AppHistory {
    private Set<HistoryListener> listeners = new HashSet<HistoryListener>();
    private Deque<HistoryState> forwards = new LinkedList<HistoryState>();
    private Deque<HistoryState> backwards = new LinkedList<HistoryState>();
    private String rootPath;
    private List<HistoryInterceptor> interceptors = new ArrayList<HistoryInterceptor>();

    public TestDominoHistory() {
        this("");
    }

    public TestDominoHistory(String rootPath) {
        this.setRootPath(rootPath);
    }

    public DominoHistory.DirectState listen(DominoHistory.StateListener listener) {
        return this.listen(TokenFilter.any(), listener, false);
    }

    public DominoHistory.DirectState listen(TokenFilter tokenFilter, DominoHistory.StateListener listener) {
        return this.listen(tokenFilter, listener, false);
    }

    public DominoHistory.DirectState listen(DominoHistory.StateListener listener, boolean removeOnComplete) {
        return this.listen(TokenFilter.any(), listener, removeOnComplete);
    }

    public DominoHistory.DirectState listen(TokenFilter tokenFilter, DominoHistory.StateListener listener, boolean removeOnComplete) {
        this.listeners.add(new HistoryListener(listener, tokenFilter, removeOnComplete));
        return new DominoDirectState(tokenFilter, this.currentState(), listener);
    }

    public void removeListener(DominoHistory.StateListener listener) {
        this.listeners.remove(listener);
    }

    private DominoHistory.State currentState() {
        if (this.forwards.isEmpty()) {
            return new TestState(this.nullState());
        }
        return new TestState(this.forwards.peek());
    }

    private HistoryState nullState() {
        return new HistoryState("", "");
    }

    private void inform(HistoryState state) {
        if (!this.isSameRoot(state.token)) {
            return;
        }
        ArrayList completedListeners = new ArrayList();
        this.listeners.stream().filter(l -> {
            NormalizedToken normalized = this.getNormalizedToken(this.rootPath, state.token, (HistoryListener)l);
            if (Objects.isNull(normalized)) {
                normalized = new DefaultNormalizedToken(this.rootPath, state.token);
            }
            return l.tokenFilter.filter(new TestState(new HistoryState(normalized.getToken().value(), "test")).token());
        }).forEach(listener -> {
            if (listener.isRemoveOnComplete()) {
                completedListeners.add(listener);
            }
            NormalizedToken normalized = this.getNormalizedToken(this.rootPath, state.token, (HistoryListener)listener);
            listener.listener.onPopState((DominoHistory.State)new TestState(normalized, new HistoryState(normalized.getToken().value(), "test")));
        });
        this.listeners.removeAll(completedListeners);
    }

    private boolean isSameRoot(String token) {
        if (this.rootPath.isEmpty()) {
            return true;
        }
        return token.startsWith(this.rootPath);
    }

    private NormalizedToken getNormalizedToken(String rootPath, String token, HistoryListener listener) {
        return listener.tokenFilter.normalizeToken(rootPath, token);
    }

    public void back() {
        if (!this.backwards.isEmpty()) {
            HistoryState state = this.backwards.pop();
            this.forwards.push(state);
            this.inform(state);
        }
    }

    public void forward() {
        if (!this.forwards.isEmpty()) {
            HistoryState state = this.forwards.pop();
            this.backwards.push(state);
            this.inform(state);
        }
    }

    public int getHistoryEntriesCount() {
        return this.backwards.size();
    }

    public void pushState(StateToken stateToken) {
        this.push(stateToken, new TokenParameter[0]);
    }

    public void pushState(StateToken stateToken, TokenParameter ... parameters) {
        this.push(stateToken, parameters);
    }

    private void pushState(StateToken stateToken, Runnable onPushHandler, TokenParameter ... parameters) {
        this.push(stateToken, onPushHandler, parameters);
    }

    public void fireState(StateToken stateToken) {
        this.fireState(stateToken, new TokenParameter[0]);
    }

    public void fireState(StateToken stateToken, TokenParameter ... parameters) {
        this.pushState(stateToken, this::fireCurrentStateHistory, parameters);
    }

    public void replaceState(StateToken stateToken) {
        this.forwards.pop();
        this.push(stateToken, new TokenParameter[0]);
    }

    public HistoryToken currentToken() {
        if (Objects.isNull(this.forwards.peek())) {
            return new StateHistoryToken(this.rootPath, "");
        }
        return new StateHistoryToken(this.rootPath, this.forwards.peek().token);
    }

    public String getRootPath() {
        return this.rootPath;
    }

    public void setRootPath(String path) {
        this.rootPath = Objects.isNull(path) ? "" : path.trim();
    }

    public void fireCurrentStateHistory() {
        if (!this.forwards.isEmpty()) {
            this.inform(this.forwards.peek());
        }
    }

    public void fireCurrentStateHistory(String title) {
        this.fireCurrentStateHistory();
    }

    public void initialState(String token, String data) {
        this.push(StateToken.of((String)token).data(data), new TokenParameter[0]);
    }

    private void push(StateToken stateToken, TokenParameter ... parameters) {
        this.push(stateToken, () -> {}, parameters);
    }

    private void push(StateToken stateToken, Runnable onPushHandler, TokenParameter ... parameters) {
        InterceptorChain interceptorChain = new InterceptorChain(this.interceptors, () -> {
            this.forwards.push(new HistoryState(this.replaceParameters(stateToken, Arrays.asList(parameters)), stateToken.getData()));
            onPushHandler.run();
        });
        interceptorChain.intercept(new TokenEvent(stateToken));
    }

    private String replaceParameters(StateToken stateToken, List<TokenParameter> parametersList) {
        String result = stateToken.getToken();
        for (TokenParameter parameter : parametersList) {
            result = result.replace(":" + parameter.getName(), parameter.getValue());
        }
        return result;
    }

    public Set<HistoryListener> getListeners() {
        return this.listeners;
    }

    public Deque<HistoryState> getForwards() {
        return this.forwards;
    }

    public Deque<HistoryState> getBackwards() {
        return this.backwards;
    }

    public void addInterceptor(HistoryInterceptor interceptor) {
        if (Objects.nonNull(interceptor)) {
            this.interceptors.add(interceptor);
        }
    }

    public void removeInterceptor(HistoryInterceptor interceptor) {
        if (Objects.nonNull(interceptor)) {
            this.interceptors.remove(interceptor);
        }
    }

    public void invoke() {
        HistoryState state = this.forwards.peek();
        if (Objects.nonNull(state)) {
            this.inform(state);
        }
    }

    public class HistoryState {
        private final String token;
        private final String data;

        public HistoryState(String token, String data) {
            this.token = token;
            this.data = data;
        }

        public String getToken() {
            return this.token;
        }

        public String getData() {
            return this.data;
        }
    }

    private class TestState
    implements DominoHistory.State {
        private final HistoryState historyState;
        private NormalizedToken normalizedToken;

        private TestState(HistoryState historyState) {
            this.historyState = historyState;
        }

        private TestState(NormalizedToken normalizedToken, HistoryState historyState) {
            this.normalizedToken = normalizedToken;
            this.historyState = historyState;
        }

        public String rootPath() {
            return TestDominoHistory.this.rootPath;
        }

        public HistoryToken token() {
            return new StateHistoryToken(this.historyState.token);
        }

        public Optional<String> data() {
            return Optional.ofNullable(this.historyState.data);
        }

        public String title() {
            return "test title";
        }

        public NormalizedToken normalizedToken() {
            return this.normalizedToken;
        }

        public void setNormalizedToken(NormalizedToken normalizedToken) {
            this.normalizedToken = normalizedToken;
        }
    }

    private class HistoryListener {
        private final DominoHistory.StateListener listener;
        private final TokenFilter tokenFilter;
        private final boolean removeOnComplete;

        public HistoryListener(DominoHistory.StateListener listener, TokenFilter tokenFilter) {
            this.listener = listener;
            this.tokenFilter = tokenFilter;
            this.removeOnComplete = false;
        }

        public HistoryListener(DominoHistory.StateListener listener, TokenFilter tokenFilter, boolean removeOnComplete) {
            this.listener = listener;
            this.tokenFilter = tokenFilter;
            this.removeOnComplete = removeOnComplete;
        }

        public boolean isRemoveOnComplete() {
            return this.removeOnComplete;
        }
    }
}

