/*
 * Decompiled with CFR 0.152.
 */
package dominojackson.shaded.com.google.auto.common;

import dominojackson.shaded.com.google.auto.common.AnnotationMirrors;
import dominojackson.shaded.com.google.auto.common.MoreTypes;
import dominojackson.shaded.com.google.common.base.Joiner;
import dominojackson.shaded.com.google.common.base.Preconditions;
import dominojackson.shaded.com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.ElementFilter;

public final class SimpleAnnotationMirror
implements AnnotationMirror {
    private final TypeElement annotationType;
    private final ImmutableMap<String, ? extends AnnotationValue> namedValues;
    private final ImmutableMap<ExecutableElement, ? extends AnnotationValue> elementValues;

    private SimpleAnnotationMirror(TypeElement annotationType, Map<String, ? extends AnnotationValue> namedValues) {
        Preconditions.checkArgument(annotationType.getKind().equals((Object)ElementKind.ANNOTATION_TYPE), "annotationType must be an annotation: %s", (Object)annotationType);
        LinkedHashMap<String, AnnotationValue> values = new LinkedHashMap<String, AnnotationValue>();
        LinkedHashMap<String, ? extends AnnotationValue> unusedValues = new LinkedHashMap<String, AnnotationValue>(namedValues);
        ArrayList<String> missingMembers = new ArrayList<String>();
        for (ExecutableElement method : ElementFilter.methodsIn(annotationType.getEnclosedElements())) {
            String memberName = method.getSimpleName().toString();
            if (unusedValues.containsKey(memberName)) {
                values.put(memberName, (AnnotationValue)unusedValues.remove(memberName));
                continue;
            }
            if (method.getDefaultValue() != null) {
                values.put(memberName, method.getDefaultValue());
                continue;
            }
            missingMembers.add(memberName);
        }
        Preconditions.checkArgument(unusedValues.isEmpty(), "namedValues has entries for members that are not in %s: %s", (Object)annotationType, unusedValues);
        Preconditions.checkArgument(missingMembers.isEmpty(), "namedValues is missing entries for: %s", missingMembers);
        this.annotationType = annotationType;
        this.namedValues = ImmutableMap.copyOf(namedValues);
        this.elementValues = ElementFilter.methodsIn(annotationType.getEnclosedElements()).stream().collect(ImmutableMap.toImmutableMap(e -> e, e -> (AnnotationValue)values.get(e.getSimpleName().toString())));
    }

    public static AnnotationMirror of(TypeElement annotationType) {
        return SimpleAnnotationMirror.of(annotationType, ImmutableMap.of());
    }

    public static AnnotationMirror of(TypeElement annotationType, Map<String, ? extends AnnotationValue> namedValues) {
        return new SimpleAnnotationMirror(annotationType, namedValues);
    }

    @Override
    public DeclaredType getAnnotationType() {
        return MoreTypes.asDeclared(this.annotationType.asType());
    }

    public Map<ExecutableElement, ? extends AnnotationValue> getElementValues() {
        return this.elementValues;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("@").append(this.annotationType.getQualifiedName());
        if (!this.namedValues.isEmpty()) {
            builder.append('(').append(Joiner.on(", ").withKeyValueSeparator(" = ").join(this.namedValues)).append(')');
        }
        return builder.toString();
    }

    public boolean equals(Object other) {
        return other instanceof AnnotationMirror && AnnotationMirrors.equivalence().equivalent(this, (AnnotationMirror)other);
    }

    public int hashCode() {
        return AnnotationMirrors.equivalence().hash(this);
    }
}

