/*
 * Decompiled with CFR 0.152.
 */
package dominojackson.shaded.org.dominokit.domino.apt.commons;

import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.StringTokenizer;

public class FullClassName {
    private final String completeClassName;

    public FullClassName(String completeClassName) {
        if (Objects.isNull(completeClassName) || completeClassName.trim().isEmpty()) {
            throw new InvalidClassName();
        }
        this.completeClassName = completeClassName.trim().replace(" ", "");
    }

    public String asSimpleName() {
        return this.getSimpleName(this.simpleFullName());
    }

    private String getSimpleName(String name) {
        return name.substring(name.lastIndexOf(46) + 1);
    }

    public String asPackage() {
        return this.getPackage(this.simpleFullName());
    }

    private String getPackage(String name) {
        return name.substring(0, name.lastIndexOf(46) > -1 ? name.lastIndexOf(46) : 0);
    }

    private String simpleFullName() {
        return new StringTokenizer(this.completeClassName, "<,>").nextToken();
    }

    public String asImport() {
        return this.simpleFullName();
    }

    public String asSimpleGenericName() {
        String result = this.completeClassName;
        StringTokenizer st = new StringTokenizer(this.completeClassName, "<,>");
        while (st.hasMoreTokens()) {
            result = result.replace(this.appendDot(new FullClassName(st.nextToken()).asPackage()), "");
        }
        return result;
    }

    private String appendDot(String part) {
        return part.isEmpty() ? part : this.dottedPart(part);
    }

    private String dottedPart(String part) {
        return part.endsWith(".") ? part : part + ".";
    }

    public List<String> allImports() {
        StringTokenizer st = new StringTokenizer(this.completeClassName, "<,>");
        LinkedList<String> imports = new LinkedList<String>();
        while (st.hasMoreTokens()) {
            String s2 = new FullClassName(st.nextToken()).asImport();
            if (imports.contains(s2)) continue;
            imports.add(s2);
        }
        return imports;
    }

    public static class InvalidClassName
    extends RuntimeException {
    }
}

