/*
 * Decompiled with CFR 0.152.
 */
package org.dominokit.jackson.processor;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import dominojackson.shaded.com.squareup.javapoet.ClassName;
import dominojackson.shaded.com.squareup.javapoet.CodeBlock;
import dominojackson.shaded.com.squareup.javapoet.FieldSpec;
import dominojackson.shaded.com.squareup.javapoet.JavaFile;
import dominojackson.shaded.com.squareup.javapoet.MethodSpec;
import dominojackson.shaded.com.squareup.javapoet.ParameterizedTypeName;
import dominojackson.shaded.com.squareup.javapoet.TypeName;
import dominojackson.shaded.com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.dominokit.jackson.processor.ObjectMapperProcessor;
import org.dominokit.jackson.processor.SubTypesInfo;
import org.dominokit.jackson.processor.Type;

public abstract class AbstractJsonMapperGenerator {
    protected final TypeMirror beanType;
    protected final SubTypesInfo subTypesInfo;
    protected final String packageName;
    private final Filer filer;

    public AbstractJsonMapperGenerator(String packageName, TypeMirror beanType, Filer filer) {
        this.beanType = beanType;
        this.subTypesInfo = Type.getSubTypes(beanType);
        this.packageName = packageName;
        this.filer = filer;
    }

    protected void generate() throws IOException {
        String classNameString = Type.stringifyType(this.beanType) + this.namePostfix();
        FieldSpec instance = FieldSpec.builder(ClassName.bestGuess(classNameString), "INSTANCE", new Modifier[0]).addModifiers(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL).initializer(CodeBlock.builder().add("new $T()", ClassName.bestGuess(classNameString)).build()).build();
        MethodSpec getInstanceMethod = MethodSpec.methodBuilder("getInstance").addModifiers(Modifier.PUBLIC, Modifier.STATIC).returns(ClassName.bestGuess(classNameString)).addStatement("return INSTANCE", new Object[0]).build();
        MethodSpec constructor = MethodSpec.constructorBuilder().addModifiers(Modifier.PUBLIC).build();
        TypeSpec.Builder builder = TypeSpec.classBuilder(classNameString).addModifiers(Modifier.PUBLIC, Modifier.FINAL).superclass(this.superClass()).addField(instance).addMethod(getInstanceMethod).addMethod(constructor).addMethod(this.targetTypeMethod());
        this.moreMethods().forEach(builder::addMethod);
        Optional<MethodSpec> initMethod = this.initMethod();
        initMethod.ifPresent(builder::addMethod);
        if (this.subTypesInfo.hasSubTypes()) {
            builder.addMethod(this.buildInitTypeInfoMethod());
            builder.addMethod(this.initSubtypesMethod());
        }
        JavaFile.builder(this.packageName, builder.build()).build().writeTo(this.filer);
    }

    private MethodSpec targetTypeMethod() {
        return MethodSpec.methodBuilder(this.targetTypeMethodName()).addModifiers(Modifier.PUBLIC).addAnnotation(Override.class).returns(ClassName.get(Class.class)).addStatement("return $T.class", TypeName.get(ObjectMapperProcessor.typeUtils.erasure(this.beanType))).build();
    }

    protected abstract TypeName superClass();

    protected abstract String namePostfix();

    protected abstract String targetTypeMethodName();

    protected Set<MethodSpec> moreMethods() {
        return Collections.emptySet();
    }

    protected abstract Optional<MethodSpec> initMethod();

    protected abstract MethodSpec initSubtypesMethod();

    protected Map<Element, TypeMirror> orderedFields() {
        return this.beanType.getKind() == TypeKind.DECLARED ? this.getOrderedFields((DeclaredType)this.beanType) : Collections.emptyMap();
    }

    private Map<Element, TypeMirror> getOrderedFields(DeclaredType enclosingType) {
        TypeElement enclosingElement = (TypeElement)enclosingType.asElement();
        TypeMirror superclass = enclosingElement.getSuperclass();
        if (superclass.getKind().equals((Object)TypeKind.NONE)) {
            return new HashMap<Element, TypeMirror>();
        }
        ArrayList orderedProperties = new ArrayList();
        List enclosedFields = enclosingElement.getEnclosedElements().stream().filter(e -> ElementKind.FIELD.equals((Object)e.getKind()) && this.isEligibleForSerializationDeserialization((Element)e)).collect(Collectors.toList());
        Optional.ofNullable(ObjectMapperProcessor.typeUtils.asElement(this.beanType).getAnnotation(JsonPropertyOrder.class)).ifPresent(jsonPropertyOrder -> {
            List<String> orderedFieldsNames = Arrays.asList(jsonPropertyOrder.value());
            orderedProperties.addAll(enclosedFields.stream().filter(f -> orderedFieldsNames.contains(f.getSimpleName().toString())).collect(Collectors.toList()));
            enclosedFields.removeAll(orderedProperties);
            if (jsonPropertyOrder.alphabetic()) {
                enclosedFields.sort(Comparator.comparing(f -> f.getSimpleName().toString()));
            }
            enclosedFields.addAll(0, orderedProperties);
        });
        List<? extends TypeParameterElement> typeParameters = enclosingElement.getTypeParameters();
        List<? extends TypeMirror> typeArguments = enclosingType.getTypeArguments();
        Map<TypeParameterElement, TypeMirror> typeParameterMap = IntStream.range(0, typeParameters.size()).boxed().collect(Collectors.toMap(typeParameters::get, typeArguments::get));
        Map res = enclosedFields.stream().collect(Collectors.toMap(fieldElement -> fieldElement, fieldElement -> Type.getDeclaredType(fieldElement.asType(), typeParameterMap), (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        }, LinkedHashMap::new));
        if (superclass.getKind() == TypeKind.DECLARED) {
            res.putAll(this.getOrderedFields((DeclaredType)Type.getDeclaredType(superclass, typeParameterMap)));
        }
        return res;
    }

    protected boolean isNotStatic(Element field) {
        return !field.getModifiers().contains((Object)Modifier.STATIC);
    }

    protected boolean isIgnored(Element field) {
        JsonIgnore annotation = field.getAnnotation(JsonIgnore.class);
        return Objects.nonNull(annotation) && annotation.value();
    }

    protected boolean isEligibleForSerializationDeserialization(Element field) {
        return this.isNotStatic(field) && !this.isIgnored(field);
    }

    public boolean isAbstract(TypeMirror beanType) {
        return ObjectMapperProcessor.typeUtils.asElement(beanType).getModifiers().contains((Object)Modifier.ABSTRACT);
    }

    protected abstract Class<?> getMapperType();

    protected final CodeBlock generateTypeInfo() {
        Class<?> type = this.getMapperType();
        CodeBlock.Builder builder = CodeBlock.builder().add("new $T($T.$L, $S)", type, JsonTypeInfo.As.class, this.subTypesInfo.getInclude(), this.subTypesInfo.getPropertyName()).indent().indent();
        for (Map.Entry<String, TypeMirror> entry : this.subTypesInfo.getSubTypes().entrySet()) {
            builder.add("\n.addTypeInfo($T.class, $S)", entry.getValue(), entry.getKey());
        }
        return builder.unindent().unindent().build();
    }

    private MethodSpec buildInitTypeInfoMethod() {
        Class<?> type = this.getMapperType();
        return MethodSpec.methodBuilder("initTypeInfo").addModifiers(Modifier.PROTECTED).addAnnotation(Override.class).returns(ParameterizedTypeName.get(ClassName.get(type), TypeName.get(this.beanType))).addStatement("return $L", this.generateTypeInfo()).build();
    }

    public static class AccessorInfo {
        public Optional<ExecutableElement> method;
        private String name;

        public AccessorInfo(Optional<ExecutableElement> method) {
            this.method = method;
        }

        public AccessorInfo(String name) {
            this.name = name;
            this.method = Optional.empty();
        }

        public String getName() {
            if (this.method.isPresent()) {
                return this.method.get().getSimpleName().toString();
            }
            return this.name;
        }
    }
}

