/*
 * Decompiled with CFR 0.152.
 */
package org.dominokit.jackson.processor;

import dominojackson.shaded.com.google.auto.common.MoreElements;
import dominojackson.shaded.com.google.auto.common.MoreTypes;
import dominojackson.shaded.com.squareup.javapoet.ClassName;
import dominojackson.shaded.com.squareup.javapoet.CodeBlock;
import dominojackson.shaded.com.squareup.javapoet.FieldSpec;
import dominojackson.shaded.com.squareup.javapoet.JavaFile;
import dominojackson.shaded.com.squareup.javapoet.MethodSpec;
import dominojackson.shaded.com.squareup.javapoet.ParameterizedTypeName;
import dominojackson.shaded.com.squareup.javapoet.TypeName;
import dominojackson.shaded.com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.dominokit.jackson.JsonDeserializer;
import org.dominokit.jackson.JsonSerializer;
import org.dominokit.jackson.ObjectMapper;
import org.dominokit.jackson.ObjectReader;
import org.dominokit.jackson.ObjectWriter;
import org.dominokit.jackson.processor.AbstractMapperProcessor;
import org.dominokit.jackson.processor.MapperGenerator;
import org.dominokit.jackson.processor.ObjectMapperProcessor;
import org.dominokit.jackson.processor.Type;
import org.dominokit.jackson.processor.deserialization.FieldDeserializersChainBuilder;
import org.dominokit.jackson.processor.serialization.FieldSerializerChainBuilder;

public abstract class AbstractMapperGenerator
implements MapperGenerator {
    private String packageName;

    @Override
    public void generate(Element element) throws IOException {
        String className = this.enclosingName(element, "_") + (AbstractMapperGenerator.useInterface(element) ? element.getSimpleName() : "Mapper") + "Impl";
        this.packageName = MoreElements.getPackage(element).getQualifiedName().toString();
        TypeMirror beanType = AbstractMapperGenerator.getElementType(element);
        Name beanName = AbstractMapperProcessor.typeUtils.asElement(beanType).getSimpleName();
        this.generateJsonMappers(beanType);
        TypeSpec.Builder builder = TypeSpec.classBuilder(className).addModifiers(Modifier.PUBLIC, Modifier.FINAL).superclass(this.abstractObjectMapper(element)).addField(FieldSpec.builder(ClassName.bestGuess(className), "INSTANCE", new Modifier[0]).addModifiers(Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL).initializer(CodeBlock.builder().add("new $T()", ClassName.bestGuess(className)).build()).build()).addMethod(this.makeConstructor(beanName)).addMethods(this.getMapperMethods(element, beanType));
        if (AbstractMapperGenerator.useInterface(element)) {
            builder.addSuperinterface(TypeName.get(element.asType()));
        }
        TypeSpec classSpec = builder.build();
        JavaFile.builder(this.packageName, classSpec).build().writeTo(AbstractMapperProcessor.filer);
    }

    protected static TypeMirror getElementType(Element element) {
        if (AbstractMapperGenerator.useInterface(element)) {
            TypeMirror objectReader = ((TypeElement)AbstractMapperProcessor.typeUtils.asElement(element.asType())).getInterfaces().get(0);
            return MoreTypes.asDeclared(objectReader).getTypeArguments().get(0);
        }
        return element.asType();
    }

    protected static boolean useInterface(Element element) {
        return Type.isAssignableFrom(element.asType(), ObjectMapper.class) || Type.isAssignableFrom(element.asType(), ObjectReader.class) || Type.isAssignableFrom(element.asType(), ObjectWriter.class);
    }

    protected String enclosingName(Element element, String postfix) {
        Element enclosingElement = element.getEnclosingElement();
        if (AbstractMapperGenerator.useInterface(element) && !ElementKind.PACKAGE.equals((Object)enclosingElement.getKind())) {
            return enclosingElement.getSimpleName().toString() + postfix;
        }
        if (AbstractMapperGenerator.useInterface(element) && ElementKind.PACKAGE.equals((Object)enclosingElement.getKind())) {
            return "";
        }
        String prefix = element.getEnclosingElement().getKind().equals((Object)ElementKind.PACKAGE) ? "" : element.getEnclosingElement().getSimpleName().toString() + "_";
        return prefix + element.getSimpleName().toString() + postfix;
    }

    protected TypeName abstractObjectMapper(Element element) {
        TypeMirror beanType = AbstractMapperGenerator.getElementType(element);
        return ParameterizedTypeName.get(ClassName.get(this.getSuperClass()), ClassName.get(beanType));
    }

    protected MethodSpec makeConstructor(Name beanName) {
        return MethodSpec.constructorBuilder().addModifiers(Modifier.PUBLIC).addStatement("super(\"" + beanName + "\")", new Object[0]).build();
    }

    protected MethodSpec makeNewDeserializerMethod(Element element, TypeMirror beanType) {
        CodeBlock.Builder builder = CodeBlock.builder();
        if (Type.isBasicType(AbstractMapperProcessor.typeUtils.erasure(beanType))) {
            builder.addStatement("return $L", new FieldDeserializersChainBuilder(AbstractMapperGenerator.getElementType(element)).getInstance(AbstractMapperGenerator.getElementType(element)));
        } else {
            builder.addStatement("return $T.getInstance()", ClassName.bestGuess(AbstractMapperProcessor.elementUtils.getPackageOf(AbstractMapperProcessor.typeUtils.asElement(beanType)).getQualifiedName().toString() + "." + this.deserializerName(beanType)));
        }
        return MethodSpec.methodBuilder("newDeserializer").addModifiers(Modifier.PROTECTED).addAnnotation(Override.class).returns(ParameterizedTypeName.get(ClassName.get(JsonDeserializer.class), ClassName.get(AbstractMapperGenerator.getElementType(element)))).addCode(builder.build()).build();
    }

    protected MethodSpec makeNewSerializerMethod(TypeMirror beanType) {
        CodeBlock.Builder builder = CodeBlock.builder();
        if (Type.isBasicType(AbstractMapperProcessor.typeUtils.erasure(beanType))) {
            builder.addStatement("return $L", new FieldSerializerChainBuilder(beanType).getInstance(beanType));
        } else {
            builder.addStatement("return $T.getInstance()", ClassName.bestGuess(AbstractMapperProcessor.elementUtils.getPackageOf(AbstractMapperProcessor.typeUtils.asElement(beanType)).getQualifiedName().toString() + "." + this.serializerName(beanType)));
        }
        return MethodSpec.methodBuilder("newSerializer").addModifiers(Modifier.PROTECTED).addAnnotation(Override.class).returns(ParameterizedTypeName.get(ClassName.get(JsonSerializer.class), ObjectMapperProcessor.DEFAULT_WILDCARD)).addCode(builder.build()).build();
    }

    private String deserializerName(TypeMirror type) {
        return Type.stringifyType(type) + "BeanJsonDeserializerImpl";
    }

    private String serializerName(TypeMirror type) {
        return Type.stringifyType(type) + "BeanJsonSerializerImpl";
    }

    protected abstract Class<?> getSuperClass();

    protected abstract Iterable<MethodSpec> getMapperMethods(Element var1, TypeMirror var2);

    private void generateJsonMappers(TypeMirror beanType) {
        if (Type.hasWildcards(beanType) || Type.hasTypeParameter(beanType)) {
            throw new IllegalArgumentException("Can not create mapper for type with wildcards or type parameters");
        }
        if (beanType.getKind() == TypeKind.DECLARED && !Type.isBasicType(AbstractMapperProcessor.typeUtils.erasure(beanType))) {
            this.generateDeserializer(beanType);
            this.generateSerializer(beanType);
        }
    }

    protected void generateSerializer(TypeMirror beanType) {
    }

    protected void generateDeserializer(TypeMirror beanType) {
    }
}

