/*
 * Decompiled with CFR 0.152.
 */
package org.dominokit.jackson.processor;

import dominojackson.shaded.com.google.auto.common.MoreElements;
import dominojackson.shaded.com.google.auto.common.MoreTypes;
import dominojackson.shaded.com.squareup.javapoet.ClassName;
import java.io.IOException;
import java.util.Map;
import javax.lang.model.type.TypeMirror;
import org.dominokit.jackson.processor.ObjectMapperProcessor;
import org.dominokit.jackson.processor.SubTypesInfo;
import org.dominokit.jackson.processor.Type;
import org.dominokit.jackson.processor.TypeRegistry;
import org.dominokit.jackson.processor.deserialization.AptDeserializerBuilder;

public class DeserializerGenerator {
    public String generate(TypeMirror beanType) {
        String packageName = MoreElements.getPackage(MoreTypes.asTypeElement(beanType)).getQualifiedName().toString();
        String deserializerName = Type.deserializerName(packageName, beanType);
        if (!TypeRegistry.containsDeserializer(Type.stringifyTypeWithPackage(beanType))) {
            try {
                this.generateSubTypesDeserializers(beanType);
                TypeRegistry.addInActiveGenDeserializer(beanType);
                new AptDeserializerBuilder(packageName, beanType, ObjectMapperProcessor.filer).generate();
                TypeRegistry.registerDeserializer(Type.stringifyTypeWithPackage(beanType), ClassName.bestGuess(deserializerName));
                TypeRegistry.removeInActiveGenDeserializer(beanType);
            }
            catch (IOException e) {
                throw new DeserializerGenerationFailedException(beanType.toString());
            }
        }
        return deserializerName;
    }

    private void generateSubTypesDeserializers(TypeMirror beanType) {
        SubTypesInfo subTypesInfo = Type.getSubTypes(beanType);
        for (Map.Entry<String, TypeMirror> subtypeEntry : subTypesInfo.getSubTypes().entrySet()) {
            new DeserializerGenerator().generate(subtypeEntry.getValue());
        }
    }

    private class DeserializerGenerationFailedException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        DeserializerGenerationFailedException(String type) {
            super(type);
        }
    }
}

