/*
 * Decompiled with CFR 0.152.
 */
package org.dominokit.jackson.processor;

import dominojackson.shaded.com.google.auto.common.MoreElements;
import dominojackson.shaded.com.google.auto.common.MoreTypes;
import dominojackson.shaded.com.squareup.javapoet.ClassName;
import java.io.IOException;
import java.util.Map;
import javax.lang.model.type.TypeMirror;
import org.dominokit.jackson.processor.ObjectMapperProcessor;
import org.dominokit.jackson.processor.SubTypesInfo;
import org.dominokit.jackson.processor.Type;
import org.dominokit.jackson.processor.TypeRegistry;
import org.dominokit.jackson.processor.serialization.AptSerializerBuilder;

public class SerializerGenerator {
    public String generate(TypeMirror beanType) {
        String packageName = MoreElements.getPackage(MoreTypes.asTypeElement(beanType)).getQualifiedName().toString();
        String serializerName = Type.serializerName(packageName, beanType);
        if (!TypeRegistry.containsSerializer(Type.stringifyTypeWithPackage(beanType))) {
            try {
                this.generateSubTypeSerializers(beanType);
                TypeRegistry.addInActiveGenSerializer(beanType);
                new AptSerializerBuilder(packageName, beanType, ObjectMapperProcessor.filer).generate();
                TypeRegistry.registerSerializer(Type.stringifyTypeWithPackage(beanType), ClassName.bestGuess(serializerName));
                TypeRegistry.removeInActiveGenSerializer(beanType);
            }
            catch (IOException e) {
                throw new SerializerGenerationFailedException(beanType.toString());
            }
        }
        return serializerName;
    }

    private void generateSubTypeSerializers(TypeMirror beanType) {
        SubTypesInfo subTypesInfo = Type.getSubTypes(beanType);
        for (Map.Entry<String, TypeMirror> subtypeEntry : subTypesInfo.getSubTypes().entrySet()) {
            new SerializerGenerator().generate(subtypeEntry.getValue());
        }
    }

    private class SerializerGenerationFailedException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        SerializerGenerationFailedException(String type) {
            super(type);
        }
    }
}

