/*
 * Decompiled with CFR 0.152.
 */
package org.dominokit.jackson.processor;

import dominojackson.shaded.com.squareup.javapoet.TypeName;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractQueue;
import java.util.AbstractSequentialList;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.Vector;
import javax.lang.model.type.TypeMirror;
import org.dominokit.jackson.deser.BaseDateJsonDeserializer;
import org.dominokit.jackson.deser.BaseNumberJsonDeserializer;
import org.dominokit.jackson.deser.BooleanJsonDeserializer;
import org.dominokit.jackson.deser.CharacterJsonDeserializer;
import org.dominokit.jackson.deser.EnumJsonDeserializer;
import org.dominokit.jackson.deser.StringJsonDeserializer;
import org.dominokit.jackson.deser.UUIDJsonDeserializer;
import org.dominokit.jackson.deser.VoidJsonDeserializer;
import org.dominokit.jackson.deser.array.PrimitiveBooleanArrayJsonDeserializer;
import org.dominokit.jackson.deser.array.PrimitiveByteArrayJsonDeserializer;
import org.dominokit.jackson.deser.array.PrimitiveCharacterArrayJsonDeserializer;
import org.dominokit.jackson.deser.array.PrimitiveDoubleArrayJsonDeserializer;
import org.dominokit.jackson.deser.array.PrimitiveFloatArrayJsonDeserializer;
import org.dominokit.jackson.deser.array.PrimitiveIntegerArrayJsonDeserializer;
import org.dominokit.jackson.deser.array.PrimitiveLongArrayJsonDeserializer;
import org.dominokit.jackson.deser.array.PrimitiveShortArrayJsonDeserializer;
import org.dominokit.jackson.deser.array.dd.Array2dJsonDeserializer;
import org.dominokit.jackson.deser.array.dd.PrimitiveBooleanArray2dJsonDeserializer;
import org.dominokit.jackson.deser.array.dd.PrimitiveByteArray2dJsonDeserializer;
import org.dominokit.jackson.deser.array.dd.PrimitiveCharacterArray2dJsonDeserializer;
import org.dominokit.jackson.deser.array.dd.PrimitiveDoubleArray2dJsonDeserializer;
import org.dominokit.jackson.deser.array.dd.PrimitiveFloatArray2dJsonDeserializer;
import org.dominokit.jackson.deser.array.dd.PrimitiveIntegerArray2dJsonDeserializer;
import org.dominokit.jackson.deser.array.dd.PrimitiveLongArray2dJsonDeserializer;
import org.dominokit.jackson.deser.array.dd.PrimitiveShortArray2dJsonDeserializer;
import org.dominokit.jackson.deser.collection.AbstractCollectionJsonDeserializer;
import org.dominokit.jackson.deser.collection.AbstractListJsonDeserializer;
import org.dominokit.jackson.deser.collection.AbstractQueueJsonDeserializer;
import org.dominokit.jackson.deser.collection.AbstractSequentialListJsonDeserializer;
import org.dominokit.jackson.deser.collection.AbstractSetJsonDeserializer;
import org.dominokit.jackson.deser.collection.ArrayListJsonDeserializer;
import org.dominokit.jackson.deser.collection.CollectionJsonDeserializer;
import org.dominokit.jackson.deser.collection.EnumSetJsonDeserializer;
import org.dominokit.jackson.deser.collection.HashSetJsonDeserializer;
import org.dominokit.jackson.deser.collection.IterableJsonDeserializer;
import org.dominokit.jackson.deser.collection.LinkedHashSetJsonDeserializer;
import org.dominokit.jackson.deser.collection.LinkedListJsonDeserializer;
import org.dominokit.jackson.deser.collection.ListJsonDeserializer;
import org.dominokit.jackson.deser.collection.PriorityQueueJsonDeserializer;
import org.dominokit.jackson.deser.collection.QueueJsonDeserializer;
import org.dominokit.jackson.deser.collection.SetJsonDeserializer;
import org.dominokit.jackson.deser.collection.SortedSetJsonDeserializer;
import org.dominokit.jackson.deser.collection.StackJsonDeserializer;
import org.dominokit.jackson.deser.collection.TreeSetJsonDeserializer;
import org.dominokit.jackson.deser.collection.VectorJsonDeserializer;
import org.dominokit.jackson.deser.map.AbstractMapJsonDeserializer;
import org.dominokit.jackson.deser.map.EnumMapJsonDeserializer;
import org.dominokit.jackson.deser.map.HashMapJsonDeserializer;
import org.dominokit.jackson.deser.map.IdentityHashMapJsonDeserializer;
import org.dominokit.jackson.deser.map.LinkedHashMapJsonDeserializer;
import org.dominokit.jackson.deser.map.MapJsonDeserializer;
import org.dominokit.jackson.deser.map.SortedMapJsonDeserializer;
import org.dominokit.jackson.deser.map.TreeMapJsonDeserializer;
import org.dominokit.jackson.deser.map.key.BaseDateKeyDeserializer;
import org.dominokit.jackson.deser.map.key.BaseNumberKeyDeserializer;
import org.dominokit.jackson.deser.map.key.BooleanKeyDeserializer;
import org.dominokit.jackson.deser.map.key.CharacterKeyDeserializer;
import org.dominokit.jackson.deser.map.key.EnumKeyDeserializer;
import org.dominokit.jackson.deser.map.key.StringKeyDeserializer;
import org.dominokit.jackson.deser.map.key.UUIDKeyDeserializer;
import org.dominokit.jackson.processor.ObjectMapperProcessor;
import org.dominokit.jackson.processor.Type;
import org.dominokit.jackson.ser.BaseDateJsonSerializer;
import org.dominokit.jackson.ser.BaseNumberJsonSerializer;
import org.dominokit.jackson.ser.BooleanJsonSerializer;
import org.dominokit.jackson.ser.CharacterJsonSerializer;
import org.dominokit.jackson.ser.CollectionJsonSerializer;
import org.dominokit.jackson.ser.EnumJsonSerializer;
import org.dominokit.jackson.ser.IterableJsonSerializer;
import org.dominokit.jackson.ser.StringJsonSerializer;
import org.dominokit.jackson.ser.UUIDJsonSerializer;
import org.dominokit.jackson.ser.VoidJsonSerializer;
import org.dominokit.jackson.ser.array.ArrayJsonSerializer;
import org.dominokit.jackson.ser.array.PrimitiveBooleanArrayJsonSerializer;
import org.dominokit.jackson.ser.array.PrimitiveByteArrayJsonSerializer;
import org.dominokit.jackson.ser.array.PrimitiveCharacterArrayJsonSerializer;
import org.dominokit.jackson.ser.array.PrimitiveDoubleArrayJsonSerializer;
import org.dominokit.jackson.ser.array.PrimitiveFloatArrayJsonSerializer;
import org.dominokit.jackson.ser.array.PrimitiveIntegerArrayJsonSerializer;
import org.dominokit.jackson.ser.array.PrimitiveLongArrayJsonSerializer;
import org.dominokit.jackson.ser.array.PrimitiveShortArrayJsonSerializer;
import org.dominokit.jackson.ser.array.dd.Array2dJsonSerializer;
import org.dominokit.jackson.ser.array.dd.PrimitiveBooleanArray2dJsonSerializer;
import org.dominokit.jackson.ser.array.dd.PrimitiveByteArray2dJsonSerializer;
import org.dominokit.jackson.ser.array.dd.PrimitiveCharacterArray2dJsonSerializer;
import org.dominokit.jackson.ser.array.dd.PrimitiveDoubleArray2dJsonSerializer;
import org.dominokit.jackson.ser.array.dd.PrimitiveFloatArray2dJsonSerializer;
import org.dominokit.jackson.ser.array.dd.PrimitiveIntegerArray2dJsonSerializer;
import org.dominokit.jackson.ser.array.dd.PrimitiveLongArray2dJsonSerializer;
import org.dominokit.jackson.ser.array.dd.PrimitiveShortArray2dJsonSerializer;
import org.dominokit.jackson.ser.map.MapJsonSerializer;
import org.dominokit.jackson.ser.map.key.BooleanKeySerializer;
import org.dominokit.jackson.ser.map.key.DateKeySerializer;
import org.dominokit.jackson.ser.map.key.EnumKeySerializer;
import org.dominokit.jackson.ser.map.key.NumberKeySerializer;
import org.dominokit.jackson.ser.map.key.ObjectKeySerializer;
import org.dominokit.jackson.ser.map.key.ToStringKeySerializer;
import org.dominokit.jackson.ser.map.key.UUIDKeySerializer;

public final class TypeRegistry {
    private static Map<String, ClassMapper> simpleTypes = new HashMap<String, ClassMapper>();
    private static Map<String, ClassMapper> keysMappers = new HashMap<String, ClassMapper>();
    private static Map<String, Class> collectionsDeserializers = new HashMap<String, Class>();
    private static Map<String, Class> mapDeserializers = new HashMap<String, Class>();
    private static Map<String, ClassMapper> customMappers = new HashMap<String, ClassMapper>();
    private static Set<String> inActiveGenSerializers = new HashSet<String>();
    private static Set<String> inActiveGenDeserializers = new HashSet<String>();
    static final ClassMapperFactory MAPPER = new ClassMapperFactory();

    public static void resetTypeRegistry() {
        customMappers.clear();
    }

    public static void register(ClassMapper mapper) {
        mapper.register(TypeRegistry.simpleTypes);
    }

    public static boolean isBasicType(String type) {
        return simpleTypes.containsKey(type);
    }

    public static void registerSerializer(String type, TypeName serializer) {
        if (customMappers.containsKey(type)) {
            customMappers.get(type).serializer = serializer;
        } else {
            ClassMapper classMapper = new ClassMapper(type);
            classMapper.serializer = serializer;
            customMappers.put(type, classMapper);
        }
    }

    public static void registerDeserializer(String type, TypeName deserializer) {
        if (customMappers.containsKey(type)) {
            customMappers.get(type).deserializer = deserializer;
        } else {
            ClassMapper classMapper = new ClassMapper(type);
            classMapper.deserializer = deserializer;
            customMappers.put(type, classMapper);
        }
    }

    public static TypeName getCustomSerializer(TypeMirror typeMirror) {
        return TypeRegistry.getCustomSerializer(Type.stringifyTypeWithPackage(typeMirror));
    }

    public static TypeName getCustomSerializer(String type) {
        if (TypeRegistry.containsSerializer(type)) {
            return customMappers.get(type).serializer;
        }
        throw new TypeSerializerNotFoundException(type);
    }

    public static TypeName getCustomDeserializer(TypeMirror typeMirror) {
        return TypeRegistry.getCustomDeserializer(Type.stringifyTypeWithPackage(typeMirror));
    }

    public static TypeName getCustomDeserializer(String type) {
        if (TypeRegistry.containsDeserializer(type)) {
            return customMappers.get(type).deserializer;
        }
        throw new TypeDeserializerNotFoundException(type);
    }

    public static ClassMapper get(String typeName) {
        return simpleTypes.get(typeName);
    }

    public static TypeName getSerializer(TypeMirror typeMirror) {
        return TypeRegistry.getSerializer(Type.stringifyTypeWithPackage(typeMirror));
    }

    private static TypeName getSerializer(String typeName) {
        if (simpleTypes.containsKey(typeName)) {
            return TypeRegistry.get(typeName).serializer;
        }
        throw new TypeSerializerNotFoundException(typeName);
    }

    public static TypeName getKeySerializer(String typeName) {
        if (keysMappers.containsKey(typeName)) {
            return keysMappers.get(typeName).serializer;
        }
        throw new TypeSerializerNotFoundException(typeName);
    }

    public static TypeName getKeyDeserializer(String typeName) {
        if (keysMappers.containsKey(typeName)) {
            return keysMappers.get(typeName).deserializer;
        }
        throw new TypeDeserializerNotFoundException(typeName);
    }

    public static TypeName getDeserializer(TypeMirror typeMirror) {
        return TypeRegistry.getDeserializer(Type.stringifyTypeWithPackage(typeMirror));
    }

    private static TypeName getDeserializer(String typeName) {
        if (simpleTypes.containsKey(typeName)) {
            return simpleTypes.get(typeName).deserializer;
        }
        throw new TypeDeserializerNotFoundException(typeName);
    }

    public static Class<?> getCollectionDeserializer(TypeMirror typeMirror) {
        return TypeRegistry.getCollectionDeserializer(TypeRegistry.asNoneGeneric(typeMirror));
    }

    private static String asNoneGeneric(TypeMirror type) {
        return ObjectMapperProcessor.typeUtils.asElement(type).toString().replace("<E>", "");
    }

    private static Class<?> getCollectionDeserializer(String collectionType) {
        if (collectionsDeserializers.containsKey(collectionType)) {
            return collectionsDeserializers.get(collectionType);
        }
        throw new TypeDeserializerNotFoundException(collectionType);
    }

    public static Class<?> getMapDeserializer(TypeMirror typeMirror) {
        return TypeRegistry.getMapDeserializer(TypeRegistry.asNoneGeneric(typeMirror));
    }

    private static Class<?> getMapDeserializer(String mapType) {
        if (mapDeserializers.containsKey(mapType)) {
            return mapDeserializers.get(mapType);
        }
        throw new TypeDeserializerNotFoundException(mapType);
    }

    public static boolean containsDeserializer(String typeName) {
        return Objects.nonNull(customMappers.get(typeName)) && Objects.nonNull(customMappers.get(typeName).deserializer);
    }

    public static boolean containsSerializer(String typeName) {
        return Objects.nonNull(customMappers.get(typeName)) && Objects.nonNull(customMappers.get(typeName).serializer);
    }

    public static boolean containsSerializer(TypeMirror typeMirror) {
        return TypeRegistry.containsSerializer(Type.stringifyTypeWithPackage(typeMirror));
    }

    public static boolean containsDeserializer(TypeMirror typeMirror) {
        return TypeRegistry.containsDeserializer(Type.stringifyTypeWithPackage(typeMirror));
    }

    public static void addInActiveGenSerializer(TypeMirror typeMirror) {
        inActiveGenSerializers.add(Type.stringifyTypeWithPackage(typeMirror));
    }

    public static void addInActiveGenDeserializer(TypeMirror typeMirror) {
        inActiveGenDeserializers.add(Type.stringifyTypeWithPackage(typeMirror));
    }

    public static void removeInActiveGenSerializer(TypeMirror typeMirror) {
        inActiveGenSerializers.remove(Type.stringifyTypeWithPackage(typeMirror));
    }

    public static void removeInActiveGenDeserializer(TypeMirror typeMirror) {
        inActiveGenDeserializers.remove(Type.stringifyTypeWithPackage(typeMirror));
    }

    public static boolean isInActiveGenSerializer(TypeMirror typeMirror) {
        return inActiveGenSerializers.contains(Type.stringifyTypeWithPackage(typeMirror));
    }

    public static boolean isInActiveGenDeserializer(TypeMirror typeMirror) {
        return inActiveGenDeserializers.contains(Type.stringifyTypeWithPackage(typeMirror));
    }

    static {
        TypeRegistry.MAPPER.forType(Boolean.TYPE).serializer(BooleanJsonSerializer.class).deserializer(BooleanJsonDeserializer.class).register(TypeRegistry.simpleTypes);
        TypeRegistry.MAPPER.forType(Character.TYPE).serializer(CharacterJsonSerializer.class).deserializer(CharacterJsonDeserializer.class).register(TypeRegistry.simpleTypes);
        TypeRegistry.MAPPER.forType(Byte.TYPE).serializer(BaseNumberJsonSerializer.ByteJsonSerializer.class).deserializer(BaseNumberJsonDeserializer.ByteJsonDeserializer.class).register(TypeRegistry.simpleTypes);
        TypeRegistry.MAPPER.forType(Double.TYPE).serializer(BaseNumberJsonSerializer.DoubleJsonSerializer.class).deserializer(BaseNumberJsonDeserializer.DoubleJsonDeserializer.class).register(TypeRegistry.simpleTypes);
        TypeRegistry.MAPPER.forType(Float.TYPE).serializer(BaseNumberJsonSerializer.FloatJsonSerializer.class).deserializer(BaseNumberJsonDeserializer.FloatJsonDeserializer.class).register(TypeRegistry.simpleTypes);
        TypeRegistry.MAPPER.forType(Integer.TYPE).serializer(BaseNumberJsonSerializer.IntegerJsonSerializer.class).deserializer(BaseNumberJsonDeserializer.IntegerJsonDeserializer.class).register(TypeRegistry.simpleTypes);
        TypeRegistry.MAPPER.forType(Long.TYPE).serializer(BaseNumberJsonSerializer.LongJsonSerializer.class).deserializer(BaseNumberJsonDeserializer.LongJsonDeserializer.class).register(TypeRegistry.simpleTypes);
        TypeRegistry.MAPPER.forType(Short.TYPE).serializer(BaseNumberJsonSerializer.ShortJsonSerializer.class).deserializer(BaseNumberJsonDeserializer.ShortJsonDeserializer.class).register(TypeRegistry.simpleTypes);
        TypeRegistry.MAPPER.forType(String.class).serializer(StringJsonSerializer.class).deserializer(StringJsonDeserializer.class).register(TypeRegistry.simpleTypes);
        TypeRegistry.MAPPER.forType(Boolean.class).serializer(BooleanJsonSerializer.class).deserializer(BooleanJsonDeserializer.class).register(TypeRegistry.simpleTypes);
        TypeRegistry.MAPPER.forType(Character.class).serializer(CharacterJsonSerializer.class).deserializer(CharacterJsonDeserializer.class).register(TypeRegistry.simpleTypes);
        TypeRegistry.MAPPER.forType(UUID.class).serializer(UUIDJsonSerializer.class).deserializer(UUIDJsonDeserializer.class).register(TypeRegistry.simpleTypes);
        TypeRegistry.MAPPER.forType(Void.class).serializer(VoidJsonSerializer.class).deserializer(VoidJsonDeserializer.class).register(TypeRegistry.simpleTypes);
        TypeRegistry.MAPPER.forType(Enum.class).serializer(EnumJsonSerializer.class).deserializer(EnumJsonDeserializer.class).register(TypeRegistry.simpleTypes);
        TypeRegistry.MAPPER.forType(BigDecimal.class).serializer(BaseNumberJsonSerializer.BigDecimalJsonSerializer.class).deserializer(BaseNumberJsonDeserializer.BigDecimalJsonDeserializer.class).register(TypeRegistry.simpleTypes);
        TypeRegistry.MAPPER.forType(BigInteger.class).serializer(BaseNumberJsonSerializer.BigIntegerJsonSerializer.class).deserializer(BaseNumberJsonDeserializer.BigIntegerJsonDeserializer.class).register(TypeRegistry.simpleTypes);
        TypeRegistry.MAPPER.forType(Byte.class).serializer(BaseNumberJsonSerializer.ByteJsonSerializer.class).deserializer(BaseNumberJsonDeserializer.ByteJsonDeserializer.class).register(TypeRegistry.simpleTypes);
        TypeRegistry.MAPPER.forType(Double.class).serializer(BaseNumberJsonSerializer.DoubleJsonSerializer.class).deserializer(BaseNumberJsonDeserializer.DoubleJsonDeserializer.class).register(TypeRegistry.simpleTypes);
        TypeRegistry.MAPPER.forType(Float.class).serializer(BaseNumberJsonSerializer.FloatJsonSerializer.class).deserializer(BaseNumberJsonDeserializer.FloatJsonDeserializer.class).register(TypeRegistry.simpleTypes);
        TypeRegistry.MAPPER.forType(Integer.class).serializer(BaseNumberJsonSerializer.IntegerJsonSerializer.class).deserializer(BaseNumberJsonDeserializer.IntegerJsonDeserializer.class).register(TypeRegistry.simpleTypes);
        TypeRegistry.MAPPER.forType(Long.class).serializer(BaseNumberJsonSerializer.LongJsonSerializer.class).deserializer(BaseNumberJsonDeserializer.LongJsonDeserializer.class).register(TypeRegistry.simpleTypes);
        TypeRegistry.MAPPER.forType(Short.class).serializer(BaseNumberJsonSerializer.ShortJsonSerializer.class).deserializer(BaseNumberJsonDeserializer.ShortJsonDeserializer.class).register(TypeRegistry.simpleTypes);
        TypeRegistry.MAPPER.forType(Number.class).serializer(BaseNumberJsonSerializer.NumberJsonSerializer.class).deserializer(BaseNumberJsonDeserializer.NumberJsonDeserializer.class).register(TypeRegistry.simpleTypes);
        TypeRegistry.MAPPER.forType(Date.class).serializer(BaseDateJsonSerializer.DateJsonSerializer.class).deserializer(BaseDateJsonDeserializer.DateJsonDeserializer.class).register(TypeRegistry.simpleTypes);
        TypeRegistry.MAPPER.forType(java.sql.Date.class).serializer(BaseDateJsonSerializer.SqlDateJsonSerializer.class).deserializer(BaseDateJsonDeserializer.SqlDateJsonDeserializer.class).register(TypeRegistry.simpleTypes);
        TypeRegistry.MAPPER.forType(Time.class).serializer(BaseDateJsonSerializer.SqlTimeJsonSerializer.class).deserializer(BaseDateJsonDeserializer.SqlTimeJsonDeserializer.class).register(TypeRegistry.simpleTypes);
        TypeRegistry.MAPPER.forType(Timestamp.class).serializer(BaseDateJsonSerializer.SqlTimestampJsonSerializer.class).deserializer(BaseDateJsonDeserializer.SqlTimestampJsonDeserializer.class).register(TypeRegistry.simpleTypes);
        TypeRegistry.MAPPER.forType(Iterable.class).serializer(IterableJsonSerializer.class).deserializer(IterableJsonDeserializer.class).register(TypeRegistry.simpleTypes);
        TypeRegistry.MAPPER.forType(Collection.class).serializer(CollectionJsonSerializer.class).deserializer(CollectionJsonDeserializer.class).register(TypeRegistry.simpleTypes);
        TypeRegistry.MAPPER.forType(AbstractCollection.class).serializer(CollectionJsonSerializer.class).deserializer(AbstractCollectionJsonDeserializer.class).register(TypeRegistry.simpleTypes);
        TypeRegistry.MAPPER.forType(AbstractList.class).serializer(CollectionJsonSerializer.class).deserializer(AbstractListJsonDeserializer.class).register(TypeRegistry.simpleTypes);
        TypeRegistry.MAPPER.forType(AbstractQueue.class).serializer(CollectionJsonSerializer.class).deserializer(AbstractQueueJsonDeserializer.class).register(TypeRegistry.simpleTypes);
        TypeRegistry.MAPPER.forType(AbstractSequentialList.class).serializer(CollectionJsonSerializer.class).deserializer(AbstractSequentialListJsonDeserializer.class).register(TypeRegistry.simpleTypes);
        TypeRegistry.MAPPER.forType(AbstractSet.class).serializer(CollectionJsonSerializer.class).deserializer(AbstractSetJsonDeserializer.class).register(TypeRegistry.simpleTypes);
        TypeRegistry.MAPPER.forType(ArrayList.class).serializer(CollectionJsonSerializer.class).deserializer(ArrayListJsonDeserializer.class).register(TypeRegistry.simpleTypes);
        TypeRegistry.MAPPER.forType(EnumSet.class).serializer(CollectionJsonSerializer.class).deserializer(EnumSetJsonDeserializer.class).register(TypeRegistry.simpleTypes);
        TypeRegistry.MAPPER.forType(HashSet.class).serializer(CollectionJsonSerializer.class).deserializer(HashSetJsonDeserializer.class).register(TypeRegistry.simpleTypes);
        TypeRegistry.MAPPER.forType(LinkedHashSet.class).serializer(CollectionJsonSerializer.class).deserializer(LinkedHashSetJsonDeserializer.class).register(TypeRegistry.simpleTypes);
        TypeRegistry.MAPPER.forType(LinkedList.class).serializer(CollectionJsonSerializer.class).deserializer(LinkedListJsonDeserializer.class).register(TypeRegistry.simpleTypes);
        TypeRegistry.MAPPER.forType(List.class).serializer(CollectionJsonSerializer.class).deserializer(ListJsonDeserializer.class).register(TypeRegistry.simpleTypes);
        TypeRegistry.MAPPER.forType(PriorityQueue.class).serializer(CollectionJsonSerializer.class).deserializer(PriorityQueueJsonDeserializer.class).register(TypeRegistry.simpleTypes);
        TypeRegistry.MAPPER.forType(Queue.class).serializer(CollectionJsonSerializer.class).deserializer(QueueJsonDeserializer.class).register(TypeRegistry.simpleTypes);
        TypeRegistry.MAPPER.forType(Set.class).serializer(CollectionJsonSerializer.class).deserializer(SetJsonDeserializer.class).register(TypeRegistry.simpleTypes);
        TypeRegistry.MAPPER.forType(SortedSet.class).serializer(CollectionJsonSerializer.class).deserializer(SortedSetJsonDeserializer.class).register(TypeRegistry.simpleTypes);
        TypeRegistry.MAPPER.forType(Stack.class).serializer(CollectionJsonSerializer.class).deserializer(StackJsonDeserializer.class).register(TypeRegistry.simpleTypes);
        TypeRegistry.MAPPER.forType(TreeSet.class).serializer(CollectionJsonSerializer.class).deserializer(TreeSetJsonDeserializer.class).register(TypeRegistry.simpleTypes);
        TypeRegistry.MAPPER.forType(Vector.class).serializer(CollectionJsonSerializer.class).deserializer(VectorJsonDeserializer.class).register(TypeRegistry.simpleTypes);
        TypeRegistry.MAPPER.forType(Map.class).serializer(MapJsonSerializer.class).deserializer(MapJsonDeserializer.class).register(TypeRegistry.simpleTypes);
        TypeRegistry.MAPPER.forType(AbstractMap.class).serializer(MapJsonSerializer.class).deserializer(AbstractMapJsonDeserializer.class).register(TypeRegistry.simpleTypes);
        TypeRegistry.MAPPER.forType(EnumMap.class).serializer(MapJsonSerializer.class).deserializer(EnumMapJsonDeserializer.class).register(TypeRegistry.simpleTypes);
        TypeRegistry.MAPPER.forType(HashMap.class).serializer(MapJsonSerializer.class).deserializer(HashMapJsonDeserializer.class).register(TypeRegistry.simpleTypes);
        TypeRegistry.MAPPER.forType(IdentityHashMap.class).serializer(MapJsonSerializer.class).deserializer(IdentityHashMapJsonDeserializer.class).register(TypeRegistry.simpleTypes);
        TypeRegistry.MAPPER.forType(LinkedHashMap.class).serializer(MapJsonSerializer.class).deserializer(LinkedHashMapJsonDeserializer.class).register(TypeRegistry.simpleTypes);
        TypeRegistry.MAPPER.forType(SortedMap.class).serializer(MapJsonSerializer.class).deserializer(SortedMapJsonDeserializer.class).register(TypeRegistry.simpleTypes);
        TypeRegistry.MAPPER.forType(TreeMap.class).serializer(MapJsonSerializer.class).deserializer(TreeMapJsonDeserializer.class).register(TypeRegistry.simpleTypes);
        TypeRegistry.MAPPER.forType(boolean[].class).serializer(PrimitiveBooleanArrayJsonSerializer.class).deserializer(PrimitiveBooleanArrayJsonDeserializer.class).register(TypeRegistry.simpleTypes);
        TypeRegistry.MAPPER.forType(byte[].class).serializer(PrimitiveByteArrayJsonSerializer.class).deserializer(PrimitiveByteArrayJsonDeserializer.class).register(TypeRegistry.simpleTypes);
        TypeRegistry.MAPPER.forType(char[].class).serializer(PrimitiveCharacterArrayJsonSerializer.class).deserializer(PrimitiveCharacterArrayJsonDeserializer.class).register(TypeRegistry.simpleTypes);
        TypeRegistry.MAPPER.forType(double[].class).serializer(PrimitiveDoubleArrayJsonSerializer.class).deserializer(PrimitiveDoubleArrayJsonDeserializer.class).register(TypeRegistry.simpleTypes);
        TypeRegistry.MAPPER.forType(float[].class).serializer(PrimitiveFloatArrayJsonSerializer.class).deserializer(PrimitiveFloatArrayJsonDeserializer.class).register(TypeRegistry.simpleTypes);
        TypeRegistry.MAPPER.forType(int[].class).serializer(PrimitiveIntegerArrayJsonSerializer.class).deserializer(PrimitiveIntegerArrayJsonDeserializer.class).register(TypeRegistry.simpleTypes);
        TypeRegistry.MAPPER.forType(long[].class).serializer(PrimitiveLongArrayJsonSerializer.class).deserializer(PrimitiveLongArrayJsonDeserializer.class).register(TypeRegistry.simpleTypes);
        TypeRegistry.MAPPER.forType(short[].class).serializer(PrimitiveShortArrayJsonSerializer.class).deserializer(PrimitiveShortArrayJsonDeserializer.class).register(TypeRegistry.simpleTypes);
        TypeRegistry.MAPPER.forType(boolean[][].class).serializer(PrimitiveBooleanArray2dJsonSerializer.class).deserializer(PrimitiveBooleanArray2dJsonDeserializer.class).register(TypeRegistry.simpleTypes);
        TypeRegistry.MAPPER.forType(byte[][].class).serializer(PrimitiveByteArray2dJsonSerializer.class).deserializer(PrimitiveByteArray2dJsonDeserializer.class).register(TypeRegistry.simpleTypes);
        TypeRegistry.MAPPER.forType(char[][].class).serializer(PrimitiveCharacterArray2dJsonSerializer.class).deserializer(PrimitiveCharacterArray2dJsonDeserializer.class).register(TypeRegistry.simpleTypes);
        TypeRegistry.MAPPER.forType(double[][].class).serializer(PrimitiveDoubleArray2dJsonSerializer.class).deserializer(PrimitiveDoubleArray2dJsonDeserializer.class).register(TypeRegistry.simpleTypes);
        TypeRegistry.MAPPER.forType(float[][].class).serializer(PrimitiveFloatArray2dJsonSerializer.class).deserializer(PrimitiveFloatArray2dJsonDeserializer.class).register(TypeRegistry.simpleTypes);
        TypeRegistry.MAPPER.forType(int[][].class).serializer(PrimitiveIntegerArray2dJsonSerializer.class).deserializer(PrimitiveIntegerArray2dJsonDeserializer.class).register(TypeRegistry.simpleTypes);
        TypeRegistry.MAPPER.forType(long[][].class).serializer(PrimitiveLongArray2dJsonSerializer.class).deserializer(PrimitiveLongArray2dJsonDeserializer.class).register(TypeRegistry.simpleTypes);
        TypeRegistry.MAPPER.forType(short[][].class).serializer(PrimitiveShortArray2dJsonSerializer.class).deserializer(PrimitiveShortArray2dJsonDeserializer.class).register(TypeRegistry.simpleTypes);
        TypeRegistry.MAPPER.forType(String[].class).serializer(ArrayJsonSerializer.class).deserializer(PrimitiveShortArray2dJsonDeserializer.class).register(TypeRegistry.simpleTypes);
        TypeRegistry.MAPPER.forType(String[][].class).serializer(Array2dJsonSerializer.class).deserializer(Array2dJsonDeserializer.class).register(TypeRegistry.simpleTypes);
        TypeRegistry.MAPPER.forType(Object.class).serializer(ObjectKeySerializer.class).deserializer(StringKeyDeserializer.class).register(TypeRegistry.keysMappers);
        TypeRegistry.MAPPER.forType(Serializable.class).serializer(ObjectKeySerializer.class).deserializer(StringKeyDeserializer.class).register(TypeRegistry.keysMappers);
        TypeRegistry.MAPPER.forType(BigDecimal.class).serializer(NumberKeySerializer.class).deserializer(BaseNumberKeyDeserializer.BigDecimalKeyDeserializer.class).register(TypeRegistry.keysMappers);
        TypeRegistry.MAPPER.forType(BigInteger.class).serializer(NumberKeySerializer.class).deserializer(BaseNumberKeyDeserializer.BigIntegerKeyDeserializer.class).register(TypeRegistry.keysMappers);
        TypeRegistry.MAPPER.forType(Boolean.class).serializer(BooleanKeySerializer.class).deserializer(BooleanKeyDeserializer.class).register(TypeRegistry.keysMappers);
        TypeRegistry.MAPPER.forType(Byte.class).serializer(NumberKeySerializer.class).deserializer(BaseNumberKeyDeserializer.ByteKeyDeserializer.class).register(TypeRegistry.keysMappers);
        TypeRegistry.MAPPER.forType(Character.class).serializer(ToStringKeySerializer.class).deserializer(CharacterKeyDeserializer.class).register(TypeRegistry.keysMappers);
        TypeRegistry.MAPPER.forType(Date.class).serializer(DateKeySerializer.class).deserializer(BaseDateKeyDeserializer.DateKeyDeserializer.class).register(TypeRegistry.keysMappers);
        TypeRegistry.MAPPER.forType(Double.class).serializer(NumberKeySerializer.class).deserializer(BaseNumberKeyDeserializer.DoubleKeyDeserializer.class).register(TypeRegistry.keysMappers);
        TypeRegistry.MAPPER.forType(Enum.class).serializer(EnumKeySerializer.class).deserializer(EnumKeyDeserializer.class).register(TypeRegistry.keysMappers);
        TypeRegistry.MAPPER.forType(Float.class).serializer(NumberKeySerializer.class).deserializer(BaseNumberKeyDeserializer.FloatKeyDeserializer.class).register(TypeRegistry.keysMappers);
        TypeRegistry.MAPPER.forType(Integer.class).serializer(NumberKeySerializer.class).deserializer(BaseNumberKeyDeserializer.IntegerKeyDeserializer.class).register(TypeRegistry.keysMappers);
        TypeRegistry.MAPPER.forType(Long.class).serializer(NumberKeySerializer.class).deserializer(BaseNumberKeyDeserializer.LongKeyDeserializer.class).register(TypeRegistry.keysMappers);
        TypeRegistry.MAPPER.forType(Short.class).serializer(NumberKeySerializer.class).deserializer(BaseNumberKeyDeserializer.ShortKeyDeserializer.class).register(TypeRegistry.keysMappers);
        TypeRegistry.MAPPER.forType(java.sql.Date.class).serializer(DateKeySerializer.class).deserializer(BaseDateKeyDeserializer.SqlDateKeyDeserializer.class).register(TypeRegistry.keysMappers);
        TypeRegistry.MAPPER.forType(Time.class).serializer(DateKeySerializer.class).deserializer(BaseDateKeyDeserializer.SqlTimeKeyDeserializer.class).register(TypeRegistry.keysMappers);
        TypeRegistry.MAPPER.forType(Timestamp.class).serializer(DateKeySerializer.class).deserializer(BaseDateKeyDeserializer.SqlTimestampKeyDeserializer.class).register(TypeRegistry.keysMappers);
        TypeRegistry.MAPPER.forType(String.class).serializer(ToStringKeySerializer.class).deserializer(StringKeyDeserializer.class).register(TypeRegistry.keysMappers);
        TypeRegistry.MAPPER.forType(UUID.class).serializer(UUIDKeySerializer.class).deserializer(UUIDKeyDeserializer.class).register(TypeRegistry.keysMappers);
        collectionsDeserializers.put(AbstractCollection.class.getCanonicalName(), AbstractCollectionJsonDeserializer.class);
        collectionsDeserializers.put(AbstractList.class.getCanonicalName(), AbstractListJsonDeserializer.class);
        collectionsDeserializers.put(AbstractQueue.class.getCanonicalName(), AbstractQueueJsonDeserializer.class);
        collectionsDeserializers.put(AbstractSequentialList.class.getCanonicalName(), AbstractSequentialListJsonDeserializer.class);
        collectionsDeserializers.put(AbstractSet.class.getCanonicalName(), AbstractSetJsonDeserializer.class);
        collectionsDeserializers.put(ArrayList.class.getCanonicalName(), ArrayListJsonDeserializer.class);
        collectionsDeserializers.put(Collection.class.getCanonicalName(), CollectionJsonDeserializer.class);
        collectionsDeserializers.put(EnumSet.class.getCanonicalName(), EnumSetJsonDeserializer.class);
        collectionsDeserializers.put(HashSet.class.getCanonicalName(), HashSetJsonDeserializer.class);
        collectionsDeserializers.put(Iterable.class.getCanonicalName(), IterableJsonDeserializer.class);
        collectionsDeserializers.put(LinkedHashSet.class.getCanonicalName(), LinkedHashSetJsonDeserializer.class);
        collectionsDeserializers.put(LinkedList.class.getCanonicalName(), LinkedListJsonDeserializer.class);
        collectionsDeserializers.put(List.class.getCanonicalName(), ListJsonDeserializer.class);
        collectionsDeserializers.put(PriorityQueue.class.getCanonicalName(), PriorityQueueJsonDeserializer.class);
        collectionsDeserializers.put(Queue.class.getCanonicalName(), QueueJsonDeserializer.class);
        collectionsDeserializers.put(Set.class.getCanonicalName(), SetJsonDeserializer.class);
        collectionsDeserializers.put(SortedSet.class.getCanonicalName(), SortedSetJsonDeserializer.class);
        collectionsDeserializers.put(Stack.class.getCanonicalName(), StackJsonDeserializer.class);
        collectionsDeserializers.put(TreeSet.class.getCanonicalName(), TreeSetJsonDeserializer.class);
        collectionsDeserializers.put(Vector.class.getCanonicalName(), VectorJsonDeserializer.class);
        mapDeserializers.put(Map.class.getName(), MapJsonDeserializer.class);
        mapDeserializers.put(AbstractMap.class.getName(), AbstractMapJsonDeserializer.class);
        mapDeserializers.put(EnumMap.class.getName(), EnumMapJsonDeserializer.class);
        mapDeserializers.put(HashMap.class.getName(), HashMapJsonDeserializer.class);
        mapDeserializers.put(IdentityHashMap.class.getName(), IdentityHashMapJsonDeserializer.class);
        mapDeserializers.put(LinkedHashMap.class.getName(), LinkedHashMapJsonDeserializer.class);
        mapDeserializers.put(SortedMap.class.getName(), SortedMapJsonDeserializer.class);
        mapDeserializers.put(TreeMap.class.getName(), TreeMapJsonDeserializer.class);
    }

    private static class TypeDeserializerNotFoundException
    extends RuntimeException {
        TypeDeserializerNotFoundException(String typeName) {
            super(typeName);
        }
    }

    private static class TypeSerializerNotFoundException
    extends RuntimeException {
        TypeSerializerNotFoundException(String typeName) {
            super(typeName);
        }
    }

    public static class ClassMapper {
        private final String clazz;
        private TypeName serializer;
        private TypeName deserializer;

        private ClassMapper(Class clazz) {
            this.clazz = clazz.getCanonicalName();
        }

        private ClassMapper(String type) {
            this.clazz = type;
        }

        private ClassMapper serializer(Class serializer) {
            this.serializer = TypeName.get(serializer);
            return this;
        }

        private ClassMapper deserializer(Class deserializer) {
            this.deserializer = TypeName.get(deserializer);
            return this;
        }

        private ClassMapper serializer(TypeName serializer) {
            this.serializer = serializer;
            return this;
        }

        private ClassMapper deserializer(TypeName deserializer) {
            this.deserializer = deserializer;
            return this;
        }

        private ClassMapper register(Map<String, ClassMapper> registry) {
            registry.put(this.clazz, this);
            return this;
        }
    }

    static class ClassMapperFactory {
        ClassMapperFactory() {
        }

        ClassMapper forType(Class<?> clazz) {
            return new ClassMapper(clazz);
        }
    }
}

