/*
 * Decompiled with CFR 0.152.
 */
package org.dominokit.jackson.processor.deserialization;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import dominojackson.shaded.com.google.auto.common.MoreElements;
import dominojackson.shaded.com.google.auto.common.MoreTypes;
import dominojackson.shaded.com.squareup.javapoet.ClassName;
import dominojackson.shaded.com.squareup.javapoet.CodeBlock;
import dominojackson.shaded.com.squareup.javapoet.MethodSpec;
import dominojackson.shaded.com.squareup.javapoet.ParameterizedTypeName;
import dominojackson.shaded.com.squareup.javapoet.TypeName;
import dominojackson.shaded.com.squareup.javapoet.TypeSpec;
import dominojackson.shaded.com.squareup.javapoet.WildcardTypeName;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.dominokit.jackson.JacksonContextProvider;
import org.dominokit.jackson.JsonDeserializationContext;
import org.dominokit.jackson.JsonDeserializer;
import org.dominokit.jackson.JsonDeserializerParameters;
import org.dominokit.jackson.deser.bean.AbstractBeanJsonDeserializer;
import org.dominokit.jackson.deser.bean.AbstractIdentityDeserializationInfo;
import org.dominokit.jackson.deser.bean.BeanPropertyDeserializer;
import org.dominokit.jackson.deser.bean.HasDeserializerAndParameters;
import org.dominokit.jackson.deser.bean.IdentityDeserializationInfo;
import org.dominokit.jackson.deser.bean.Instance;
import org.dominokit.jackson.deser.bean.InstanceBuilder;
import org.dominokit.jackson.deser.bean.MapLike;
import org.dominokit.jackson.deser.bean.PropertyIdentityDeserializationInfo;
import org.dominokit.jackson.deser.bean.SubtypeDeserializer;
import org.dominokit.jackson.deser.bean.TypeDeserializationInfo;
import org.dominokit.jackson.exception.JsonDeserializationException;
import org.dominokit.jackson.processor.AbstractJsonMapperGenerator;
import org.dominokit.jackson.processor.AbstractMapperProcessor;
import org.dominokit.jackson.processor.BeanIdentityInfo;
import org.dominokit.jackson.processor.Type;
import org.dominokit.jackson.processor.deserialization.DeserializerBuilder;
import org.dominokit.jackson.processor.deserialization.FieldDeserializersChainBuilder;
import org.dominokit.jackson.processor.deserialization.ParameterDeserializerBuilder;
import org.dominokit.jackson.stream.JsonReader;
import org.dominokit.jackson.stream.JsonToken;

public class AptDeserializerBuilder
extends AbstractJsonMapperGenerator {
    private static final WildcardTypeName DEFAULT_WILDCARD = WildcardTypeName.subtypeOf(Object.class);
    private List<ParameterDeserializerBuilder> parameterBuilders;

    public AptDeserializerBuilder(String packageName, TypeMirror beanType, Filer filer) {
        super(packageName, beanType, filer);
    }

    @Override
    protected TypeName superClass() {
        return ParameterizedTypeName.get(ClassName.get(AbstractBeanJsonDeserializer.class), ClassName.get(this.beanType));
    }

    @Override
    protected String namePostfix() {
        return "BeanJsonDeserializerImpl";
    }

    @Override
    protected String targetTypeMethodName() {
        return "getDeserializedType";
    }

    @Override
    protected Optional<MethodSpec> initMethod() {
        return this.buildInitDeserializersMethod(this.beanType);
    }

    @Override
    protected MethodSpec initSubtypesMethod() {
        if (this.subTypesInfo == null) {
            return MethodSpec.methodBuilder("initMapSubtypeClassToDeserializer").addModifiers(Modifier.PROTECTED).addAnnotation(Override.class).returns(ParameterizedTypeName.get(ClassName.get(Map.class), ClassName.get(Class.class), ClassName.get(SubtypeDeserializer.class))).addStatement("return $T.emptyMap()", Collections.class).build();
        }
        MethodSpec.Builder builder = MethodSpec.methodBuilder("initMapSubtypeClassToDeserializer").addModifiers(Modifier.PROTECTED).addAnnotation(Override.class).returns(ParameterizedTypeName.get(ClassName.get(Map.class), ClassName.get(Class.class), ClassName.get(SubtypeDeserializer.class))).addStatement("$T map = new $T($L)", ParameterizedTypeName.get(ClassName.get(Map.class), ClassName.get(Class.class), ClassName.get(SubtypeDeserializer.class)), ClassName.get(IdentityHashMap.class), this.subTypesInfo.getSubTypes().size());
        for (Map.Entry<String, TypeMirror> subtypeEntry : this.subTypesInfo.getSubTypes().entrySet()) {
            String pkg = MoreElements.getPackage(MoreTypes.asTypeElement(subtypeEntry.getValue())).getQualifiedName().toString();
            TypeSpec subtypeType = TypeSpec.anonymousClassBuilder("", new Object[0]).superclass(ClassName.get(SubtypeDeserializer.BeanSubtypeDeserializer.class)).addMethod(MethodSpec.methodBuilder("newDeserializer").addModifiers(Modifier.PROTECTED).addAnnotation(Override.class).returns(ParameterizedTypeName.get(ClassName.get(JsonDeserializer.class), WildcardTypeName.subtypeOf(Object.class))).addStatement("return new $L()", ClassName.bestGuess(Type.deserializerName(pkg, subtypeEntry.getValue()))).build()).build();
            builder.addStatement("map.put($T.class, $L)", TypeName.get(subtypeEntry.getValue()), subtypeType);
        }
        builder.addStatement("return map", new Object[0]);
        return builder.build();
    }

    @Override
    protected Set<MethodSpec> moreMethods() {
        Optional<BeanIdentityInfo> beanIdentityInfo;
        JsonIgnoreProperties ignorePropertiesAnnotation;
        MethodSpec initIgnoreFieldsMethod;
        HashSet<MethodSpec> methods = new HashSet<MethodSpec>();
        if (this.beanType.getKind() == TypeKind.DECLARED && ((DeclaredType)this.beanType).asElement().getKind() == ElementKind.CLASS && !((DeclaredType)this.beanType).asElement().getModifiers().contains((Object)Modifier.ABSTRACT)) {
            methods.add(this.buildInitInstanceBuilderMethod());
        }
        if (Objects.nonNull(initIgnoreFieldsMethod = this.buildInitIgnoreFields(this.beanType))) {
            methods.add(initIgnoreFieldsMethod);
        }
        if (Objects.nonNull(ignorePropertiesAnnotation = AbstractMapperProcessor.typeUtils.asElement(this.beanType).getAnnotation(JsonIgnoreProperties.class))) {
            methods.add(this.buildIgnoreUnknownMethod(ignorePropertiesAnnotation.ignoreUnknown()));
        }
        if ((beanIdentityInfo = Type.processIdentity(this.beanType)).isPresent()) {
            methods.add(this.buildInitIdentityInfoMethod(beanIdentityInfo.get()));
        }
        return methods;
    }

    private MethodSpec buildInitIdentityInfoMethod(BeanIdentityInfo identityInfo) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder("initIdentityInfo").addModifiers(Modifier.PROTECTED).addAnnotation(Override.class).returns(ParameterizedTypeName.get(ClassName.get(IdentityDeserializationInfo.class), TypeName.get(this.beanType)));
        if (identityInfo.isIdABeanProperty()) {
            builder.addStatement("return $L", this.buildPropertyIdentifierDeserializationInfo(this.beanType, identityInfo));
        } else {
            builder.addStatement("return $L", this.buildIdentifierDeserializationInfo(this.beanType, identityInfo, new FieldDeserializersChainBuilder(identityInfo.getType().get()).getInstance(identityInfo.getType().get())));
        }
        return builder.build();
    }

    private TypeSpec buildIdentifierDeserializationInfo(TypeMirror type, BeanIdentityInfo identityInfo, CodeBlock deserializerType) {
        return TypeSpec.anonymousClassBuilder("$S, $T.class, $T.class", identityInfo.getPropertyName(), identityInfo.getGenerator(), identityInfo.getScope().get()).superclass(ParameterizedTypeName.get(ClassName.get(AbstractIdentityDeserializationInfo.class), TypeName.get(type), TypeName.get(identityInfo.getType().get()))).addMethod(MethodSpec.methodBuilder("newDeserializer").addModifiers(Modifier.PROTECTED).addAnnotation(Override.class).returns(ParameterizedTypeName.get(ClassName.get(JsonDeserializer.class), DEFAULT_WILDCARD)).addStatement("return $L", deserializerType).build()).build();
    }

    private CodeBlock buildPropertyIdentifierDeserializationInfo(TypeMirror type, BeanIdentityInfo identityInfo) {
        return CodeBlock.builder().add("new $T($S, $T.class, $T.class)", ParameterizedTypeName.get(ClassName.get(PropertyIdentityDeserializationInfo.class), TypeName.get(type)), identityInfo.getPropertyName(), identityInfo.getGenerator(), identityInfo.getScope().get()).build();
    }

    private boolean isUseJsonCreator() {
        return ((DeclaredType)this.beanType).asElement().getEnclosedElements().stream().anyMatch(o -> o.getAnnotation(JsonCreator.class) != null);
    }

    private ExecutableElement getCreator() {
        return ((DeclaredType)this.beanType).asElement().getEnclosedElements().stream().filter(o -> o.getAnnotation(JsonCreator.class) != null).map(o -> (ExecutableElement)o).findFirst().orElse(null);
    }

    private boolean isUseBuilder() {
        String builderName = this.getBuilderName();
        return builderName != null && !builderName.isEmpty();
    }

    private String getBuilderName() {
        String builderName;
        JsonDeserialize jsonDeserialize = AbstractMapperProcessor.typeUtils.asElement(this.beanType).getAnnotation(JsonDeserialize.class);
        if (Objects.isNull(jsonDeserialize)) {
            return null;
        }
        try {
            builderName = jsonDeserialize.builder().getName();
        }
        catch (MirroredTypeException e) {
            TypeMirror typeMirror = e.getTypeMirror();
            builderName = ((TypeElement)AbstractMapperProcessor.typeUtils.asElement(typeMirror)).getQualifiedName().toString();
        }
        return builderName;
    }

    private MethodSpec buildIgnoreUnknownMethod(boolean ignored) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder("isDefaultIgnoreUnknown").addAnnotation(Override.class).addModifiers(Modifier.PROTECTED).returns(TypeName.BOOLEAN).addStatement("return $L", ignored);
        return builder.build();
    }

    private MethodSpec buildInitIgnoreFields(TypeMirror beanType) {
        List<Element> ignoredFields = this.getIgnoredFields(beanType);
        if (!ignoredFields.isEmpty()) {
            MethodSpec.Builder builder = MethodSpec.methodBuilder("initIgnoredProperties");
            builder.addAnnotation(Override.class).addModifiers(Modifier.PROTECTED).returns(ParameterizedTypeName.get(HashSet.class, new java.lang.reflect.Type[]{String.class})).addStatement("HashSet<String> col = new HashSet<String>(" + ignoredFields.size() + ")", new Object[0]);
            ignoredFields.forEach(f -> builder.addStatement("col.add(\"" + this.getPropertyName((Element)f) + "\")", new Object[0]));
            builder.addStatement("return col", new Object[0]);
            return builder.build();
        }
        return null;
    }

    private List<Element> getIgnoredFields(TypeMirror beanType) {
        TypeElement typeElement = (TypeElement)AbstractMapperProcessor.typeUtils.asElement(beanType);
        List<Element> ignoredFields = this.getIgnoredFields(typeElement);
        return new ArrayList<Element>(ignoredFields);
    }

    private List<Element> getIgnoredFields(TypeElement typeElement) {
        TypeMirror superclass = typeElement.getSuperclass();
        if (superclass.getKind().equals((Object)TypeKind.NONE)) {
            return new ArrayList<Element>();
        }
        List<Element> ignoredFields = typeElement.getEnclosedElements().stream().filter(e -> ElementKind.FIELD.equals((Object)e.getKind()) && this.isNotStatic((Element)e) && this.isIgnored((Element)e)).collect(Collectors.toList());
        ignoredFields.addAll(this.getIgnoredFields((TypeElement)AbstractMapperProcessor.typeUtils.asElement(superclass)));
        return ignoredFields;
    }

    private MethodSpec buildInitInstanceBuilderMethod() {
        ParameterizedTypeName deserializersTypeName = ParameterizedTypeName.get(ClassName.get(MapLike.class), ClassName.get(HasDeserializerAndParameters.class));
        MethodSpec.Builder initInstanceMethodBuilder = MethodSpec.methodBuilder("initInstanceBuilder").addModifiers(Modifier.PROTECTED).returns(ParameterizedTypeName.get(ClassName.get(InstanceBuilder.class), ClassName.get(this.beanType)));
        if (this.isUseJsonCreator()) {
            ExecutableElement creator = this.getCreator();
            List<? extends VariableElement> parameterTypes = creator.getParameters();
            this.parameterBuilders = parameterTypes.stream().map(o -> new ParameterDeserializerBuilder(AbstractMapperProcessor.typeUtils, this.beanType, (VariableElement)o)).collect(Collectors.toList());
            initInstanceMethodBuilder.addStatement("final $T deserializers = $T.get().mapLikeFactory().make()", deserializersTypeName, JacksonContextProvider.class);
            this.buildPropertiesDeserializers(initInstanceMethodBuilder);
        } else {
            initInstanceMethodBuilder.addStatement("final $T deserializers = null", deserializersTypeName);
        }
        boolean useBuilder = this.isUseBuilder();
        if (useBuilder) {
            TypeElement builderElement = this.getBuilderElement();
            initInstanceMethodBuilder.addStatement("final $T builderDeserializer = new $T()", ParameterizedTypeName.get(ClassName.get(AbstractBeanJsonDeserializer.class), ClassName.get(builderElement)), this.builderDeserializerName(builderElement));
            try {
                new AptDeserializerBuilder(this.packageName, builderElement.asType(), AbstractMapperProcessor.filer).generate();
            }
            catch (IOException e) {
                throw new JsonDeserializationException((Throwable)e);
            }
        }
        return initInstanceMethodBuilder.addStatement("return $L", this.instanceBuilderReturnType(useBuilder)).addAnnotation(Override.class).build();
    }

    private void buildPropertiesDeserializers(MethodSpec.Builder initInstanceMethodBuilder) {
        for (ParameterDeserializerBuilder parameterBuilder : this.parameterBuilders) {
            initInstanceMethodBuilder.addCode(parameterBuilder.build());
            initInstanceMethodBuilder.addStatement("deserializers.put($S, $L)", parameterBuilder.getParameterName(), parameterBuilder.getDeserializerName());
        }
    }

    private TypeElement getBuilderElement() {
        String builderName = this.getBuilderName();
        return AbstractMapperProcessor.elementUtils.getTypeElement(builderName);
    }

    private ClassName builderDeserializerName(TypeElement builder) {
        return ClassName.bestGuess(builder.getSimpleName() + this.namePostfix());
    }

    private TypeSpec instanceBuilderReturnType(boolean useBuilder) {
        MethodSpec.Builder createMethodBuilder = MethodSpec.methodBuilder("create").addModifiers(Modifier.PRIVATE).returns(ClassName.get(this.beanType));
        if (this.isUseJsonCreator()) {
            for (ParameterDeserializerBuilder parameterBuilder : this.parameterBuilders) {
                createMethodBuilder.addParameter(Type.wrapperType(parameterBuilder.getParameterType()), parameterBuilder.getParameterName(), new Modifier[0]);
            }
            StringBuilder newBeanBuilder = new StringBuilder().append("return new $T").append(Type.isGenericType(this.beanType) ? "<>(" : "(");
            String parametersString = this.parameterBuilders.stream().map(ParameterDeserializerBuilder::getParameterName).collect(Collectors.joining(", "));
            newBeanBuilder.append(parametersString).append(")");
            createMethodBuilder.addStatement(newBeanBuilder.toString(), TypeName.get(AbstractMapperProcessor.typeUtils.erasure(this.beanType)));
        } else {
            createMethodBuilder.addStatement(Type.isGenericType(this.beanType) ? "return new $T<>()" : "return new $T()", TypeName.get(AbstractMapperProcessor.typeUtils.erasure(this.beanType)));
        }
        MethodSpec createMethod = createMethodBuilder.build();
        TypeSpec.Builder builder = TypeSpec.anonymousClassBuilder("", new Object[0]).addSuperinterface(ParameterizedTypeName.get(ClassName.get(InstanceBuilder.class), ClassName.get(this.beanType))).addMethod(this.newInstanceMethod(this.beanType, createMethod, useBuilder)).addMethod(this.getDeserializerMethod());
        if (!useBuilder) {
            builder.addMethod(createMethod);
        }
        return builder.build();
    }

    private MethodSpec newInstanceMethod(TypeMirror beanType, MethodSpec createMethod, boolean useBuilder) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder("newInstance").addModifiers(Modifier.PUBLIC).addAnnotation(Override.class).returns(ParameterizedTypeName.get(ClassName.get(Instance.class), ClassName.get(beanType))).addParameter((java.lang.reflect.Type)((Object)JsonReader.class), "reader", new Modifier[0]).addParameter((java.lang.reflect.Type)((Object)JsonDeserializationContext.class), "ctx", new Modifier[0]).addParameter((java.lang.reflect.Type)((Object)JsonDeserializerParameters.class), "params", new Modifier[0]).addParameter(ParameterizedTypeName.get(Map.class, new java.lang.reflect.Type[]{String.class, String.class}), "bufferedProperties", new Modifier[0]).addParameter(ParameterizedTypeName.get(Map.class, new java.lang.reflect.Type[]{String.class, Object.class}), "bufferedPropertiesValues", new Modifier[0]);
        if (useBuilder) {
            TypeElement builderElement = this.getBuilderElement();
            JsonPOJOBuilder jsonPOJOBuilder = builderElement.getAnnotation(JsonPOJOBuilder.class);
            String buildMethodName = "build";
            if (Objects.nonNull(jsonPOJOBuilder)) {
                buildMethodName = jsonPOJOBuilder.buildMethodName();
            }
            builder.addStatement("return new $T(builderDeserializer.deserializeInline(reader, ctx, params, null, null, null, bufferedProperties)." + buildMethodName + "(), bufferedProperties)", ParameterizedTypeName.get(ClassName.get(Instance.class), ClassName.get(beanType)));
        } else if (this.isUseJsonCreator()) {
            this.buildAssignProperties(beanType, createMethod, builder);
        } else {
            builder.addStatement("return new $T($N(), bufferedProperties)", ParameterizedTypeName.get(ClassName.get(Instance.class), ClassName.get(beanType)), createMethod);
        }
        return builder.build();
    }

    private void buildAssignProperties(TypeMirror beanType, MethodSpec createMethod, MethodSpec.Builder builder) {
        for (ParameterDeserializerBuilder parameterBuilder : this.parameterBuilders) {
            builder.addStatement("$T $L = null", Type.wrapperType(parameterBuilder.getParameterType()), parameterBuilder.getParameterName() + "Property");
        }
        builder.beginControlFlow("while ($T.NAME == reader.peek())", JsonToken.class);
        builder.addStatement("String nextName = reader.nextName()", new Object[0]);
        for (ParameterDeserializerBuilder parameterBuilder : this.parameterBuilders) {
            String paramName = parameterBuilder.getParameterName();
            builder.beginControlFlow("if($S.equals(nextName))", paramName);
            builder.addStatement("$L = $L.deserialize(reader, ctx)", paramName + "Property", paramName + "Deserializer");
            builder.addStatement("continue", new Object[0]);
            builder.endControlFlow();
        }
        builder.endControlFlow();
        String argumentsString = this.parameterBuilders.stream().map(ParameterDeserializerBuilder::getParameterName).map(name -> name + "Property").collect(Collectors.joining(", "));
        builder.addStatement("return new $T($N($L), bufferedProperties)", ParameterizedTypeName.get(ClassName.get(Instance.class), ClassName.get(beanType)), createMethod, argumentsString);
    }

    private MethodSpec getDeserializerMethod() {
        return MethodSpec.methodBuilder("getParametersDeserializer").addModifiers(Modifier.PUBLIC).addAnnotation(Override.class).addStatement("return deserializers", new Object[0]).returns(ParameterizedTypeName.get(ClassName.get(MapLike.class), ClassName.get(HasDeserializerAndParameters.class))).build();
    }

    private Optional<MethodSpec> buildInitDeserializersMethod(TypeMirror beanType) {
        if (this.isUseBuilder() || this.isUseJsonCreator() || this.isAbstract(beanType)) {
            return Optional.empty();
        }
        ParameterizedTypeName resultType = ParameterizedTypeName.get(ClassName.get(MapLike.class), ParameterizedTypeName.get(ClassName.get(BeanPropertyDeserializer.class), TypeName.get(beanType), DEFAULT_WILDCARD));
        MethodSpec.Builder builder = MethodSpec.methodBuilder("initDeserializers").addModifiers(Modifier.PROTECTED).addAnnotation(Override.class).returns(resultType).addStatement("$T map = $T.get().mapLikeFactory().make()", resultType, JacksonContextProvider.class);
        this.orderedFields().entrySet().stream().filter(entry -> this.isEligibleForSerializationDeserialization((Element)entry.getKey())).forEach(entry -> builder.addStatement("map.put($S, $L)", this.getPropertyName((Element)entry.getKey()), new DeserializerBuilder(AbstractMapperProcessor.typeUtils, beanType, (Element)entry.getKey(), (TypeMirror)entry.getValue()).buildDeserializer()));
        builder.addStatement("return map", new Object[0]);
        return Optional.of(builder.build());
    }

    private String getPropertyName(Element field) {
        JsonProperty annotation = field.getAnnotation(JsonProperty.class);
        if (Objects.isNull(annotation) || "".equals(annotation.value())) {
            return field.getSimpleName().toString();
        }
        return annotation.value();
    }

    @Override
    protected Class<?> getMapperType() {
        return TypeDeserializationInfo.class;
    }
}

