/*
 * Decompiled with CFR 0.152.
 */
package org.dominokit.jackson.processor.deserialization;

import com.fasterxml.jackson.annotation.JsonFormat;
import dominojackson.shaded.com.squareup.javapoet.ClassName;
import dominojackson.shaded.com.squareup.javapoet.MethodSpec;
import dominojackson.shaded.com.squareup.javapoet.ParameterizedTypeName;
import dominojackson.shaded.com.squareup.javapoet.TypeName;
import dominojackson.shaded.com.squareup.javapoet.TypeSpec;
import java.util.Objects;
import java.util.Optional;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.dominokit.jackson.JacksonContextProvider;
import org.dominokit.jackson.JsonDeserializationContext;
import org.dominokit.jackson.JsonDeserializer;
import org.dominokit.jackson.JsonDeserializerParameters;
import org.dominokit.jackson.deser.bean.BeanPropertyDeserializer;
import org.dominokit.jackson.processor.AbstractJsonMapperGenerator;
import org.dominokit.jackson.processor.AccessorsFilter;
import org.dominokit.jackson.processor.ObjectMapperProcessor;
import org.dominokit.jackson.processor.Type;
import org.dominokit.jackson.processor.deserialization.FieldDeserializersChainBuilder;

class DeserializerBuilder
extends AccessorsFilter {
    private final TypeMirror beanType;
    private final Element field;
    private final TypeMirror fieldType;

    DeserializerBuilder(Types typeUtils, TypeMirror beanType, Element field, TypeMirror fieldType) {
        super(typeUtils);
        this.beanType = beanType;
        this.field = field;
        this.fieldType = fieldType;
    }

    TypeSpec buildDeserializer() {
        String paramValue = "value";
        String paramBean = "bean";
        TypeSpec.Builder builder = TypeSpec.anonymousClassBuilder("", new Object[0]).superclass(ParameterizedTypeName.get(ClassName.get(BeanPropertyDeserializer.class), TypeName.get(this.beanType), Type.wrapperType(this.fieldType)));
        builder.addMethod(this.buildDeserializerMethod());
        if (Objects.nonNull(this.field.getAnnotation(JsonFormat.class))) {
            builder.addMethod(this.buildParametersMethod());
        }
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder("setValue").addModifiers(Modifier.PUBLIC).addAnnotation(Override.class).addParameter(ClassName.get(this.beanType), "bean", new Modifier[0]);
        AbstractJsonMapperGenerator.AccessorInfo accessorInfo = this.setterInfo(this.field);
        methodBuilder.addParameter(Type.wrapperType(this.fieldType), "value", new Modifier[0]).addParameter((java.lang.reflect.Type)((Object)JsonDeserializationContext.class), "ctx", new Modifier[0]).addStatement("$L", "bean." + accessorInfo.getName() + (accessorInfo.method.isPresent() ? "(" : "=") + "value" + (accessorInfo.method.isPresent() ? ")" : ""));
        builder.addMethod(methodBuilder.build());
        return builder.build();
    }

    private MethodSpec buildDeserializerMethod() {
        return MethodSpec.methodBuilder("newDeserializer").addModifiers(Modifier.PROTECTED).addAnnotation(Override.class).returns(ParameterizedTypeName.get(ClassName.get(JsonDeserializer.class), ObjectMapperProcessor.DEFAULT_WILDCARD)).addStatement("return $L", new FieldDeserializersChainBuilder(this.beanType).getInstance(this.fieldType)).build();
    }

    private MethodSpec buildParametersMethod() {
        JsonFormat jsonFormat = this.field.getAnnotation(JsonFormat.class);
        return MethodSpec.methodBuilder("newParameters").addModifiers(Modifier.PROTECTED).addAnnotation(Override.class).returns((java.lang.reflect.Type)((Object)JsonDeserializerParameters.class)).addStatement("return $T.get()\n\t\t.newDeserializerParameters()\n\t\t.setPattern($S)\n\t\t.setShape($T.$L)", TypeName.get(JacksonContextProvider.class), jsonFormat.pattern(), TypeName.get(JsonFormat.Shape.class), jsonFormat.shape().toString()).build();
    }

    private AbstractJsonMapperGenerator.AccessorInfo setterInfo(Element field) {
        String upperCaseFirstLetter = this.upperCaseFirstLetter(field.getSimpleName().toString());
        Optional<AbstractJsonMapperGenerator.AccessorInfo> accessor = this.getAccessors(this.beanType).stream().filter(accessorInfo -> accessorInfo.getName().equals("set" + upperCaseFirstLetter)).findFirst();
        return accessor.orElseGet(() -> new AbstractJsonMapperGenerator.AccessorInfo(field.getSimpleName().toString()));
    }

    private String upperCaseFirstLetter(String name) {
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }
}

