/*
 * Decompiled with CFR 0.152.
 */
package org.dominokit.jackson.processor.deserialization;

import dominojackson.shaded.com.google.auto.common.MoreElements;
import dominojackson.shaded.com.google.auto.common.MoreTypes;
import dominojackson.shaded.com.squareup.javapoet.ClassName;
import dominojackson.shaded.com.squareup.javapoet.CodeBlock;
import dominojackson.shaded.com.squareup.javapoet.TypeName;
import java.util.Deque;
import java.util.LinkedList;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeMirror;
import org.dominokit.jackson.deser.EnumJsonDeserializer;
import org.dominokit.jackson.deser.array.ArrayJsonDeserializer;
import org.dominokit.jackson.deser.array.dd.Array2dJsonDeserializer;
import org.dominokit.jackson.processor.MappersChainBuilder;
import org.dominokit.jackson.processor.ObjectMapperProcessor;
import org.dominokit.jackson.processor.Type;
import org.dominokit.jackson.processor.TypeRegistry;

public class FieldDeserializersChainBuilder
implements MappersChainBuilder {
    private static final String GET_INSTANCE = "$T.getInstance()";
    private static final String NEW_INSTANCE = "$T.newInstance(";
    private boolean rootGenerated;
    private CodeBlock.Builder builder = CodeBlock.builder();
    private Deque<TypeName> deserializers = new LinkedList<TypeName>();
    private final TypeMirror beanType;

    public FieldDeserializersChainBuilder(TypeMirror beanType) {
        this.beanType = beanType;
        this.rootGenerated = true;
    }

    public FieldDeserializersChainBuilder(TypeMirror beanType, boolean rootGenerated) {
        this.beanType = beanType;
        this.rootGenerated = rootGenerated;
    }

    @Override
    public CodeBlock getInstance(Element field) {
        return this.builder.add(this.getFieldDeserializer(field.asType()), this.asClassesArray()).build();
    }

    @Override
    public CodeBlock getInstance(TypeMirror type) {
        return this.builder.add(this.getFieldDeserializer(type), this.asClassesArray()).build();
    }

    private TypeName[] asClassesArray() {
        return this.deserializers.toArray(new TypeName[this.deserializers.size()]);
    }

    private String getFieldDeserializer(TypeMirror typeMirror) {
        if (Type.isIterable(typeMirror = Type.removeOuterWildCards(typeMirror))) {
            return this.getIterableDeserializer(typeMirror);
        }
        if (Type.isMap(typeMirror)) {
            return this.getMapDeserializer(typeMirror);
        }
        if (Type.isArray(typeMirror)) {
            return this.getArrayDeserializer(typeMirror);
        }
        if (Type.isEnum(typeMirror)) {
            return this.getEnumDeserializer(typeMirror);
        }
        return this.getBasicOrCustomDeserializer(typeMirror);
    }

    private String getBasicOrCustomDeserializer(TypeMirror typeMirror) {
        if (Type.isBasicType(typeMirror)) {
            return this.getBasicDeserializer(typeMirror);
        }
        return this.getCustomDeserializer(typeMirror);
    }

    private String getCustomDeserializer(TypeMirror typeMirror) {
        if (Type.stringifyTypeWithPackage(typeMirror).equals(Type.stringifyTypeWithPackage(this.beanType)) && this.rootGenerated) {
            this.deserializers.addLast(ClassName.bestGuess(Type.deserializerName(this.getPackageName(typeMirror), typeMirror)));
        } else if (TypeRegistry.containsDeserializer(Type.stringifyTypeWithPackage(typeMirror))) {
            this.deserializers.addLast(TypeRegistry.getCustomDeserializer(typeMirror));
        } else {
            TypeRegistry.registerDeserializer(Type.stringifyTypeWithPackage(typeMirror), ClassName.bestGuess(this.generateCustomDeserializer(typeMirror)));
            this.deserializers.addLast(TypeRegistry.getCustomDeserializer(typeMirror));
            this.rootGenerated = true;
        }
        return "new $T()";
    }

    private String getPackageName(TypeMirror typeMirror) {
        return MoreElements.getPackage(MoreTypes.asTypeElement(typeMirror)).getQualifiedName().toString();
    }

    private String generateCustomDeserializer(TypeMirror typeMirror) {
        if (TypeRegistry.containsDeserializer(typeMirror) || TypeRegistry.isInActiveGenDeserializer(typeMirror)) {
            return Type.deserializerName(this.getPackageName(typeMirror), typeMirror);
        }
        TypeRegistry.addInActiveGenDeserializer(typeMirror);
        String deserializerName = Type.generateDeserializer(typeMirror);
        TypeRegistry.removeInActiveGenDeserializer(typeMirror);
        return deserializerName;
    }

    private String getEnumDeserializer(TypeMirror typeMirror) {
        this.deserializers.addLast(TypeName.get(EnumJsonDeserializer.class));
        this.deserializers.addLast(TypeName.get(typeMirror));
        this.deserializers.addLast(TypeName.get(typeMirror));
        return "$T.newInstance($T.class,$T.values())";
    }

    private String getBasicDeserializer(TypeMirror typeMirror) {
        this.deserializers.addLast(TypeRegistry.getDeserializer(typeMirror));
        return GET_INSTANCE;
    }

    private String getMapDeserializer(TypeMirror typeMirror) {
        this.deserializers.addLast(TypeName.get(TypeRegistry.getMapDeserializer(typeMirror)));
        return NEW_INSTANCE + this.getKeyDeserializer(Type.firstTypeArgument(typeMirror)) + ", " + this.getFieldDeserializer(Type.secondTypeArgument(typeMirror)) + ")";
    }

    private String getKeyDeserializer(TypeMirror typeMirror) {
        if (Type.isEnum(typeMirror = Type.removeOuterWildCards(typeMirror))) {
            return this.getEnumKeyDeserializer(typeMirror);
        }
        return this.getBasicKeyDeserializer(typeMirror);
    }

    private String getBasicKeyDeserializer(TypeMirror typeMirror) {
        this.deserializers.addLast(TypeRegistry.getKeyDeserializer(Type.stringifyTypeWithPackage(Type.removeOuterWildCards(typeMirror))));
        return GET_INSTANCE;
    }

    private String getEnumKeyDeserializer(TypeMirror typeMirror) {
        this.deserializers.addLast(TypeRegistry.getKeyDeserializer(Enum.class.getName()));
        this.deserializers.addLast(TypeName.get(Type.removeOuterWildCards(typeMirror)));
        this.deserializers.addLast(TypeName.get(Type.removeOuterWildCards(typeMirror)));
        return "$T.newInstance($T.class,$T.values())";
    }

    private String getIterableDeserializer(TypeMirror typeMirror) {
        this.deserializers.addLast(TypeName.get(TypeRegistry.getCollectionDeserializer(typeMirror)));
        return NEW_INSTANCE + this.getFieldDeserializer(Type.firstTypeArgument(typeMirror)) + ")";
    }

    private String getArrayDeserializer(TypeMirror typeMirror) {
        if (Type.isPrimitiveArray(typeMirror)) {
            return this.getBasicDeserializer(typeMirror);
        }
        if (Type.is2dArray(typeMirror)) {
            this.deserializers.addLast(TypeName.get(Array2dJsonDeserializer.class));
            return NEW_INSTANCE + this.getFieldDeserializer(Type.deepArrayComponentType(typeMirror)) + ", " + this.getArray2dCreatorFormat(typeMirror) + ")";
        }
        this.deserializers.addLast(TypeName.get(ArrayJsonDeserializer.class));
        return NEW_INSTANCE + this.getFieldDeserializer(Type.arrayComponentType(typeMirror)) + ", " + this.getArrayCreatorFormat(typeMirror) + ")";
    }

    private String getArrayCreatorFormat(TypeMirror typeMirror) {
        this.deserializers.addLast(TypeName.get(ArrayJsonDeserializer.ArrayCreator.class));
        this.deserializers.addLast(TypeName.get(Type.arrayComponentType(typeMirror)));
        this.deserializers.addLast(TypeName.get(ObjectMapperProcessor.typeUtils.erasure(Type.arrayComponentType(typeMirror))));
        return "($T<$T>) $T[]::new";
    }

    private String getArray2dCreatorFormat(TypeMirror typeMirror) {
        this.deserializers.addLast(TypeName.get(Array2dJsonDeserializer.Array2dCreator.class));
        this.deserializers.addLast(TypeName.get(Type.deepArrayComponentType(typeMirror)));
        this.deserializers.addLast(TypeName.get(ObjectMapperProcessor.typeUtils.erasure(Type.deepArrayComponentType(typeMirror))));
        return "($T<$T>) (first, second) -> new $T[first][second]";
    }
}

