/*
 * Decompiled with CFR 0.152.
 */
package org.dominokit.jackson.processor.deserialization;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import dominojackson.shaded.com.squareup.javapoet.ClassName;
import dominojackson.shaded.com.squareup.javapoet.CodeBlock;
import dominojackson.shaded.com.squareup.javapoet.MethodSpec;
import dominojackson.shaded.com.squareup.javapoet.ParameterizedTypeName;
import dominojackson.shaded.com.squareup.javapoet.TypeName;
import dominojackson.shaded.com.squareup.javapoet.TypeSpec;
import java.util.Objects;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.dominokit.jackson.JacksonContextProvider;
import org.dominokit.jackson.JsonDeserializer;
import org.dominokit.jackson.JsonDeserializerParameters;
import org.dominokit.jackson.deser.bean.HasDeserializerAndParameters;
import org.dominokit.jackson.processor.Type;
import org.dominokit.jackson.processor.deserialization.FieldDeserializersChainBuilder;

public class ParameterDeserializerBuilder {
    private Types typeUtils;
    private TypeMirror type;
    private VariableElement parameter;

    public ParameterDeserializerBuilder(Types typeUtils, TypeMirror type, VariableElement parameter) {
        this.typeUtils = typeUtils;
        this.type = type;
        this.parameter = parameter;
    }

    CodeBlock build() {
        TypeName typeName = Type.wrapperType(this.parameter.asType());
        MethodSpec build = MethodSpec.methodBuilder("newDeserializer").addModifiers(Modifier.PROTECTED).returns(ParameterizedTypeName.get(JsonDeserializer.class)).addAnnotation(Override.class).addStatement("return $L", new FieldDeserializersChainBuilder(this.parameter.asType()).getInstance(this.parameter)).build();
        ParameterizedTypeName deserializerType = ParameterizedTypeName.get(ClassName.get(HasDeserializerAndParameters.class), typeName, ParameterizedTypeName.get(ClassName.get(JsonDeserializer.class), typeName));
        TypeSpec.Builder typeBuilder = TypeSpec.anonymousClassBuilder("", new Object[0]).addSuperinterface(deserializerType).addMethod(build);
        this.typeUtils.asElement(this.type).getEnclosedElements().stream().filter(o -> o.getKind().isField()).filter(o -> o.getSimpleName().toString().equals(this.getParameterName())).filter(o -> Objects.nonNull(o.getAnnotation(JsonFormat.class))).findFirst().ifPresent(o -> typeBuilder.addMethod(this.buildParametersMethod((Element)o)));
        return CodeBlock.builder().addStatement("final $T $L = $L", deserializerType, this.getDeserializerName(), typeBuilder.build()).build();
    }

    private MethodSpec buildParametersMethod(Element element) {
        JsonFormat jsonFormat = element.getAnnotation(JsonFormat.class);
        return MethodSpec.methodBuilder("newParameters").addModifiers(Modifier.PROTECTED).addAnnotation(Override.class).returns((java.lang.reflect.Type)((Object)JsonDeserializerParameters.class)).addStatement("return $T.get()\n\t\t.newDeserializerParameters()\n\t\t.setPattern($S)\n\t\t.setShape($T.$L)", TypeName.get(JacksonContextProvider.class), jsonFormat.pattern(), TypeName.get(JsonFormat.Shape.class), jsonFormat.shape().toString()).build();
    }

    public String getParameterName() {
        String parameterName = this.parameter.getSimpleName().toString();
        JsonProperty jsonProperty = this.parameter.getAnnotation(JsonProperty.class);
        if (Objects.nonNull(jsonProperty)) {
            String value = jsonProperty.value();
            parameterName = value.isEmpty() ? parameterName : value;
        }
        return parameterName;
    }

    public String getDeserializerName() {
        return this.getParameterName() + "Deserializer";
    }

    public TypeMirror getParameterType() {
        return this.parameter.asType();
    }
}

