/*
 * Decompiled with CFR 0.152.
 */
package org.dominokit.jackson.processor.registration;

import dominojackson.shaded.com.google.auto.common.MoreTypes;
import dominojackson.shaded.com.google.auto.service.AutoService;
import dominojackson.shaded.com.squareup.javapoet.AnnotationSpec;
import dominojackson.shaded.com.squareup.javapoet.ArrayTypeName;
import dominojackson.shaded.com.squareup.javapoet.ClassName;
import dominojackson.shaded.com.squareup.javapoet.CodeBlock;
import dominojackson.shaded.com.squareup.javapoet.FieldSpec;
import dominojackson.shaded.com.squareup.javapoet.JavaFile;
import dominojackson.shaded.com.squareup.javapoet.MethodSpec;
import dominojackson.shaded.com.squareup.javapoet.ParameterizedTypeName;
import dominojackson.shaded.com.squareup.javapoet.TypeName;
import dominojackson.shaded.com.squareup.javapoet.TypeSpec;
import dominojackson.shaded.com.squareup.javapoet.TypeVariableName;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.dominokit.jackson.ObjectMapper;
import org.dominokit.jackson.ObjectReader;
import org.dominokit.jackson.ObjectWriter;
import org.dominokit.jackson.annotation.JSONRegistration;
import org.dominokit.jackson.processor.AbstractMapperProcessor;
import org.dominokit.jackson.registration.JsonRegistry;
import org.dominokit.jackson.registration.TypeToken;

@AutoService(value={Processor.class})
public class JSONRegistrationProcessor
extends AbstractMapperProcessor {
    private static final String WRITERS = "WRITERS";
    private static final String READERS = "READERS";
    private static final String MAPPERS = "MAPPERS";
    private static final String INSTANCE_NAME = "INSTANCE";

    @Override
    protected boolean doProcess(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        roundEnv.getElementsAnnotatedWith(JSONRegistration.class).forEach(this::register);
        return false;
    }

    private void register(Element element) {
        FieldSpec mappersMap = this.createConstantMap(MAPPERS, ObjectMapper.class);
        FieldSpec readersMap = this.createConstantMap(READERS, ObjectReader.class);
        FieldSpec writersMap = this.createConstantMap(WRITERS, ObjectWriter.class);
        MethodSpec.Builder constructorBuilder = MethodSpec.constructorBuilder().addModifiers(Modifier.PRIVATE);
        this.mappers.stream().map(this::registerMapperLine).forEach(constructorBuilder::addCode);
        this.readers.stream().map(this::registerReaderLine).forEach(constructorBuilder::addCode);
        this.writers.stream().map(this::registerWriterLine).forEach(constructorBuilder::addCode);
        ClassName className = ClassName.get(this.packageOf(element), element.getAnnotation(JSONRegistration.class).value() + "JsonRegistry", new String[0]);
        FieldSpec instanceField = FieldSpec.builder(className, INSTANCE_NAME, Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL).initializer("new $T()", className).build();
        MethodSpec getMapperMethod = this.createGetMethod("getMapper", MAPPERS, ObjectMapper.class, false);
        MethodSpec getReaderMethod = this.createGetMethod("getReader", READERS, ObjectReader.class, true);
        MethodSpec getWriterMethod = this.createGetMethod("getWriter", WRITERS, ObjectWriter.class, true);
        TypeSpec jacksonConfigurator = TypeSpec.classBuilder(className).addJavadoc(CodeBlock.of("This is generated class, please don't modify\n", new Object[0])).addSuperinterface((Type)((Object)JsonRegistry.class)).addModifiers(Modifier.PUBLIC).addField(mappersMap).addField(readersMap).addField(writersMap).addField(instanceField).addMethod(this.createGetInstanceMethod(className)).addMethod(constructorBuilder.build()).addMethod(getMapperMethod).addMethod(getReaderMethod).addMethod(getWriterMethod).build();
        try {
            JavaFile.builder(this.packageOf(element), jacksonConfigurator).build().writeTo(filer);
        }
        catch (IOException e) {
            this.handleError(e);
        }
    }

    private MethodSpec createGetInstanceMethod(TypeName result) {
        return MethodSpec.methodBuilder("getInstance").addModifiers(Modifier.PUBLIC, Modifier.STATIC).returns(result).addStatement("return INSTANCE", new Object[0]).build();
    }

    private MethodSpec createGetMethod(String name, String mapName, Class<?> returnType, boolean lookupIfNotFound) {
        TypeVariableName typeVariable = TypeVariableName.get("T");
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder(name).addModifiers(Modifier.PUBLIC).addAnnotation(Override.class).addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "\"unchecked\"", new Object[0]).build()).addTypeVariable(typeVariable).returns(ParameterizedTypeName.get(ClassName.get(returnType), typeVariable)).addParameter(ParameterizedTypeName.get(ClassName.get("org.dominokit.jackson.registration", "TypeToken", new String[0]), typeVariable), "type", new Modifier[0]);
        ParameterizedTypeName returnTypeName = ParameterizedTypeName.get(ClassName.get(returnType), typeVariable);
        if (lookupIfNotFound) {
            methodBuilder.beginControlFlow("if(" + mapName + ".containsKey(type))", new Object[0]).addStatement("return ($T)" + mapName + ".get(type)", returnTypeName).endControlFlow().addStatement("return ($T)MAPPERS.get(type)", returnTypeName);
        } else {
            methodBuilder.addStatement("return ($T)" + mapName + ".get(type)", returnTypeName);
        }
        return methodBuilder.build();
    }

    private FieldSpec createConstantMap(String name, Class<?> jsonType) {
        ParameterizedTypeName parameterizedTypeName = ParameterizedTypeName.get(ClassName.get(Map.class), ParameterizedTypeName.get(ClassName.get("org.dominokit.jackson.registration", "TypeToken", new String[0]), TypeVariableName.get("?")), ParameterizedTypeName.get(ClassName.get(jsonType), TypeVariableName.get("?")));
        return FieldSpec.builder(parameterizedTypeName, name, Modifier.PRIVATE, Modifier.FINAL).initializer("new $T<>()", HashMap.class).build();
    }

    private String packageOf(Element configuration) {
        return this.processingEnv.getElementUtils().getPackageOf(configuration).getQualifiedName().toString();
    }

    private CodeBlock registerMapperLine(Element element) {
        return this.registerLine(element, MAPPERS);
    }

    private CodeBlock registerReaderLine(Element element) {
        return this.registerLine(element, READERS);
    }

    private CodeBlock registerWriterLine(Element element) {
        return this.registerLine(element, WRITERS);
    }

    private CodeBlock registerLine(Element element, String mapName) {
        String className = this.enclosingName(element) + (this.useInterface(element) ? element.getSimpleName() : "Mapper") + "Impl";
        String packageName = elementUtils.getPackageOf(element).getQualifiedName().toString();
        CodeBlock.Builder typeTokenBuilder = CodeBlock.builder();
        this.addTypeTokenLiteral(typeTokenBuilder, TypeName.get(this.getBeanType(element)));
        return CodeBlock.builder().addStatement(mapName + ".put($L, new " + packageName + "." + className + "())", typeTokenBuilder.build()).build();
    }

    private void addTypeTokenLiteral(CodeBlock.Builder builder, TypeName name) {
        List<TypeName> typeArguments;
        TypeName rawType;
        builder.add("new $T<$L>(", TypeToken.class, name.isPrimitive() ? name.box() : name);
        if (name instanceof ParameterizedTypeName) {
            ParameterizedTypeName parameterizedTypeName = (ParameterizedTypeName)name;
            rawType = parameterizedTypeName.rawType;
            typeArguments = parameterizedTypeName.typeArguments;
        } else if (name instanceof ArrayTypeName) {
            ArrayTypeName arrayTypeName = (ArrayTypeName)name;
            rawType = null;
            typeArguments = Collections.singletonList(arrayTypeName.componentType);
        } else if (name instanceof ClassName || name instanceof TypeName) {
            rawType = name.isPrimitive() ? name.box() : name;
            typeArguments = Collections.emptyList();
        } else {
            throw new IllegalArgumentException("Unsupported type " + name);
        }
        if (rawType == null) {
            builder.add("null", new Object[0]);
        } else {
            builder.add("$T.class", rawType);
        }
        for (TypeName typeArgumentName : typeArguments) {
            builder.add(", ", new Object[0]);
            this.addTypeTokenLiteral(builder, typeArgumentName);
        }
        builder.add(") {}", new Object[0]);
    }

    private String enclosingName(Element element) {
        if (this.useInterface(element)) {
            return element.getEnclosingElement().getSimpleName().toString() + "_";
        }
        String prefix = element.getEnclosingElement().getKind().equals((Object)ElementKind.PACKAGE) ? "" : element.getEnclosingElement().getSimpleName().toString() + "_";
        return prefix + element.getSimpleName().toString() + "_";
    }

    private boolean useInterface(Element element) {
        return this.isAssignableFrom(element, ObjectMapper.class) || this.isAssignableFrom(element, ObjectReader.class) || this.isAssignableFrom(element, ObjectWriter.class);
    }

    private boolean isAssignableFrom(Element element, Class<?> targetClass) {
        return typeUtils.isAssignable(element.asType(), typeUtils.getDeclaredType(elementUtils.getTypeElement(targetClass.getName()), new TypeMirror[0]));
    }

    private TypeMirror getBeanType(Element element) {
        if (this.useInterface(element)) {
            TypeMirror objectReader = ((TypeElement)typeUtils.asElement(element.asType())).getInterfaces().get(0);
            return MoreTypes.asDeclared(objectReader).getTypeArguments().get(0);
        }
        return element.asType();
    }

    @Override
    protected List<Class<?>> supportedAnnotations() {
        return Collections.singletonList(JSONRegistration.class);
    }
}

