/*
 * Decompiled with CFR 0.152.
 */
package org.dominokit.jackson.processor.serialization;

import com.fasterxml.jackson.annotation.ObjectIdGenerator;
import dominojackson.shaded.com.google.auto.common.MoreElements;
import dominojackson.shaded.com.google.auto.common.MoreTypes;
import dominojackson.shaded.com.squareup.javapoet.ArrayTypeName;
import dominojackson.shaded.com.squareup.javapoet.ClassName;
import dominojackson.shaded.com.squareup.javapoet.CodeBlock;
import dominojackson.shaded.com.squareup.javapoet.MethodSpec;
import dominojackson.shaded.com.squareup.javapoet.ParameterizedTypeName;
import dominojackson.shaded.com.squareup.javapoet.TypeName;
import dominojackson.shaded.com.squareup.javapoet.TypeSpec;
import dominojackson.shaded.com.squareup.javapoet.WildcardTypeName;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import org.dominokit.jackson.JsonSerializationContext;
import org.dominokit.jackson.JsonSerializer;
import org.dominokit.jackson.processor.AbstractJsonMapperGenerator;
import org.dominokit.jackson.processor.AbstractMapperProcessor;
import org.dominokit.jackson.processor.BeanIdentityInfo;
import org.dominokit.jackson.processor.ObjectMapperProcessor;
import org.dominokit.jackson.processor.Type;
import org.dominokit.jackson.processor.serialization.FieldSerializerChainBuilder;
import org.dominokit.jackson.processor.serialization.SerializerBuilder;
import org.dominokit.jackson.ser.bean.AbstractBeanJsonSerializer;
import org.dominokit.jackson.ser.bean.AbstractIdentitySerializationInfo;
import org.dominokit.jackson.ser.bean.BeanPropertySerializer;
import org.dominokit.jackson.ser.bean.IdentitySerializationInfo;
import org.dominokit.jackson.ser.bean.ObjectIdSerializer;
import org.dominokit.jackson.ser.bean.PropertyIdentitySerializationInfo;
import org.dominokit.jackson.ser.bean.SubtypeSerializer;
import org.dominokit.jackson.ser.bean.TypeSerializationInfo;

public class AptSerializerBuilder
extends AbstractJsonMapperGenerator {
    public AptSerializerBuilder(String packageName, TypeMirror beanType, Filer filer) {
        super(packageName, beanType, filer);
    }

    @Override
    protected TypeName superClass() {
        return ParameterizedTypeName.get(ClassName.get(AbstractBeanJsonSerializer.class), ClassName.get(this.beanType));
    }

    @Override
    protected String namePostfix() {
        return "BeanJsonSerializerImpl";
    }

    @Override
    protected String targetTypeMethodName() {
        return "getSerializedType";
    }

    @Override
    protected Optional<MethodSpec> initMethod() {
        return this.buildInitSerializersMethod(this.beanType);
    }

    @Override
    protected Set<MethodSpec> moreMethods() {
        HashSet<MethodSpec> methods = new HashSet<MethodSpec>();
        Optional<BeanIdentityInfo> beanIdentityInfo = Type.processIdentity(this.beanType);
        if (beanIdentityInfo.isPresent()) {
            Optional<CodeBlock> serializerType = this.getIdentitySerializerType(beanIdentityInfo.get());
            methods.add(this.buildInitIdentityInfoMethod(serializerType, beanIdentityInfo));
        }
        return methods;
    }

    private Optional<CodeBlock> getIdentitySerializerType(BeanIdentityInfo identityInfo) {
        if (identityInfo.isIdABeanProperty()) {
            return Optional.empty();
        }
        return Optional.of(new FieldSerializerChainBuilder(identityInfo.getType().get()).getInstance(identityInfo.getType().get()));
    }

    private MethodSpec buildInitIdentityInfoMethod(Optional<CodeBlock> serializerType, Optional<BeanIdentityInfo> beanIdentityInfo) {
        return MethodSpec.methodBuilder("initIdentityInfo").addModifiers(Modifier.PROTECTED).addAnnotation(Override.class).returns(ParameterizedTypeName.get(ClassName.get(IdentitySerializationInfo.class), TypeName.get(this.beanType))).addStatement("return $L", this.generateIdentifierSerializationInfo(beanIdentityInfo.get(), serializerType)).build();
    }

    private TypeSpec generateIdentifierSerializationInfo(BeanIdentityInfo identityInfo, Optional<CodeBlock> serializerType) {
        TypeSpec.Builder builder = TypeSpec.anonymousClassBuilder("$L, $S", identityInfo.isAlwaysAsId(), identityInfo.getPropertyName());
        if (identityInfo.isIdABeanProperty()) {
            Map<Element, TypeMirror> fieldsMap = this.orderedFields();
            Optional<Map.Entry> propertyEntry = fieldsMap.entrySet().stream().filter(entry -> ((Element)entry.getKey()).getSimpleName().toString().equals(identityInfo.getPropertyName())).findFirst();
            if (propertyEntry.isPresent()) {
                builder.superclass(ParameterizedTypeName.get(ClassName.get(PropertyIdentitySerializationInfo.class), TypeName.get(this.beanType), Type.wrapperType((TypeMirror)propertyEntry.get().getValue())));
                this.buildBeanPropertySerializerBody(builder, propertyEntry.get());
            } else {
                AbstractMapperProcessor.messager.printMessage(Diagnostic.Kind.ERROR, "Property [" + identityInfo.getPropertyName() + "] not found in type [" + this.beanType.toString() + "]!.");
            }
        } else {
            TypeMirror qualifiedType = identityInfo.getType().get();
            builder.superclass(ParameterizedTypeName.get(ClassName.get(AbstractIdentitySerializationInfo.class), TypeName.get(this.beanType), TypeName.get(qualifiedType)));
            builder.addMethod(MethodSpec.methodBuilder("newSerializer").addModifiers(Modifier.PROTECTED).addAnnotation(Override.class).returns(ParameterizedTypeName.get(ClassName.get(JsonSerializer.class), ObjectMapperProcessor.DEFAULT_WILDCARD)).addStatement("return $L", serializerType.get()).build());
            ParameterizedTypeName generatorType = ParameterizedTypeName.get(ClassName.get(ObjectIdGenerator.class), TypeName.get(qualifiedType));
            ParameterizedTypeName returnType = ParameterizedTypeName.get(ClassName.get(ObjectIdSerializer.class), TypeName.get(qualifiedType));
            builder.addMethod(MethodSpec.methodBuilder("getObjectId").addModifiers(Modifier.PUBLIC).addAnnotation(Override.class).returns(returnType).addParameter(TypeName.get(this.beanType), "bean", new Modifier[0]).addParameter((java.lang.reflect.Type)((Object)JsonSerializationContext.class), "ctx", new Modifier[0]).addStatement("$T generator = new $T().forScope($T.class)", generatorType, identityInfo.getGenerator(), identityInfo.getScope().get()).addStatement("$T scopedGen = ctx.findObjectIdGenerator(generator)", generatorType).beginControlFlow("if (null == scopedGen)", new Object[0]).addStatement("scopedGen = generator.newForSerialization(ctx)", new Object[0]).addStatement("ctx.addGenerator(scopedGen)", new Object[0]).endControlFlow().addStatement("return new $T(scopedGen.generateId(bean), getSerializer())", returnType).build());
        }
        return builder.build();
    }

    private void buildBeanPropertySerializerBody(TypeSpec.Builder builder, Map.Entry<Element, TypeMirror> property) {
        String paramName = "bean";
        AbstractJsonMapperGenerator.AccessorInfo accessorInfo = new SerializerBuilder(AbstractMapperProcessor.typeUtils, this.beanType, property.getKey(), property.getValue()).getterInfo();
        MethodSpec.Builder newSerializerMethodBuilder = MethodSpec.methodBuilder("newSerializer").addModifiers(Modifier.PROTECTED).addAnnotation(Override.class).addStatement("return $L", new FieldSerializerChainBuilder(property.getValue()).getInstance(property.getValue()));
        newSerializerMethodBuilder.returns(ParameterizedTypeName.get(ClassName.get(JsonSerializer.class), ObjectMapperProcessor.DEFAULT_WILDCARD));
        builder.addMethod(newSerializerMethodBuilder.build());
        builder.addMethod(MethodSpec.methodBuilder("getValue").addModifiers(Modifier.PUBLIC).addAnnotation(Override.class).returns(Type.wrapperType(property.getValue())).addParameter(TypeName.get(this.beanType), paramName, new Modifier[0]).addParameter((java.lang.reflect.Type)((Object)JsonSerializationContext.class), "ctx", new Modifier[0]).addStatement("return $L.$L()", paramName, accessorInfo.getName()).build());
    }

    @Override
    protected MethodSpec initSubtypesMethod() {
        if (this.subTypesInfo == null) {
            return MethodSpec.methodBuilder("initMapSubtypeClassToSerializer").addModifiers(Modifier.PROTECTED).addAnnotation(Override.class).returns(ParameterizedTypeName.get(ClassName.get(Map.class), ClassName.get(Class.class), ClassName.get(SubtypeSerializer.class))).addStatement("return $T.emptyMap()", Collections.class).build();
        }
        MethodSpec.Builder builder = MethodSpec.methodBuilder("initMapSubtypeClassToSerializer").addModifiers(Modifier.PROTECTED).addAnnotation(Override.class).returns(ParameterizedTypeName.get(ClassName.get(Map.class), ClassName.get(Class.class), ClassName.get(SubtypeSerializer.class))).addStatement("$T map = new $T($L)", ParameterizedTypeName.get(ClassName.get(Map.class), ClassName.get(Class.class), ClassName.get(SubtypeSerializer.class)), ClassName.get(IdentityHashMap.class), this.subTypesInfo.getSubTypes().size());
        for (Map.Entry<String, TypeMirror> subtypeEntry : this.subTypesInfo.getSubTypes().entrySet()) {
            String pkg = MoreElements.getPackage(MoreTypes.asTypeElement(subtypeEntry.getValue())).getQualifiedName().toString();
            TypeSpec subtypeType = TypeSpec.anonymousClassBuilder("", new Object[0]).superclass(ClassName.get(SubtypeSerializer.BeanSubtypeSerializer.class)).addMethod(MethodSpec.methodBuilder("newSerializer").addModifiers(Modifier.PROTECTED).addAnnotation(Override.class).returns(ParameterizedTypeName.get(ClassName.get(JsonSerializer.class), WildcardTypeName.subtypeOf(Object.class))).addStatement("return new $L()", ClassName.bestGuess(Type.serializerName(pkg, subtypeEntry.getValue()))).build()).build();
            builder.addStatement("map.put($T.class, $L)", TypeName.get(subtypeEntry.getValue()), subtypeType);
        }
        builder.addStatement("return map", new Object[0]);
        return builder.build();
    }

    private Optional<MethodSpec> buildInitSerializersMethod(TypeMirror beanType) {
        if (this.isAbstract(beanType)) {
            return Optional.empty();
        }
        int[] index = new int[]{0};
        Map<Element, TypeMirror> fields = this.orderedFields();
        MethodSpec.Builder builder = MethodSpec.methodBuilder("initSerializers").addModifiers(Modifier.PROTECTED).addAnnotation(Override.class).returns(TypeName.get(BeanPropertySerializer[].class)).addStatement("$T result = new $T[$L]", ArrayTypeName.of(BeanPropertySerializer.class), BeanPropertySerializer.class, fields.size());
        fields.entrySet().stream().filter(entry -> this.isEligibleForSerializationDeserialization((Element)entry.getKey())).forEach(entry -> {
            Object[] objectArray = new Object[2];
            int n = index[0];
            index[0] = n + 1;
            objectArray[0] = n;
            objectArray[1] = new SerializerBuilder(AbstractMapperProcessor.typeUtils, beanType, (Element)entry.getKey(), (TypeMirror)entry.getValue()).buildSerializer();
            builder.addStatement("result[$L] = $L", objectArray);
        });
        builder.addStatement("return result", new Object[0]);
        return Optional.of(builder.build());
    }

    @Override
    protected Class<?> getMapperType() {
        return TypeSerializationInfo.class;
    }
}

