/*
 * Decompiled with CFR 0.152.
 */
package org.dominokit.jackson.processor.serialization;

import dominojackson.shaded.com.google.auto.common.MoreElements;
import dominojackson.shaded.com.google.auto.common.MoreTypes;
import dominojackson.shaded.com.squareup.javapoet.ClassName;
import dominojackson.shaded.com.squareup.javapoet.CodeBlock;
import dominojackson.shaded.com.squareup.javapoet.TypeName;
import java.util.Deque;
import java.util.LinkedList;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeMirror;
import org.dominokit.jackson.processor.MappersChainBuilder;
import org.dominokit.jackson.processor.Type;
import org.dominokit.jackson.processor.TypeRegistry;
import org.dominokit.jackson.ser.CollectionJsonSerializer;
import org.dominokit.jackson.ser.EnumJsonSerializer;
import org.dominokit.jackson.ser.IterableJsonSerializer;
import org.dominokit.jackson.ser.array.ArrayJsonSerializer;
import org.dominokit.jackson.ser.array.dd.Array2dJsonSerializer;
import org.dominokit.jackson.ser.map.MapJsonSerializer;

public class FieldSerializerChainBuilder
implements MappersChainBuilder {
    private static final String GET_INSTANCE = "$T.getInstance()";
    private static final String NEW_INSTANCE = "$T.newInstance(";
    private boolean rootGenerated;
    private CodeBlock.Builder builder = CodeBlock.builder();
    private Deque<TypeName> serializers = new LinkedList<TypeName>();
    private final TypeMirror beanType;

    public FieldSerializerChainBuilder(TypeMirror beanType) {
        this.beanType = beanType;
        this.rootGenerated = true;
    }

    public FieldSerializerChainBuilder(TypeMirror beanType, boolean rootGenerated) {
        this.beanType = beanType;
        this.rootGenerated = rootGenerated;
    }

    @Override
    public CodeBlock getInstance(Element field) {
        return this.builder.add(this.getFieldSerializer(field.asType()), this.asClassesArray()).build();
    }

    @Override
    public CodeBlock getInstance(TypeMirror fieldType) {
        return this.builder.add(this.getFieldSerializer(fieldType), this.asClassesArray()).build();
    }

    private TypeName[] asClassesArray() {
        return this.serializers.toArray(new TypeName[this.serializers.size()]);
    }

    private String getFieldSerializer(TypeMirror typeMirror) {
        if (Type.isCollection(typeMirror = Type.removeOuterWildCards(typeMirror))) {
            return this.getCollectionSerializer(typeMirror);
        }
        if (Type.isIterable(typeMirror)) {
            return this.getIterableSerializer(typeMirror);
        }
        if (Type.isMap(typeMirror)) {
            return this.getMapSerializer(typeMirror);
        }
        if (Type.isArray(typeMirror)) {
            return this.getArraySerializer(typeMirror);
        }
        if (Type.isEnum(typeMirror)) {
            return this.getEnumSerializer();
        }
        return this.getBasicOrCustomSerializer(typeMirror);
    }

    private String getBasicOrCustomSerializer(TypeMirror typeMirror) {
        if (Type.isBasicType(typeMirror)) {
            return this.getBasicSerializer(typeMirror);
        }
        return this.getCustomSerializer(typeMirror);
    }

    private String getCustomSerializer(TypeMirror typeMirror) {
        if (Type.stringifyTypeWithPackage(typeMirror).equals(Type.stringifyTypeWithPackage(this.beanType)) && this.rootGenerated) {
            this.serializers.addLast(ClassName.bestGuess(Type.serializerName(this.getPackageName(typeMirror), typeMirror)));
        } else if (TypeRegistry.containsSerializer(Type.stringifyTypeWithPackage(typeMirror))) {
            this.serializers.addLast(TypeRegistry.getCustomSerializer(typeMirror));
        } else {
            TypeRegistry.registerSerializer(Type.stringifyTypeWithPackage(typeMirror), ClassName.bestGuess(this.generateCustomSerializer(typeMirror)));
            this.serializers.addLast(TypeRegistry.getCustomSerializer(typeMirror));
            this.rootGenerated = true;
        }
        return "new $T()";
    }

    private String getPackageName(TypeMirror typeMirror) {
        return MoreElements.getPackage(MoreTypes.asTypeElement(typeMirror)).getQualifiedName().toString();
    }

    private String generateCustomSerializer(TypeMirror typeMirror) {
        if (TypeRegistry.containsSerializer(typeMirror) || TypeRegistry.isInActiveGenSerializer(typeMirror)) {
            return Type.serializerName(this.getPackageName(typeMirror), typeMirror);
        }
        TypeRegistry.addInActiveGenSerializer(typeMirror);
        String serializerName = Type.generateSerializer(typeMirror);
        TypeRegistry.removeInActiveGenSerializer(typeMirror);
        return serializerName;
    }

    private String getEnumSerializer() {
        this.serializers.addLast(TypeName.get(EnumJsonSerializer.class));
        return GET_INSTANCE;
    }

    private String getBasicSerializer(TypeMirror typeMirror) {
        this.serializers.addLast(TypeRegistry.getSerializer(typeMirror));
        return GET_INSTANCE;
    }

    private String getMapSerializer(TypeMirror typeMirror) {
        this.serializers.addLast(TypeName.get(MapJsonSerializer.class));
        return NEW_INSTANCE + this.getKeySerializer(Type.firstTypeArgument(typeMirror)) + ", " + this.getFieldSerializer(Type.secondTypeArgument(typeMirror)) + ")";
    }

    private String getKeySerializer(TypeMirror typeMirror) {
        if (Type.isEnum(typeMirror = Type.removeOuterWildCards(typeMirror))) {
            this.serializers.addLast(TypeRegistry.getKeySerializer(Enum.class.getName()));
        } else {
            this.serializers.addLast(TypeRegistry.getKeySerializer(Type.stringifyTypeWithPackage(Type.removeOuterWildCards(typeMirror))));
        }
        return GET_INSTANCE;
    }

    private String getCollectionSerializer(TypeMirror typeMirror) {
        this.serializers.addLast(TypeName.get(CollectionJsonSerializer.class));
        return NEW_INSTANCE + this.getFieldSerializer(Type.firstTypeArgument(typeMirror)) + ")";
    }

    private String getIterableSerializer(TypeMirror typeMirror) {
        this.serializers.addLast(TypeName.get(IterableJsonSerializer.class));
        return NEW_INSTANCE + this.getFieldSerializer(Type.firstTypeArgument(typeMirror)) + ")";
    }

    private String getArraySerializer(TypeMirror typeMirror) {
        if (Type.isPrimitiveArray(typeMirror)) {
            return this.getBasicSerializer(typeMirror);
        }
        if (Type.is2dArray(typeMirror)) {
            this.serializers.addLast(TypeName.get(Array2dJsonSerializer.class));
            return NEW_INSTANCE + this.getFieldSerializer(Type.deepArrayComponentType(typeMirror)) + ")";
        }
        this.serializers.addLast(TypeName.get(ArrayJsonSerializer.class));
        return NEW_INSTANCE + this.getFieldSerializer(Type.arrayComponentType(typeMirror)) + ")";
    }
}

