/*
 * Decompiled with CFR 0.152.
 */
package org.dominokit.jackson.processor.serialization;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import dominojackson.shaded.com.squareup.javapoet.ClassName;
import dominojackson.shaded.com.squareup.javapoet.MethodSpec;
import dominojackson.shaded.com.squareup.javapoet.ParameterizedTypeName;
import dominojackson.shaded.com.squareup.javapoet.TypeName;
import dominojackson.shaded.com.squareup.javapoet.TypeSpec;
import java.util.Objects;
import java.util.Optional;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.dominokit.jackson.JacksonContextProvider;
import org.dominokit.jackson.JsonSerializationContext;
import org.dominokit.jackson.JsonSerializer;
import org.dominokit.jackson.JsonSerializerParameters;
import org.dominokit.jackson.processor.AbstractJsonMapperGenerator;
import org.dominokit.jackson.processor.AccessorsFilter;
import org.dominokit.jackson.processor.ObjectMapperProcessor;
import org.dominokit.jackson.processor.Type;
import org.dominokit.jackson.processor.serialization.FieldSerializerChainBuilder;
import org.dominokit.jackson.ser.bean.BeanPropertySerializer;
import org.dominokit.jackson.stream.impl.DefaultJsonWriter;

class SerializerBuilder
extends AccessorsFilter {
    private final TypeMirror beanType;
    private final Element field;
    private final TypeMirror fieldType;

    SerializerBuilder(Types typeUtils, TypeMirror beanType, Element field, TypeMirror fieldType) {
        super(typeUtils);
        this.beanType = beanType;
        this.field = field;
        this.fieldType = fieldType;
    }

    TypeSpec buildSerializer() {
        String paramBean = "bean";
        TypeSpec.Builder builder = TypeSpec.anonymousClassBuilder("\"$L\"", DefaultJsonWriter.encodeString((String)this.getPropertyName(this.field))).superclass(ParameterizedTypeName.get(ClassName.get(BeanPropertySerializer.class), TypeName.get(this.beanType), Type.wrapperType(this.fieldType)));
        builder.addMethod(this.buildSerializerMethod());
        if (this.shouldAddParametersMethod()) {
            builder.addMethod(this.buildParametersMethod());
        }
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder("getValue").returns(Type.wrapperType(this.fieldType)).addModifiers(Modifier.PUBLIC).addAnnotation(Override.class).addParameter(ClassName.get(this.beanType), "bean", new Modifier[0]);
        AbstractJsonMapperGenerator.AccessorInfo accessorInfo = this.getterInfo();
        methodBuilder.addParameter((java.lang.reflect.Type)((Object)JsonSerializationContext.class), "ctx", new Modifier[0]).addStatement("return $L", "bean." + accessorInfo.getName() + (accessorInfo.method.isPresent() ? "()" : ""));
        builder.addMethod(methodBuilder.build());
        return builder.build();
    }

    private boolean shouldAddParametersMethod() {
        return Objects.nonNull(this.field.getAnnotation(JsonFormat.class)) || Objects.nonNull(this.field.getAnnotation(JsonInclude.class)) || this.hasTypeJsonInclude();
    }

    private MethodSpec buildSerializerMethod() {
        return MethodSpec.methodBuilder("newSerializer").addModifiers(Modifier.PROTECTED).addAnnotation(Override.class).returns(ParameterizedTypeName.get(ClassName.get(JsonSerializer.class), ObjectMapperProcessor.DEFAULT_WILDCARD)).addStatement("return $L", new FieldSerializerChainBuilder(this.beanType).getInstance(this.fieldType)).build();
    }

    private MethodSpec buildParametersMethod() {
        JsonFormat jsonFormat = this.field.getAnnotation(JsonFormat.class);
        JsonInclude jsonInclude = this.getJsonInclude();
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder("newParameters").addModifiers(Modifier.PROTECTED).addAnnotation(Override.class).returns((java.lang.reflect.Type)((Object)JsonSerializerParameters.class)).addStatement("$T parameters = $T.get().newSerializerParameters()", TypeName.get(JsonSerializerParameters.class), TypeName.get(JacksonContextProvider.class));
        if (Objects.nonNull(jsonFormat)) {
            methodBuilder.addStatement("parameters.setPattern($S).setShape($T.$L)", jsonFormat.pattern(), TypeName.get(JsonFormat.Shape.class), jsonFormat.shape().toString());
        }
        if (Objects.nonNull(jsonInclude)) {
            methodBuilder.addStatement("parameters.setInclude($T.$L)", TypeName.get(JsonInclude.Include.class), jsonInclude.value().toString());
        }
        return methodBuilder.addStatement("return parameters", new Object[0]).build();
    }

    private JsonInclude getJsonInclude() {
        if (Objects.nonNull(this.field.getAnnotation(JsonInclude.class))) {
            return this.field.getAnnotation(JsonInclude.class);
        }
        return this.beanType.getKind() == TypeKind.DECLARED ? this.getJsonInclude((DeclaredType)this.beanType) : null;
    }

    private JsonInclude getJsonInclude(DeclaredType enclosingType) {
        TypeElement enclosingElement = (TypeElement)enclosingType.asElement();
        return enclosingElement.getAnnotation(JsonInclude.class);
    }

    private boolean hasTypeJsonInclude() {
        if (this.beanType.getKind() == TypeKind.DECLARED) {
            return ((DeclaredType)this.beanType).asElement().getAnnotation(JsonInclude.class) != null;
        }
        return false;
    }

    AbstractJsonMapperGenerator.AccessorInfo getterInfo() {
        String upperCaseFirstLetter = this.upperCaseFirstLetter(this.field.getSimpleName().toString());
        String prefix = this.field.asType().getKind() == TypeKind.BOOLEAN ? "is" : "get";
        Optional<AbstractJsonMapperGenerator.AccessorInfo> accessor = this.getAccessors(this.beanType).stream().filter(accessorInfo -> accessorInfo.getName().equals(prefix + upperCaseFirstLetter)).findFirst();
        return accessor.orElseGet(() -> new AbstractJsonMapperGenerator.AccessorInfo(this.field.getSimpleName().toString()));
    }

    private String upperCaseFirstLetter(String name) {
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }
}

