/*
 * Copyright 2013 Nicolas Morel
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.dominokit.jackson;

/**
 * Base implementation of {@link org.dominokit.jackson.ObjectReader}. Extends {@link
 * org.dominokit.jackson.AbstractObjectMapper} to avoid code duplication, trying to write with this
 * reader will result in an {@link java.lang.UnsupportedOperationException}.
 */
public abstract class AbstractObjectReader<T> extends AbstractObjectMapper<T>
    implements ObjectReader<T> {

  /**
   * Constructor for AbstractObjectReader.
   *
   * @param rootName a {@link java.lang.String} object.
   */
  public AbstractObjectReader(String rootName) {
    super(rootName);
  }

  /** {@inheritDoc} */
  @Override
  protected final JsonSerializer<?> newSerializer() {
    throw new UnsupportedOperationException("ObjectReader doesn't support serialization");
  }
}
