/*
 * Decompiled with CFR 0.152.
 */
package org.dominokit.domino.test.api.client;

import io.vertx.core.json.JsonObject;
import io.vertx.ext.unit.TestContext;
import org.dominokit.domino.test.api.client.ClientContext;
import org.dominokit.domino.test.api.client.DominoTest;
import org.dominokit.domino.test.api.client.DominoTestClient;
import org.dominokit.domino.test.api.client.DominoTestConfig;
import org.dominokit.domino.test.api.client.TestRoutingListener;
import org.junit.Before;

public abstract class DominoTestCase
implements DominoTest {
    protected DominoTestClient testClient;
    private DominoTestConfig testConfig;
    private TestContext testContext;
    protected ClientContext clientContext;
    protected TestRoutingListener requests;

    public DominoTestCase(DominoTestConfig testConfig) {
        this.testConfig = testConfig;
    }

    @Before
    public void prepareTestClient(TestContext testContext) {
        this.testContext = testContext;
        this.testClient = (DominoTestClient)DominoTestClient.useModules(this.testConfig.getModules());
        this.testClient.setTestContext(testContext);
        this.clientContext = this.testClient;
        this.testClient.onBeforeClientStart(clientContext -> {
            this.testConfig.bindSpies(this);
            this.testConfig.bindFakeViews(this);
            this.requests = clientContext.getDefaultRoutingListener();
            this.onBeforeClientStart(clientContext, testContext);
        }).onClientStarted(context -> this.onClientStarted(this.clientContext, testContext));
    }

    @Override
    public DominoTestClient getTestClient() {
        return this.testClient;
    }

    @Override
    public JsonObject getAdditionalConfig() {
        return new JsonObject();
    }

    @Override
    public void onBeforeClientStart(ClientContext clientContext, TestContext testContext) {
        this.testConfig.onBeforeClientStart(this, clientContext, testContext);
    }

    @Override
    public void onClientStarted(ClientContext clientContext, TestContext testContext) {
        this.testConfig.onClientStarted(this, clientContext, testContext);
    }

    @Override
    public ClientContext getClientContext() {
        return this.clientContext;
    }

    @Override
    public TestContext getTestContext() {
        return this.testContext;
    }
}

